/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.base.command;

import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.transaction.xa.Xid;
import org.ikasan.connector.base.command.TransactionalResourceCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XidImpl
implements Xid {
    private Long id;
    private byte[] globalTransactionId;
    private byte[] branchQualifier;
    private int formatId;
    private String state = "test";
    private String clientId;
    private Set<TransactionalResourceCommand> commands = new LinkedHashSet<TransactionalResourceCommand>();
    private Date createdDateTime;
    private Date lastUpdatedDateTime;

    public XidImpl(byte[] globalTransactionId, byte[] branchQualifier, int formatId) {
        this.globalTransactionId = globalTransactionId;
        this.branchQualifier = branchQualifier;
        this.formatId = formatId;
        this.createdDateTime = new Date();
        this.lastUpdatedDateTime = new Date();
    }

    public XidImpl(Xid xid) {
        this(xid.getGlobalTransactionId(), xid.getBranchQualifier(), xid.getFormatId());
    }

    public XidImpl() {
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    protected String getBranchQualifierString() {
        return new String(this.branchQualifier);
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    protected String getGlobalTransactionIdString() {
        return new String(this.globalTransactionId);
    }

    protected void setBranchQualifierString(String branchQualifierAsString) {
        this.branchQualifier = branchQualifierAsString.getBytes();
    }

    protected void setGlobalTransactionIdString(String globalTransactionIdAsString) {
        this.globalTransactionId = globalTransactionIdAsString.getBytes();
    }

    private void setFormatId(int formatId) {
        this.formatId = formatId;
    }

    public void addCommand(TransactionalResourceCommand transactionalResourceCommand) {
        this.commands.add(transactionalResourceCommand);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("XidImpl [");
        sb.append("formattedGlobalTransactionId");
        sb.append(this.getFormattedGlobalTransactionId());
        sb.append(",");
        sb.append("formattedBranchQualifier");
        sb.append(this.getFormattedBranchQualifier());
        sb.append(",");
        sb.append("commands");
        sb.append(this.commands);
        sb.append(",");
        sb.append("formatId");
        sb.append(this.formatId);
        sb.append(",");
        sb.append("state");
        sb.append(this.state);
        sb.append(",");
        sb.append("id");
        sb.append(this.id);
        sb.append("]");
        return sb.toString();
    }

    private String getFormattedBranchQualifier() {
        return new String(this.branchQualifier);
    }

    private String getFormattedGlobalTransactionId() {
        return new String(this.globalTransactionId);
    }

    public Set<TransactionalResourceCommand> getCommands() {
        return this.commands;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Date getCreatedDateTime() {
        return this.createdDateTime;
    }

    public void setCreatedDateTime(Date createdDateTime) {
        this.createdDateTime = createdDateTime;
    }

    public Date getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public void setLastUpdatedDateTime(Date lastUpdatedDateTime) {
        this.lastUpdatedDateTime = lastUpdatedDateTime;
    }
}

