/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.base.command.state;

import java.util.HashMap;
import java.util.Map;
import org.ikasan.connector.base.command.state.State;
import org.ikasan.connector.base.command.state.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateManager {
    private Map<State, Map<String, State>> allowableTransitions = new HashMap<State, Map<String, State>>();
    private Map<String, State> allStates = new HashMap<String, State>();

    public void addTransition(Transition t) {
        Map<String, State> stateValidTransitions = this.getStateValidTransitions(t.getStartState());
        stateValidTransitions.put(t.getAction(), t.getEndState());
        this.allowableTransitions.put(t.getStartState(), stateValidTransitions);
        this.addState(t.getStartState());
        this.addState(t.getEndState());
    }

    private void addState(State state) {
        this.allStates.put(state.getName(), state);
    }

    public State getState(String name) {
        return this.allStates.get(name);
    }

    private Map<String, State> getStateValidTransitions(State startState) {
        Map<String, State> result = this.allowableTransitions.get(startState);
        if (result == null) {
            result = new HashMap<String, State>();
        }
        return result;
    }

    public boolean isValidTransition(State startState, String action) {
        boolean result = false;
        State endState = this.getEndState(startState, action);
        if (endState != null) {
            result = true;
        }
        return result;
    }

    public State getEndState(State startState, String action) {
        State endState;
        State result = null;
        Map<String, State> stateValidTransitions = this.getStateValidTransitions(startState);
        if (stateValidTransitions != null && (endState = stateValidTransitions.get(action)) != null) {
            result = endState;
        }
        return result;
    }

    public String toString() {
        return this.allowableTransitions.toString();
    }
}

