/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.base.journal;

import java.util.Date;
import java.util.List;
import javax.transaction.xa.Xid;
import org.apache.log4j.Logger;
import org.ikasan.connector.base.command.TransactionalResourceCommand;
import org.ikasan.connector.base.command.TransactionalResourceCommandDAO;
import org.ikasan.connector.base.command.TransactionalResourceCommandPersistenceException;
import org.ikasan.connector.base.command.XidImpl;
import org.ikasan.connector.base.journal.TransactionJournal;
import org.ikasan.connector.base.journal.TransactionJournalingException;
import org.springframework.beans.factory.BeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionJournalImpl
implements TransactionJournal {
    private static Logger logger = Logger.getLogger(TransactionJournalImpl.class);
    private TransactionalResourceCommandDAO dao;
    private BeanFactory beanFactory;
    private String clientId;

    public TransactionJournalImpl(TransactionalResourceCommandDAO dao, String clientId, BeanFactory beanFactory) {
        this.dao = dao;
        this.beanFactory = beanFactory;
        this.clientId = clientId;
    }

    @Override
    public void notifyUpdate(TransactionalResourceCommand command) throws TransactionJournalingException {
        logger.debug((Object)("Journal notified of command update, command class is [" + command.getClass() + "] state is [" + command.getState() + "]"));
        try {
            this.dao.save(command);
        }
        catch (TransactionalResourceCommandPersistenceException e) {
            throw new TransactionJournalingException("Exception saving command [" + command + "]", e);
        }
    }

    @Override
    public List<TransactionalResourceCommand> getCommands(Xid xid) throws TransactionJournalingException {
        List<TransactionalResourceCommand> commands = null;
        try {
            commands = this.dao.findCommandsByTransaction(xid);
            for (TransactionalResourceCommand command : commands) {
                command.setTransactionJournal(this);
                command.setBeanFactory(this.beanFactory);
            }
        }
        catch (TransactionalResourceCommandPersistenceException e) {
            logger.error((Object)e);
            throw new TransactionJournalingException("Exception finding commands for Xid [" + xid + "]", e);
        }
        return commands;
    }

    @Override
    public Xid[] getExecutedTransactions() throws TransactionJournalingException {
        Xid[] result;
        try {
            List<XidImpl> preparedXids = this.dao.findXidbyState("prepare");
            result = preparedXids.toArray(new Xid[0]);
        }
        catch (TransactionalResourceCommandPersistenceException e) {
            throw new TransactionJournalingException("Exception finding executed transactions", e);
        }
        return result;
    }

    @Override
    public XidImpl resolveXid(Xid xid) throws TransactionJournalingException {
        XidImpl result = null;
        try {
            result = this.dao.find(xid);
        }
        catch (TransactionalResourceCommandPersistenceException e) {
            throw new TransactionJournalingException("Exception finding persisted Xid [" + xid + "]", e);
        }
        return result;
    }

    @Override
    public void onXAEvent(Xid xid, String state) throws TransactionJournalingException {
        logger.debug((Object)("xid = [" + xid + "] state = [" + state + "]"));
        XidImpl xidImpl = null;
        if ("start".equals(state)) {
            this.createXid(xid);
        } else {
            xidImpl = this.resolveXid(xid);
            if (xidImpl == null) {
                throw new TransactionJournalingException("Could not resolve XidImpl for [" + xid + "]", null);
            }
            xidImpl.setState(state);
            xidImpl.setLastUpdatedDateTime(new Date());
            try {
                this.dao.save(xidImpl);
            }
            catch (TransactionalResourceCommandPersistenceException e) {
                throw new TransactionJournalingException("Exception persisting Xid", e);
            }
        }
    }

    private void createXid(Xid xid) throws TransactionJournalingException {
        XidImpl xidImpl = new XidImpl(xid);
        xidImpl.setClientId(this.clientId);
        try {
            XidImpl beforeFound = this.dao.find(xidImpl);
            logger.debug((Object)("before create, found  Xid [" + beforeFound + "]"));
            this.dao.save(xidImpl);
            logger.debug((Object)("saved new Xid matching [" + xid + "], id is [" + xidImpl.getId() + "]"));
            XidImpl afterFound = this.dao.find(xidImpl);
            logger.debug((Object)("end create, found just added Xid [" + afterFound + "]"));
        }
        catch (TransactionalResourceCommandPersistenceException e) {
            throw new TransactionJournalingException("Exception persisting new Xid", e);
        }
    }

    @Override
    public void cleanup(Xid xid) throws TransactionJournalingException {
        List<TransactionalResourceCommand> commands = this.getCommands(xid);
        try {
            for (TransactionalResourceCommand command : commands) {
                this.dao.deleteCommand(command);
            }
            this.dao.deleteXid(this.resolveXid(xid));
        }
        catch (TransactionalResourceCommandPersistenceException e) {
            throw new TransactionJournalingException("Exception cleaning up transaction journal", e);
        }
    }
}

