/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.base.outbound;

import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;
import javax.resource.spi.ManagedConnection;
import org.apache.log4j.Logger;
import org.ikasan.connector.base.ConnectionState;
import org.ikasan.connector.base.outbound.EISConnection;
import org.ikasan.connector.base.outbound.EISManagedConnection;

public abstract class EISConnectionImpl
implements EISConnection {
    private static Logger logger = Logger.getLogger(EISConnectionImpl.class);
    protected ManagedConnection managedConnection;

    public EISConnectionImpl(ManagedConnection managedConnection) {
        this.managedConnection = managedConnection;
    }

    public void invalidate() {
        logger.debug((Object)"Called invalidate()");
        this.managedConnection = null;
    }

    public abstract void close();

    public void setManager(ManagedConnection managedConnection) {
        logger.debug((Object)"Called setManager()");
        this.managedConnection = managedConnection;
    }

    public boolean getAutoCommit() {
        return ((EISManagedConnection)this.managedConnection).getAutoCommit();
    }

    public void setAutoCommit(boolean flag) {
        ((EISManagedConnection)this.managedConnection).setAutoCommit(flag);
    }

    public abstract void validate() throws ResourceException;

    public Interaction createInteraction() {
        return null;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException("CCI Local Transaction is not supported.");
    }

    public ConnectionMetaData getMetaData() {
        return null;
    }

    public ResultSetInfo getResultSetInfo() {
        return null;
    }

    public ConnectionState getConnectionState() {
        if (this.managedConnection == null) {
            return ConnectionState.DISCONNECTED;
        }
        return ((EISManagedConnection)this.managedConnection).getConnectionState();
    }
}

