/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.base.outbound;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.naming.NamingException;
import javax.resource.cci.ConnectionSpec;
import org.apache.log4j.Logger;
import org.ikasan.common.ExceptionType;
import org.ikasan.connector.ConnectorContext;
import org.ikasan.connector.ConnectorExceptionType;
import org.ikasan.connector.ConnectorRuntimeException;
import org.ikasan.connector.ResourceLoader;
import org.ikasan.connector.base.outbound.EISConnectionProperties;

public abstract class EISConnectionSpec
implements ConnectionSpec,
EISConnectionProperties {
    private static Logger logger = Logger.getLogger(EISConnectionSpec.class);
    private static final String DEFAULT_SESSION_PROPERTIES = "session";
    protected ConnectorContext context = ResourceLoader.getInstance().newContext();
    private String clientID;

    public EISConnectionSpec() {
    }

    public EISConnectionSpec(ResourceBundle bundle) {
        try {
            this.setClientID(bundle.getString("clientID"));
        }
        catch (MissingResourceException e) {
            logger.debug((Object)"[clientID] not specified. Default from ra.xml will be used.");
        }
    }

    public String getClientID() {
        logger.debug((Object)("Getting clientID [" + this.clientID + "]"));
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
        logger.debug((Object)("Setting clientID [" + this.clientID + "]"));
    }

    public ResourceBundle loadSessionProps(String sessionPropertiesHandle) {
        String sessionProperties = null;
        try {
            sessionProperties = (String)this.context.lookup(sessionPropertiesHandle);
            if (sessionProperties == null || sessionProperties.trim().length() == 0) {
                throw new NamingException("Context SessionPropertiesHandle [" + sessionPropertiesHandle + "] is is empty.");
            }
            return ResourceBundle.getBundle(sessionProperties, Locale.getDefault(), this.getClass().getClassLoader());
        }
        catch (NamingException e) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                return ResourceBundle.getBundle(sessionPropertiesHandle, Locale.getDefault(), classLoader);
            }
            catch (MissingResourceException e1) {
                try {
                    return ResourceBundle.getBundle(DEFAULT_SESSION_PROPERTIES, Locale.getDefault(), this.getClass().getClassLoader());
                }
                catch (MissingResourceException e2) {
                    throw new ConnectorRuntimeException(e2, (ExceptionType)ConnectorExceptionType.MISSING_RESOURCE);
                }
            }
        }
    }
}

