/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.base.outbound;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.apache.log4j.Logger;
import org.ikasan.connector.base.ConnectionState;
import org.ikasan.connector.base.outbound.EISConnection;

public abstract class EISManagedConnection
implements ManagedConnection {
    private static Logger logger = Logger.getLogger(EISManagedConnection.class);
    private PrintWriter writer = null;
    protected String clientID;
    protected ConnectionState connectionState = ConnectionState.DISCONNECTED;
    protected boolean autoCommit;
    protected boolean destroyed;
    protected Set<Connection> connections = new HashSet<Connection>();
    protected Set<ConnectionEventListener> connectionListeners = new HashSet<ConnectionEventListener>();
    protected ManagedConnectionFactory managedConnectionFactory;

    public abstract Object getConnection(Subject var1, ConnectionRequestInfo var2);

    public abstract void cleanup() throws ResourceException;

    public abstract void destroy() throws ResourceException;

    public void setManagedConnectionFactory(ManagedConnectionFactory managedConnectionFactory) {
        this.managedConnectionFactory = managedConnectionFactory;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionEventListener(ConnectionEventListener listener) {
        logger.info((Object)"Called addConnectionEventListener()");
        Set<ConnectionEventListener> set = this.connectionListeners;
        synchronized (set) {
            this.connectionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        logger.info((Object)"Called removeConnectionEventListener()");
        Set<ConnectionEventListener> set = this.connectionListeners;
        synchronized (set) {
            this.connectionListeners.remove(listener);
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    protected void throwIfDestroyed() throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("ManagedConnection is destroyed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(EISConnection connection) {
        logger.debug((Object)"Called addConnection()");
        Set<Connection> set = this.connections;
        synchronized (set) {
            this.connections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(EISConnection connection) {
        logger.debug((Object)"Called removeConnection()");
        Set<Connection> set = this.connections;
        synchronized (set) {
            this.connections.remove(connection);
        }
    }

    public void sendClosedEvent(EISConnection connection) {
        logger.debug((Object)"Called sendClosedEvent()");
        Iterator<ConnectionEventListener> it = this.connectionListeners.iterator();
        while (it.hasNext()) {
            logger.debug((Object)"Informing the connection listener that the connection is closed.");
            ConnectionEventListener listener = it.next();
            if (listener == null) continue;
            ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 1);
            ce.setConnectionHandle((Object)connection);
            listener.connectionClosed(ce);
        }
        logger.debug((Object)"Finished notifying connection event listeners.");
    }

    protected void sendErrorEvent(Throwable thrown) {
        logger.debug((Object)"Called sendErrorEvent");
        if (this.isDestroyed()) {
            logger.debug((Object)("Not sending ErrorEvent as this connection is already destroyed " + this));
            return;
        }
        Exception e = null;
        e = thrown instanceof Exception ? (Exception)thrown : new ResourceAdapterInternalException("Unexpected error", thrown);
        for (ConnectionEventListener listener : this.connectionListeners) {
            ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 5, e);
            listener.connectionErrorOccurred(ce);
        }
    }

    public PrintWriter getLogWriter() {
        logger.debug((Object)"Getting logWriter...");
        return this.writer;
    }

    public void setLogWriter(PrintWriter writer) {
        this.writer = writer;
        logger.debug((Object)"Setting logWriter...");
    }

    public abstract void associateConnection(Object var1) throws ResourceException;

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException("Local Managed Connection must be implemented to support Local Transactions.");
    }

    public abstract ManagedConnectionMetaData getMetaData() throws ResourceException;

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException("XA Managed Connection must be implemented to support XA Transactions.");
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    protected final void setConnectionState(ConnectionState connectionState) {
        this.connectionState = connectionState;
    }
}

