/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.base.outbound;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.ikasan.common.CommonXMLParser;
import org.ikasan.connector.ConnectorContext;
import org.ikasan.connector.ConnectorEnvironment;
import org.ikasan.connector.ConnectorXMLParser;
import org.ikasan.connector.ConnectorXMLTransformer;
import org.ikasan.connector.ConnectorXSLTransformer;
import org.ikasan.connector.ResourceLoader;

public abstract class EISManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable {
    private static Logger logger = Logger.getLogger(EISManagedConnectionFactory.class);
    private static final long serialVersionUID = 1L;
    private PrintWriter writer = null;
    protected String clientID;
    protected String sessionFactoryName;
    protected String localSessionFactoryName;
    protected String xaSessionFactoryName;
    protected ConnectorContext connectorContext = ResourceLoader.getInstance().newContext();
    protected ConnectorXMLParser xmlParser = ResourceLoader.getInstance().newXMLParser();
    protected ConnectorXMLTransformer xmltransformer = ResourceLoader.getInstance().newXMLTransformer();
    protected ConnectorXSLTransformer xsltransformer = ResourceLoader.getInstance().newXSLTransformer();
    protected ConnectorEnvironment connectorEnv = ResourceLoader.getInstance().newEnvironment();

    public abstract Object createConnectionFactory(ConnectionManager var1) throws ResourceException;

    public abstract Object createConnectionFactory() throws ResourceException;

    public abstract ManagedConnection createManagedConnection(Subject var1, ConnectionRequestInfo var2) throws ResourceException;

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract ManagedConnection matchManagedConnections(Set var1, Subject var2, ConnectionRequestInfo var3);

    public PrintWriter getLogWriter() {
        logger.debug((Object)"Getting logWriter...");
        return this.writer;
    }

    public void setLogWriter(PrintWriter writer) {
        this.writer = writer;
        logger.debug((Object)"Setting logWriter...");
    }

    public ConnectorContext getConnectorContext() {
        logger.debug((Object)"Getting connectorContext...");
        return this.connectorContext;
    }

    public ConnectorEnvironment getConnectorEnv() {
        logger.debug((Object)("Getting connectorEnv [" + this.connectorEnv + "]"));
        return this.connectorEnv;
    }

    public CommonXMLParser getXmlParser() {
        logger.debug((Object)("Getting xmlparser [" + this.xmlParser + "]"));
        return this.xmlParser;
    }

    public ConnectorXMLTransformer getXmlTransformer() {
        logger.debug((Object)("Getting xmltransformer [" + this.xmltransformer + "]"));
        return this.xmltransformer;
    }

    public ConnectorXSLTransformer getXslTransformer() {
        logger.debug((Object)("Getting xsltransformer [" + this.xsltransformer + "]"));
        return this.xsltransformer;
    }

    public String getClientID() {
        logger.debug((Object)("Getting clientID [" + this.clientID + "]"));
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
        logger.debug((Object)("Setting clientID [" + this.clientID + "]"));
    }

    public String getSessionFactoryName() {
        logger.debug((Object)("Getting dataSource [" + this.sessionFactoryName + "]"));
        return this.sessionFactoryName;
    }

    public void setSessionFactoryName(String sessionFactoryName) {
        this.sessionFactoryName = sessionFactoryName;
        logger.debug((Object)("Setting sessionFactoryName [" + this.sessionFactoryName + "]"));
    }

    public String getLocalSessionFactoryName() {
        logger.debug((Object)("Getting localSessionFactoryName [" + this.localSessionFactoryName + "]"));
        return this.localSessionFactoryName;
    }

    public void setLocalSessionFactoryName(String localSessionFactoryName) {
        this.localSessionFactoryName = localSessionFactoryName;
        logger.debug((Object)("Setting localSessionFactoryName [" + this.localSessionFactoryName + "]"));
    }

    public String getXASessionFactoryName() {
        logger.debug((Object)("Getting xaSessionFactoryName [" + this.xaSessionFactoryName + "]"));
        return this.xaSessionFactoryName;
    }

    public void setXASessionFactoryName(String xaSessionFactoryName) {
        this.xaSessionFactoryName = xaSessionFactoryName;
        logger.debug((Object)("Setting xaSessionFactoryName [" + this.xaSessionFactoryName + "]"));
    }

    protected void validateConnectionProperties() throws InvalidPropertyException {
        if (this.clientID == null) {
            throw new InvalidPropertyException("ClientID property cannot be null.");
        }
        if (this.sessionFactoryName == null) {
            logger.warn((Object)("Connector property 'sessionFactoryName' is [" + this.sessionFactoryName + "]. " + "You will not be able to use a non-transactional data source!"));
        }
        if (this.localSessionFactoryName == null) {
            logger.warn((Object)("Connector property 'localSessionFactoryName' is [" + this.localSessionFactoryName + "]. " + "You will not be able to use a local transactional data source!"));
        }
        if (this.xaSessionFactoryName == null) {
            logger.warn((Object)("Connector property 'xaSessionFactoryName' is [" + this.xaSessionFactoryName + "]. " + "You will not be able to use an XA transactional data source!"));
        }
    }
}

