/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.base.socket;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class TCPSocket
extends Socket {
    private static Logger logger = Logger.getLogger(TCPSocket.class);
    private BufferedInputStream bins = null;
    private BufferedOutputStream bons = null;
    private boolean tcpSocketConnected = false;
    private boolean logSocketTraffic = false;
    private Long recvActivity = new Long(0L);
    private Long sendActivity = new Long(0L);
    private String server;
    private int port;
    private int connectionTimeout = 5000;
    private int responseTimeout = 5000;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private static final int DEFAULT_RESPONSE_TIMEOUT = 5000;
    private static final int MAXIMUM_RESPONSE_TIMEOUT = 5000;

    public TCPSocket() {
    }

    public TCPSocket(String server, int port) {
        this();
        this.server = server;
        this.port = port;
    }

    public TCPSocket(String server, int port, int connectionTimeout, int responseTimeout) {
        this();
        this.server = server;
        this.port = port;
        this.connectionTimeout = connectionTimeout;
        this.responseTimeout = responseTimeout;
    }

    public void connect() throws SocketTimeoutException, IOException {
        if (this.isTCPSocketConnected()) {
            logger.info((Object)("Socket already connected to [" + super.getInetAddress() + "]; Ignoring connection request."));
            return;
        }
        InetSocketAddress sa = new InetSocketAddress(this.server, this.port);
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Target server = [");
            sb.append(sa);
            sb.append("]; Connection timeout = [");
            sb.append(this.connectionTimeout);
            sb.append("] milliseconds.");
            logger.debug((Object)sb.toString());
        }
        super.connect(sa, this.connectionTimeout);
        this.bins = new BufferedInputStream(super.getInputStream());
        this.bons = new BufferedOutputStream(super.getOutputStream());
        super.setSoTimeout(this.responseTimeout);
        this.tcpSocketConnected = true;
    }

    public void send(byte[] data, byte startMarker, byte endMarker) throws IOException {
        byte[] framedData = this.frameOutboundData(data, startMarker, endMarker);
        if (this.logSocketTraffic) {
            logger.info((Object)("Sending [" + Arrays.toString(framedData) + "]..."));
        }
        try {
            this.bons.write(framedData);
            this.bons.flush();
            this.sendActivity = Calendar.getInstance().getTimeInMillis();
        }
        catch (IOException e) {
            this.tcpSocketConnected = false;
            throw e;
        }
        logger.info((Object)("Send Successful! Bytes written to socket = [" + framedData.length + "]"));
    }

    public void send(String data, byte startMarker, byte endMarker) throws IOException {
        byte[] framedData = this.frameOutboundData(this.stringToByteArray(data), startMarker, endMarker);
        if (this.logSocketTraffic) {
            logger.info((Object)("Sending [" + Arrays.toString(framedData) + "]..."));
        }
        try {
            this.bons.write(framedData);
            this.bons.flush();
            this.sendActivity = Calendar.getInstance().getTimeInMillis();
        }
        catch (IOException e) {
            this.tcpSocketConnected = false;
            throw e;
        }
        logger.info((Object)("Send Successful! Bytes written to socket = [" + framedData.length + "]"));
    }

    private byte[] frameOutboundData(byte[] data, Byte startMarker, Byte endMarker) {
        if (startMarker != null && endMarker != null) {
            byte[] framedData = new byte[data.length + 2];
            System.arraycopy(data, 0, framedData, 1, data.length);
            framedData[0] = startMarker;
            framedData[framedData.length - 1] = endMarker;
            return framedData;
        }
        if (startMarker != null && endMarker == null) {
            byte[] framedData = new byte[data.length + 1];
            System.arraycopy(data, 0, framedData, 1, data.length);
            framedData[0] = startMarker;
            return framedData;
        }
        if (startMarker == null && endMarker != null) {
            byte[] framedData = new byte[data.length + 1];
            System.arraycopy(data, 0, framedData, 0, data.length);
            framedData[framedData.length - 1] = endMarker;
            return framedData;
        }
        return data;
    }

    public byte[] recv(byte startMarker, byte endMarker) throws SocketTimeoutException, SocketException, IOException {
        int bytesRead;
        ByteArrayOutputStream badBuffer = new ByteArrayOutputStream();
        ByteArrayOutputStream msgBuffer = new ByteArrayOutputStream();
        byte[] singleByte = new byte[1];
        try {
            do {
                if ((bytesRead = this.bins.read(singleByte)) < 0) {
                    throw new SocketException("Connection reset by peer; EOF received!");
                }
                if (bytesRead > 0 && singleByte[0] != startMarker) {
                    badBuffer.write(singleByte);
                }
                if (badBuffer.size() <= 1024) continue;
                logger.warn((Object)("Unexpected data [" + badBuffer.toString() + "] " + "received on socket. Ignoring it and resetting buffer."));
                badBuffer = new ByteArrayOutputStream();
            } while (singleByte[0] != startMarker);
        }
        catch (SocketTimeoutException e) {
            if (badBuffer.size() > 0) {
                logger.warn((Object)("Unexpected data read from socket [" + super.getInetAddress() + "] before timeout and will be ignored. Unexpected data [" + badBuffer.toString() + "]."));
            } else {
                logger.debug((Object)"No data on socket before timeout.");
            }
            throw e;
        }
        catch (SocketException e) {
            this.tcpSocketConnected = false;
            throw e;
        }
        catch (IOException e) {
            this.tcpSocketConnected = false;
            throw e;
        }
        if (badBuffer.size() > 0) {
            logger.warn((Object)("Unexpected data read from socket [" + super.getInetAddress() + ':' + super.getPort() + "] which will be ignored. Unexpected data [" + badBuffer.toString() + "]."));
        }
        try {
            bytesRead = 0;
            int timeouts = this.getSoTimeout() == 0 && this.getSoTimeout() >= 5000 ? 0 : 5000 / this.getSoTimeout();
            do {
                try {
                    bytesRead = this.bins.read(singleByte);
                    if (bytesRead < 0) {
                        StringBuilder sb = new StringBuilder(256);
                        sb.append("Connection reset by peer while receiving data; EOF received! ");
                        if (msgBuffer.size() > 0) {
                            sb.append("Partial data received before interruption will be ignored");
                            if (this.logSocketTraffic) {
                                sb.append(" [").append(Arrays.toString(msgBuffer.toByteArray())).append(']');
                            }
                        }
                        throw new SocketException(sb.toString());
                    }
                    if (bytesRead <= 0 || singleByte[0] == endMarker) continue;
                    msgBuffer.write(singleByte);
                }
                catch (SocketTimeoutException e) {
                    if (timeouts == 0) {
                        throw e;
                    }
                    logger.warn((Object)("Valid data received before timeout; Continue read! Continue attempts left [" + --timeouts + ']'), (Throwable)e);
                }
            } while (singleByte[0] != endMarker && timeouts > 0);
            if (this.logSocketTraffic) {
                logger.info((Object)("Received [" + Arrays.toString(msgBuffer.toByteArray()) + "]"));
            }
            this.recvActivity = Calendar.getInstance().getTimeInMillis();
            return msgBuffer.toByteArray();
        }
        catch (SocketTimeoutException e) {
            logger.warn((Object)("Socket timeout while receiving message. Partial message received and ignored" + (this.logSocketTraffic ? " [" + Arrays.toString(msgBuffer.toByteArray()) + "]." : "!")));
            throw e;
        }
        catch (SocketException e) {
            this.tcpSocketConnected = false;
            throw e;
        }
        catch (IOException e) {
            this.tcpSocketConnected = false;
            throw e;
        }
    }

    public boolean isTCPSocketConnected() {
        boolean connected = this.tcpSocketConnected && !this.isClosed();
        return connected;
    }

    private byte[] stringToByteArray(String string) {
        return string.getBytes();
    }

    public int getConnectionTimeout() {
        logger.debug((Object)("Getting connectionTimeout [" + this.connectionTimeout + "]"));
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int timeout) {
        logger.debug((Object)("Setting connectionTimeout to [" + timeout + "]"));
        this.connectionTimeout = timeout;
    }

    public void setPort(int port) {
        logger.debug((Object)("Setting port to [" + port + "]"));
        this.port = port;
    }

    public int getResponseTimeout() {
        logger.debug((Object)("Getting responseTimeout [" + this.responseTimeout + "]"));
        return this.responseTimeout;
    }

    public void setResponseTimeout(int timeout) {
        logger.debug((Object)("Setting responseTimeout to [" + timeout + "]"));
        this.responseTimeout = timeout;
    }

    public String getServer() {
        logger.debug((Object)("Getting server [" + this.server + "]"));
        return this.server;
    }

    public void setServer(String server) {
        logger.debug((Object)("Setting server to [" + server + "]"));
        this.server = server;
    }

    public boolean isLogSocketTraffic() {
        logger.debug((Object)("Getting logSocketTraffic [" + this.logSocketTraffic + "]"));
        return this.logSocketTraffic;
    }

    public void setLogSocketTraffic(boolean logSocketTraffic) {
        logger.debug((Object)("Setting logSocketTraffic to [" + logSocketTraffic + "]"));
        this.logSocketTraffic = logSocketTraffic;
    }

    public Long getRecvActivity() {
        logger.debug((Object)("Getting recvActivity to [" + this.recvActivity + "]"));
        return this.recvActivity;
    }

    public Long getSendActivity() {
        logger.debug((Object)("Getting sendActivity to [" + this.sendActivity + "]"));
        return this.sendActivity;
    }

    public String connectionPropertiesToString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("Server = [").append(this.server).append(']');
        sb.append("; Port = [").append(this.port).append(']');
        sb.append("; Connection timeout = [").append(this.connectionTimeout).append(']');
        sb.append("; Response timeout = [").append(this.responseTimeout).append(']');
        return sb.toString();
    }
}

