/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.util.chunking.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.ikasan.common.util.checksum.DigestChecksum;
import org.ikasan.common.util.checksum.Md5Checksum;
import org.ikasan.connector.util.chunking.model.FileChunk;
import org.ikasan.connector.util.chunking.model.FileConstituentHandle;
import org.ikasan.connector.util.chunking.model.dao.ChunkLoadException;
import org.ikasan.connector.util.chunking.model.dao.FileChunkDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkInputStream
extends InputStream {
    private DigestChecksum checksum = new Md5Checksum();
    private FileChunkDao dao;
    private Iterator<FileConstituentHandle> fileConstituentIterator;
    private InputStream inputStream;
    private long readCount = 0L;
    private long readSinceRolloverCount = 0L;
    private long rolloverCount = 0L;

    public ChunkInputStream(List<FileConstituentHandle> constituentHandles, FileChunkDao dao) throws IOException {
        this.dao = dao;
        this.fileConstituentIterator = constituentHandles.iterator();
        this.checksum.reset();
        this.rolloverInputStream();
    }

    @Override
    public int read() throws IOException {
        ++this.readCount;
        ++this.readSinceRolloverCount;
        if (this.inputStream == null) {
            return -1;
        }
        int result = this.inputStream.read();
        if (result == -1) {
            this.rolloverInputStream();
            result = this.read();
        }
        return result;
    }

    private void rolloverInputStream() throws IOException {
        ++this.rolloverCount;
        this.inputStream = null;
        if (this.fileConstituentIterator.hasNext()) {
            try {
                FileChunk fileChunk = this.dao.load(this.fileConstituentIterator.next());
                byte[] content = fileChunk.getContent();
                this.updateChecksum(fileChunk);
                this.inputStream = new ByteArrayInputStream(content);
            }
            catch (ChunkLoadException e) {
                throw new IOException("Exception loading ChunkFile from perisistant storage " + e.getMessage());
            }
        }
        this.readSinceRolloverCount = 0L;
    }

    private void updateChecksum(FileChunk fileChunk) {
        byte[] bytes = fileChunk.getContent();
        this.checksum.update(bytes);
    }

    public String getMd5Hash() {
        return this.checksum.digestToString();
    }
}

