/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.util.chunking.io;

import java.io.IOException;
import java.io.InputStream;
import org.ikasan.connector.util.chunking.process.ChunkHandleException;
import org.ikasan.connector.util.chunking.process.ChunkHandler;
import org.ikasan.connector.util.chunking.provider.ChunkableDataSourceException;

public class ChunkingInputStreamConsumer {
    private ChunkHandler chunkHandler;

    public ChunkingInputStreamConsumer(ChunkHandler chunkHandler) {
        this.chunkHandler = chunkHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void consumeInputStream(InputStream inputStream, int chunkSize, long noOfChunks) throws ChunkableDataSourceException {
        if (inputStream == null) {
            return;
        }
        try {
            boolean streamClosed = false;
            long chunkCount = 0L;
            while (!streamClosed) {
                int bytesRead;
                int result;
                int bytesToRead = chunkSize;
                byte[] input = new byte[bytesToRead];
                for (bytesRead = 0; bytesRead < bytesToRead; bytesRead += result) {
                    result = inputStream.read(input, bytesRead, bytesToRead - bytesRead);
                    if (result != -1) continue;
                    streamClosed = true;
                    break;
                }
                if (streamClosed) {
                    byte[] smaller = new byte[bytesRead];
                    System.arraycopy(input, 0, smaller, 0, bytesRead);
                    input = smaller;
                }
                byte[] chunk = input;
                ++chunkCount;
                try {
                    this.chunkHandler.handleChunk(chunk, chunkCount, noOfChunks);
                }
                catch (ChunkHandleException che) {
                    throw new ChunkableDataSourceException("Exception handling data sourced from ChunkingInputStream", che);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new ChunkableDataSourceException(e.getMessage(), e);
        }
    }
}

