/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.util.chunking.io;

import java.io.IOException;
import java.io.OutputStream;
import org.ikasan.connector.util.chunking.process.ChunkHandleException;
import org.ikasan.connector.util.chunking.process.ChunkHandler;

public class ChunkingOutputStream
extends OutputStream {
    private int chunkSize;
    private byte[] buffer;
    private int pointer;
    private ChunkHandler chunkHandler;
    private long completedChunks;
    private long sequenceLength;

    public void flush() throws IOException {
        super.flush();
        try {
            this.handleBuffer();
        }
        catch (ChunkHandleException e) {
            throw new IOException(e.getMessage());
        }
    }

    public ChunkingOutputStream(int chunkSize, ChunkHandler chunkHandler, long sequenceLength, long startingChunk) {
        this.chunkSize = chunkSize;
        this.reset();
        this.chunkHandler = chunkHandler;
        this.sequenceLength = sequenceLength;
        this.completedChunks = startingChunk;
    }

    private void reset() {
        this.resetBuffer();
        this.completedChunks = 0L;
    }

    private void resetBuffer() {
        this.buffer = new byte[this.chunkSize];
        this.pointer = 0;
    }

    public void write(int b) throws IOException {
        this.buffer[this.pointer] = (byte)b;
        ++this.pointer;
        if (this.pointer == this.chunkSize) {
            try {
                this.handleBuffer();
            }
            catch (ChunkHandleException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    private void handleBuffer() throws ChunkHandleException {
        byte[] handleable = this.buffer;
        if (this.pointer != this.chunkSize) {
            handleable = this.trim(this.buffer, this.pointer);
        }
        this.chunkHandler.handleChunk(handleable, this.completedChunks, new Long(this.sequenceLength));
        this.resetBuffer();
        ++this.completedChunks;
    }

    protected byte[] trim(byte[] untrimmedArray, int length) {
        byte[] smaller = new byte[length];
        System.arraycopy(untrimmedArray, 0, smaller, 0, length);
        return smaller;
    }
}

