/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.util.chunking.model;

import org.ikasan.common.util.checksum.Md5Checksum;
import org.ikasan.connector.util.chunking.model.FileChunkHeader;
import org.ikasan.connector.util.chunking.model.FileConstituentHandle;

public class FileChunk
implements FileConstituentHandle {
    private Long id;
    private byte[] content;
    private long ordinal;
    private String md5Hash;
    private FileChunkHeader fileChunkHeader;

    public FileChunk(FileChunkHeader fileChunkHeader, long ordinal, byte[] content) {
        this(ordinal, fileChunkHeader);
        this.content = content;
    }

    public FileChunk(FileChunkHeader fileChunkHeader, Long ordinal, Long id) {
        this(ordinal, fileChunkHeader);
        this.id = id;
    }

    private FileChunk(Long ordinal, FileChunkHeader fileChunkHeader) {
        this();
        this.setOrdinal(ordinal);
        this.setFileChunkHeader(fileChunkHeader);
    }

    public FileChunk(FileChunkHeader fileChunkHeader, Long ordinal, byte[] content) {
        this(ordinal, fileChunkHeader);
        this.setContent(content);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public byte[] getContent() {
        return this.content;
    }

    public long getOrdinal() {
        return this.ordinal;
    }

    public String getMd5Hash() {
        return this.md5Hash;
    }

    public FileChunkHeader getFileChunkHeader() {
        return this.fileChunkHeader;
    }

    public int compareTo(FileConstituentHandle other) {
        return new Long(this.getOrdinal()).compareTo(new Long(other.getOrdinal()));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName() + "[");
        sb.append("id=");
        sb.append(this.id);
        sb.append(",");
        sb.append("ordinal=");
        sb.append(this.ordinal);
        sb.append(",");
        sb.append("fileChunkHeader=");
        sb.append(this.fileChunkHeader);
        sb.append(",");
        sb.append("]");
        return sb.toString();
    }

    public void calculateChecksum() {
        Md5Checksum md5Checksum = new Md5Checksum();
        md5Checksum.reset();
        md5Checksum.update(this.content);
        this.setMd5Hash(md5Checksum.digestToString());
    }

    private FileChunk() {
    }

    private void setContent(byte[] content) {
        this.content = content;
    }

    private void setOrdinal(long ordinal) {
        this.ordinal = ordinal;
    }

    private void setMd5Hash(String hash) {
        this.md5Hash = hash;
    }

    private void setFileChunkHeader(FileChunkHeader fileChunkHeader) {
        this.fileChunkHeader = fileChunkHeader;
    }
}

