/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.util.chunking.model.dao;

import java.util.List;
import javax.resource.ResourceException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.ikasan.connector.ConnectorContext;
import org.ikasan.connector.ResourceLoader;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasourceSessionFactoryFactory
implements FactoryBean {
    protected ConnectorContext context = ResourceLoader.getInstance().newContext();
    private String datasourceJNDIPath;
    private List<String> mappedClassnames;

    public Object getObject() throws Exception {
        SessionFactory sessionFactory = null;
        try {
            Configuration cfg = new Configuration();
            for (String className : this.mappedClassnames) {
                Class<?> clazz = Class.forName(className);
                cfg.addClass(clazz);
            }
            cfg.setProperty("hibernate.connection.datasource", this.datasourceJNDIPath);
            cfg.setProperty("hibernate.dialect", "org.hibernate.dialect.SybaseDialect");
            cfg.setProperty("hibernate.current_session_context_class", "thread");
            cfg.setProperty("hibernate.cache.provider_class", "org.hibernate.cache.NoCacheProvider");
            sessionFactory = cfg.buildSessionFactory();
        }
        catch (ClassNotFoundException e) {
            throw new ResourceException((Throwable)e);
        }
        return sessionFactory;
    }

    public Class<?> getObjectType() {
        return SessionFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setDatasourceJNDIPath(String datasourceJNDIPath) {
        this.datasourceJNDIPath = datasourceJNDIPath;
    }

    public void setMappedClassnames(List<String> mappedClassnames) {
        this.mappedClassnames = mappedClassnames;
    }
}

