/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.util.chunking.model.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.ikasan.common.util.checksum.Md5Checksum;
import org.ikasan.connector.ConnectorContext;
import org.ikasan.connector.ResourceLoader;
import org.ikasan.connector.util.chunking.model.FileChunk;
import org.ikasan.connector.util.chunking.model.FileChunkHeader;
import org.ikasan.connector.util.chunking.model.FileConstituentHandle;
import org.ikasan.connector.util.chunking.model.dao.ChunkHeaderLoadException;
import org.ikasan.connector.util.chunking.model.dao.ChunkLoadException;
import org.ikasan.connector.util.chunking.model.dao.FileChunkDao;
import org.ikasan.connector.util.chunking.model.dao.HibernateSessionFactoryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateFileChunkDao
implements FileChunkDao {
    private static Logger logger = Logger.getLogger(HibernateFileChunkDao.class);
    private static final String FILE_NAME_PARAMETER = "fileName";
    private static final String CHUNK_TIME_STAMP_PARAMETER = "chunkTimeStamp";
    private static final String SEQUENCE_LENGTH_PARAMETER = "sequenceLength";
    private static final String MAX_AGE_PARAMETER = "maxAge";
    private static final String FIND_RELATED_CHUNKS = "select f.id, f.ordinal, f.fileChunkHeader from FileChunk f where f.fileChunkHeader.fileName = :fileName and f.fileChunkHeader.chunkTimeStamp = :chunkTimeStamp";
    private static final String FIND_LATEST_TIMESTAMP = "select max(chunkTimeStamp) from FileChunkHeader h where h.fileName = :fileName";
    private static final String ID_PARAMETER = "id";
    private static final String FIND_CHUNK_BY_ID = "from FileChunk f where f.id = :id";
    private static final String FIND_CHUNK_HEADER_BY_ID = "from FileChunkHeader f where f.id = :id";
    private static final String AND = " and ";
    private static final String CLAUSE_MATCH_SEQUENCE_LENGTH = "f.fileChunkHeader.sequenceLength = :sequenceLength";
    private static final String CLAUSE_MAX_AGE = "f.fileChunkHeader.chunkTimeStamp > :maxAge";
    private SessionFactory sessionFactory;
    private Session session;
    protected ConnectorContext context = ResourceLoader.getInstance().newContext();
    private Long firstSaveTime;

    public HibernateFileChunkDao(SessionFactory sf) {
        this.sessionFactory = sf;
    }

    public HibernateFileChunkDao(String sesssionFactoryJndiPath) throws ResourceException {
        try {
            this.sessionFactory = (SessionFactory)this.context.lookup(sesssionFactoryJndiPath);
        }
        catch (NamingException e) {
            throw new ResourceException("NamingException caught when trying to resolve session factory from jndi path [" + sesssionFactoryJndiPath + "]", (Throwable)e);
        }
    }

    public HibernateFileChunkDao(HibernateSessionFactoryFactory sff) throws ResourceException {
        this.sessionFactory = sff.getSessionFactory();
    }

    @Override
    public void save(FileChunk fileChunk) {
        long saveStartTime = System.currentTimeMillis();
        if (this.firstSaveTime == null) {
            this.firstSaveTime = saveStartTime;
        }
        fileChunk.calculateChecksum();
        this.session = this.sessionFactory.openSession();
        this.session.save((Object)fileChunk);
        this.session.close();
    }

    @Override
    public FileChunk load(FileConstituentHandle fileConstituentHandle) throws ChunkLoadException {
        FileChunk result = null;
        Session querySession = this.sessionFactory.openSession();
        Query query = querySession.createQuery(FIND_CHUNK_BY_ID);
        query.setParameter(ID_PARAMETER, (Object)fileConstituentHandle.getId());
        result = (FileChunk)query.uniqueResult();
        querySession.close();
        Md5Checksum localCheckSum = new Md5Checksum();
        localCheckSum.update(result.getContent());
        if (!result.getMd5Hash().equals(localCheckSum.digestToString())) {
            throw new ChunkLoadException("DigestChecksum failed on chunk load!");
        }
        return result;
    }

    @Override
    public List<FileConstituentHandle> findChunks(String fileName, Long chunkTimeStamp, Long noOfChunks, Long maxAge) {
        ArrayList<FileConstituentHandle> result = new ArrayList<FileConstituentHandle>();
        Long version = chunkTimeStamp;
        if (version == null) {
            version = this.getLatestTimestamp(fileName);
        }
        Session querySession = this.sessionFactory.openSession();
        StringBuffer queryString = new StringBuffer(FIND_RELATED_CHUNKS);
        if (noOfChunks != null) {
            queryString.append(AND);
            queryString.append(CLAUSE_MATCH_SEQUENCE_LENGTH);
        }
        if (maxAge != null) {
            queryString.append(AND);
            queryString.append(CLAUSE_MAX_AGE);
        }
        Query query = querySession.createQuery(queryString.toString());
        query.setParameter(FILE_NAME_PARAMETER, (Object)fileName);
        query.setParameter(CHUNK_TIME_STAMP_PARAMETER, (Object)version);
        if (noOfChunks != null) {
            query.setParameter(SEQUENCE_LENGTH_PARAMETER, (Object)noOfChunks);
        }
        if (maxAge != null) {
            query.setParameter(MAX_AGE_PARAMETER, (Object)(System.currentTimeMillis() - maxAge));
        }
        List results = query.list();
        for (Object[] row : results) {
            Long primaryKey = (Long)row[0];
            Long ordinal = (Long)row[1];
            FileChunkHeader fileChunkHeader = (FileChunkHeader)row[2];
            result.add(new FileChunk(fileChunkHeader, ordinal, primaryKey));
        }
        querySession.close();
        logger.debug((Object)("HibernateFileChunkDao.findChunks returning result of length:" + result.size()));
        Collections.sort(result);
        return result;
    }

    private Long getLatestTimestamp(String fileName) {
        Long result = null;
        Session querySession = this.sessionFactory.openSession();
        Query query = querySession.createQuery(FIND_LATEST_TIMESTAMP);
        query.setParameter(FILE_NAME_PARAMETER, (Object)fileName);
        result = (Long)query.uniqueResult();
        querySession.close();
        return result;
    }

    @Override
    public void save(FileChunkHeader fileChunkHeader) {
        logger.debug((Object)("save called with:" + fileChunkHeader));
        this.session = this.startSession();
        this.session.saveOrUpdate((Object)fileChunkHeader);
        this.session.close();
    }

    @Override
    public FileChunkHeader load(Long id) throws ChunkHeaderLoadException {
        FileChunkHeader result = null;
        Session querySession = this.sessionFactory.openSession();
        Query query = querySession.createQuery(FIND_CHUNK_HEADER_BY_ID);
        query.setParameter(ID_PARAMETER, (Object)id);
        result = (FileChunkHeader)query.uniqueResult();
        querySession.close();
        if (result == null) {
            throw new ChunkHeaderLoadException("Could not find FileChunkHeader with id [" + id + "]");
        }
        return result;
    }

    @Override
    public void delete(FileChunkHeader fileChunkHeader) {
        List<FileConstituentHandle> chunkHandles = this.findChunks(fileChunkHeader.getFileName(), fileChunkHeader.getChunkTimeStamp(), null, null);
        try {
            this.session = this.startSession();
            Query query = this.session.createQuery(FIND_CHUNK_BY_ID);
            FileChunk fileChunk = null;
            int counter = 0;
            int size = 0;
            for (FileConstituentHandle handle : chunkHandles) {
                query.setParameter(ID_PARAMETER, (Object)handle.getId());
                fileChunk = (FileChunk)query.uniqueResult();
                size = fileChunk.getContent().length;
                logger.debug((Object)("Chunk is [" + size + "] number of bytes in size"));
                this.session.delete((Object)fileChunk);
                logger.debug((Object)("Deleted chunk [" + ++counter + "] of [" + chunkHandles.size() + "]"));
                this.session.flush();
            }
            this.session.delete((Object)fileChunkHeader);
            this.session.flush();
        }
        catch (HibernateException e) {
            logger.error((Object)e);
            throw e;
        }
        finally {
            if (this.session.isOpen()) {
                this.session.close();
            }
        }
    }

    private Session startSession() {
        Session newSession = this.sessionFactory.openSession();
        return newSession;
    }
}

