/*
 * $Id: Transition.java 1588 2009-05-20 09:22:57Z mitcje $
 * $URL: https://open.jira.com/svn/IKASAN/tags/ikasan-0.7.9/connector-base/src/main/java/org/ikasan/connector/base/command/state/Transition.java $
 * 
 * ====================================================================
 * Ikasan Enterprise Integration Platform
 * Copyright (c) 2003-2008 Mizuho International plc. and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the 
 * Free Software Foundation Europe e.V. Talstrasse 110, 40217 Dusseldorf, Germany 
 * or see the FSF site: http://www.fsfeurope.org/.
 * ====================================================================
 */
package org.ikasan.connector.base.command.state;

/**
 * Trivial class to encapsulate a transition between two states, via an
 * action
 * 
 * @author Ikasan Development Team
 */
public class Transition
{
    /** Initial state before action is taken */
    private State startState;
    /** Final state after action is taken */
    private State endState;
    /** action to take */
    private String action;

    /**
     * Constructor
     * 
     * @param startState
     * @param action
     * @param endState
     */
    public Transition(State startState, String action, State endState)
    {
        super();
        this.startState = startState;
        this.action = action;
        this.endState = endState;
    }

    /**
     * Accessor method for action
     * 
     * @return action
     */
    public String getAction()
    {
        return action;
    }

    /**
     * Accessor method for start state
     * 
     * @return startState
     */
    public State getStartState()
    {
        return startState;
    }

    /**
     * Accessor method for endState
     * 
     * @return endState
     */
    public State getEndState()
    {
        return endState;
    }
}
