/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.sftp.net;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.resource.ResourceException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.ikasan.connector.basefiletransfer.net.BaseFileTransferMappedRecord;
import org.ikasan.connector.basefiletransfer.net.BaseFileTransferUtils;
import org.ikasan.connector.basefiletransfer.net.ClientCommandCdException;
import org.ikasan.connector.basefiletransfer.net.ClientCommandGetException;
import org.ikasan.connector.basefiletransfer.net.ClientCommandLsException;
import org.ikasan.connector.basefiletransfer.net.ClientCommandMkdirException;
import org.ikasan.connector.basefiletransfer.net.ClientCommandPutException;
import org.ikasan.connector.basefiletransfer.net.ClientCommandPwdException;
import org.ikasan.connector.basefiletransfer.net.ClientCommandRenameException;
import org.ikasan.connector.basefiletransfer.net.ClientConnectionException;
import org.ikasan.connector.basefiletransfer.net.ClientException;
import org.ikasan.connector.basefiletransfer.net.ClientFilenameFormatter;
import org.ikasan.connector.basefiletransfer.net.ClientFixedFilenameFormatter;
import org.ikasan.connector.basefiletransfer.net.ClientInitialisationException;
import org.ikasan.connector.basefiletransfer.net.ClientListEntry;
import org.ikasan.connector.basefiletransfer.net.ClientPolarisedFilter;
import org.ikasan.connector.basefiletransfer.net.FileTransferClient;

public class SFTPClient
implements FileTransferClient {
    private static final String CURRENT_DIRECTORY = ".";
    private static final String PARENT_DIRECTORY = "..";
    private static Logger logger = Logger.getLogger(SFTPClient.class);
    private String username;
    private String remoteHostname;
    private String localHostname;
    private File prvKey;
    private File knownHosts;
    private int remotePort;
    private Integer connectionTimeout = 60000;
    private static final Integer DEFAULT_MAXIMUM_LOCAL_PORT = 65535;
    private static final String DEFAULT_PREFERRED_AUTHENTICATIONS = "publickey,password,gssapi-with-mic";
    private boolean getDestructive;
    private boolean putDestructive;
    private String lfs;
    private String tfs;
    private Integer maxRetryAttempts;
    private JSch jsch;
    private Session session;
    private Channel channel;
    private ChannelSftp channelSftp;
    private String preferredAuthentications;

    public SFTPClient(File prvKey, File knownHosts, String username, String remoteHostname, int remotePort, String localHostname, Integer maxRetryAttempts, String preferredAuthentications, Integer connectionTimeout) {
        this.prvKey = prvKey;
        this.knownHosts = knownHosts;
        this.username = username;
        this.remoteHostname = remoteHostname;
        this.remotePort = remotePort;
        this.getDestructive = false;
        this.putDestructive = false;
        this.lfs = System.getProperty("file.separator");
        this.tfs = new String("/");
        this.maxRetryAttempts = maxRetryAttempts;
        if (localHostname != null && localHostname.length() > 0) {
            this.localHostname = localHostname;
        }
        this.preferredAuthentications = preferredAuthentications != null && preferredAuthentications.length() > 0 ? preferredAuthentications : DEFAULT_PREFERRED_AUTHENTICATIONS;
        if (connectionTimeout != null) {
            this.connectionTimeout = connectionTimeout;
        }
    }

    public SFTPClient(String username, String hostname) {
        this.username = username;
        this.remoteHostname = hostname;
        this.lfs = System.getProperty("file.separator");
        this.tfs = new String("/");
        String homeDir = System.getProperty("user.home");
        String sshDir = new String(".ssh");
        String prvKeyFile = new String("id_rsa");
        String knownHostsFile = new String("known_hosts");
        this.prvKey = new File(homeDir + this.lfs + sshDir + this.lfs + prvKeyFile);
        this.knownHosts = new File(homeDir + this.lfs + sshDir + this.lfs + knownHostsFile);
        this.remotePort = 22;
    }

    public void validateConstructorArgs() throws ClientInitialisationException {
        if (this.prvKey.exists() && this.knownHosts.exists() && this.username != null && this.remoteHostname != null) {
            this.echoConfig(Level.DEBUG);
            return;
        }
        StringBuilder sb = new StringBuilder("The following arguments are erroneous or missing:\n");
        if (this.remoteHostname == null || this.remoteHostname.length() == 0) {
            sb.append("Invalid hostname! [");
            sb.append(this.remoteHostname);
            sb.append("]");
        }
        if (!this.knownHosts.exists()) {
            sb.append("Known hosts file not found! [");
            sb.append(this.knownHosts.getAbsolutePath());
            sb.append("]\n");
        }
        if (!this.prvKey.exists()) {
            sb.append("Private key file not found! [");
            sb.append(this.prvKey.getAbsolutePath());
            sb.append("]\n");
        }
        if (this.username == null || this.username.length() == 0) {
            sb.append("Invalid username! [");
            sb.append(this.username);
            sb.append("]\n");
        }
        throw new ClientInitialisationException(sb.toString());
    }

    public void connect() throws ClientConnectionException {
        String msg = new String("Checking connection status... ");
        logger.debug((Object)(msg + "[" + (this.isConnected() ? "connected" : "disconnected") + "]"));
        if (this.isConnected()) {
            logger.debug((Object)"Session and channel already connected!");
            return;
        }
        int maxAttemptConnection = 1;
        if (this.maxRetryAttempts != null) {
            maxAttemptConnection = this.maxRetryAttempts;
        }
        logger.debug((Object)("about to attempt up to [" + maxAttemptConnection + "] times to establish a connection"));
        ClientConnectionException connectionException = null;
        for (int retryCount = 0; retryCount < maxAttemptConnection; ++retryCount) {
            try {
                this.doConnect();
                if (this.isConnected()) {
                    logger.debug((Object)("Connection established on attempt [" + (retryCount + 1) + "]"));
                    break;
                }
                logger.warn((Object)("Attempt [" + (retryCount + 1) + "] failed to connect, without exception!"));
                continue;
            }
            catch (ClientConnectionException e) {
                connectionException = e;
                logger.warn((Object)("Attempt [" + (retryCount + 1) + "] failed to connect due to: " + e.getMessage()), (Throwable)e);
            }
        }
        if (!this.isConnected()) {
            if (connectionException != null) {
                logger.error((Object)("Failed to connect after [" + maxAttemptConnection + "] retries."));
                throw connectionException;
            }
            logger.error((Object)("Failed to connect after ]" + maxAttemptConnection + "] retries, but ClientConnectionException was not thrown!!"));
        }
        logger.debug((Object)"Session and channel connected!");
    }

    private void doConnect() throws ClientConnectionException {
        this.jsch = new JSch();
        String msg = new String("Attempting connection to [" + this.remoteHostname + "]...");
        logger.debug((Object)msg);
        try {
            JSch.setConfig((String)"PreferredAuthentications", (String)this.preferredAuthentications);
            msg = new String("Adding private key to identity...");
            logger.debug((Object)msg);
            this.jsch.addIdentity(this.prvKey.getAbsolutePath());
            msg = new String("Setting the known hosts...");
            logger.debug((Object)msg);
            this.jsch.setKnownHosts(this.knownHosts.getAbsolutePath());
            msg = new String("Getting the session and connecting...");
            logger.debug((Object)msg);
            this.session = this.jsch.getSession(this.username, this.remoteHostname, this.remotePort);
            this.session.connect(this.connectionTimeout.intValue());
            if (this.localHostname != null) {
                this.echoConfig(Level.DEBUG);
                for (int i = 0; i < DEFAULT_MAXIMUM_LOCAL_PORT; ++i) {
                    try {
                        logger.debug((Object)("Connecting to remote host [" + this.remoteHostname + ":" + this.remotePort + "] from local host [" + this.localHostname + ":" + this.localHostname + "]."));
                        this.session.setPortForwardingL(this.localHostname, 0, this.remoteHostname, this.remotePort);
                        break;
                    }
                    catch (JSchException e) {
                        if (!(e.getCause() instanceof BindException)) continue;
                        logger.info((Object)("Address is already in use.. will try again. Exception [" + e.getMessage() + "]."));
                        continue;
                    }
                }
            }
            msg = new String("Getting the sftp channel and connecting...");
            logger.debug((Object)msg);
            this.channel = this.session.openChannel("sftp");
            this.channel.connect();
            this.channelSftp = (ChannelSftp)this.channel;
        }
        catch (JSchException e) {
            msg = new String(msg + " [Failed]");
            logger.info((Object)msg);
            this.disconnect();
            throw new ClientConnectionException(msg, (Throwable)e);
        }
        logger.debug((Object)"Connected!");
    }

    public boolean isConnected() {
        boolean a = this.session == null ? false : this.session.isConnected();
        boolean b = this.channel == null ? false : this.channel.isConnected();
        boolean c = this.channelSftp == null ? false : this.channelSftp.isConnected();
        return a && b && c;
    }

    public void disconnect() {
        logger.debug((Object)"Disconnecting...");
        if (this.channelSftp != null && this.channelSftp.isConnected()) {
            logger.debug((Object)"Disconnecting SftpChannel...");
            this.channelSftp.disconnect();
        }
        if (this.channel != null && this.channel.isConnected()) {
            logger.debug((Object)"Disconnecting Channel...");
            this.channel.disconnect();
        }
        if (this.session != null && this.session.isConnected()) {
            logger.debug((Object)"Disconnecting Session...");
            this.session.disconnect();
        }
        logger.debug((Object)"Disconnecting... [OK]");
    }

    public void rename(String currentPath, String newPath) throws ClientCommandRenameException {
        logger.debug((Object)("rename called with currentPath [" + currentPath + "], newPath [" + newPath + "]"));
        try {
            String dirBefore = this.channelSftp.pwd();
            StringBuilder sb = new StringBuilder(384);
            sb.append("Working directory before rename = [");
            sb.append(dirBefore);
            sb.append(']');
            sb.trimToSize();
            logger.info((Object)sb.toString());
            sb = new StringBuilder(384);
            sb.append("Current Path = [");
            sb.append(currentPath);
            sb.append(']');
            sb.trimToSize();
            logger.info((Object)sb.toString());
            sb = new StringBuilder(384);
            sb.append("New Path = [");
            sb.append(newPath);
            sb.append(']');
            sb.trimToSize();
            logger.info((Object)sb.toString());
            this.channelSftp.rename(currentPath, newPath);
            sb = new StringBuilder(640);
            sb.append("Successfully renamed [");
            sb.append(currentPath);
            sb.append("] to [");
            sb.append(newPath);
            sb.append(']');
            sb.trimToSize();
            logger.info((Object)sb.toString());
            String dirAfter = this.channelSftp.pwd();
            sb = new StringBuilder(384);
            sb.append("Working directory after rename = [");
            sb.append(dirAfter);
            sb.append(']');
            sb.trimToSize();
            logger.info((Object)sb.toString());
            if (!dirBefore.equals(dirAfter)) {
                this.channelSftp.cd(dirBefore);
                sb = new StringBuilder(384);
                sb.append("Returning to previous working = [");
                sb.append(dirBefore);
                sb.append(']');
                sb.trimToSize();
                logger.debug((Object)sb.toString());
            }
        }
        catch (SftpException e) {
            StringBuilder sb = new StringBuilder(640);
            sb.append("Failed to rename [");
            sb.append(currentPath);
            sb.append("] to [");
            sb.append(newPath);
            sb.append(']');
            sb.trimToSize();
            throw new ClientCommandRenameException(sb.toString(), (Throwable)e);
        }
    }

    public void put(File src, String rDir, String rFile, int mode, FilenameFilter filter, boolean recurse, boolean force) throws ClientCommandPutException {
        String cwd;
        String remoteDir = rDir;
        List<String> absSrcPaths = this.listAbsoluteSourcePaths(src, filter, recurse);
        if (logger.getLevel() == Level.DEBUG) {
            for (String s : absSrcPaths) {
                logger.debug((Object)("absSrcPath [" + s + "]"));
            }
        }
        ClientFixedFilenameFormatter formatter = null;
        if (!src.isDirectory() && rFile != null && rFile.length() > 0) {
            formatter = new ClientFixedFilenameFormatter(rFile);
        }
        List<String> relSrcPaths = this.listRelativeSourcePaths(src, absSrcPaths, (ClientFilenameFormatter)formatter);
        if (logger.getLevel() == Level.DEBUG) {
            for (String s : relSrcPaths) {
                logger.debug((Object)("relSrcPath [" + s + "]"));
            }
        }
        if (absSrcPaths.size() != relSrcPaths.size()) {
            logger.error((Object)"relSrcPaths and absSrcPaths are not the same size!");
        }
        String absRemoteDir = new String("");
        try {
            cwd = this.channelSftp.pwd();
        }
        catch (SftpException e) {
            throw new ClientCommandPutException((Throwable)e);
        }
        if (rDir == null || rDir.length() == 0) {
            remoteDir = src.isDirectory() ? new String(cwd + src.getName()) : new String(cwd + src.getParentFile().getName());
        }
        absRemoteDir = remoteDir.startsWith("/") ? new String(remoteDir) : new String(cwd + "/" + remoteDir);
        ArrayList<String> absDstPaths = new ArrayList<String>();
        for (String rsp : relSrcPaths) {
            StringBuilder sb = new StringBuilder(512);
            sb.append(absRemoteDir);
            sb.append('/');
            sb.append(rsp);
            sb.trimToSize();
            String adp = sb.toString().replaceAll("//", "/");
            absDstPaths.add(adp);
        }
        if (logger.getLevel() == Level.DEBUG) {
            for (String s : absDstPaths) {
                logger.debug((Object)("absDstPath [" + s + "]"));
            }
        }
        if (force) {
            ArrayList entriesToCreate = new ArrayList();
            for (int i = 0; i < absDstPaths.size() - 1; ++i) {
                if (!((String)absDstPaths.get(i)).endsWith("/")) continue;
                entriesToCreate.add(absDstPaths.get(i));
            }
            for (String etc : entriesToCreate) {
                try {
                    if (this.remotePathExists(etc)) continue;
                    this.createRemotePath(etc, recurse);
                }
                catch (ClientException e) {
                    throw new ClientCommandPutException((Throwable)e);
                }
            }
        }
        if (absSrcPaths.size() != absDstPaths.size()) {
            logger.error((Object)"absDstPaths and absSrcPaths are not the same size!");
        }
        for (int i = 0; i < absSrcPaths.size(); ++i) {
            if (absSrcPaths.get(i).endsWith("/")) continue;
            File f = new File(absSrcPaths.get(i));
            String absSrcFilename = f.getPath();
            String absDstFilename = (String)absDstPaths.get(i);
            StringBuilder sb = new StringBuilder(640);
            sb.append("Putting [");
            sb.append(absSrcFilename);
            sb.append("] to [");
            sb.append(absDstFilename);
            sb.append("]... ");
            try {
                this.channelSftp.put(absSrcFilename, absDstFilename, null, mode);
                sb.append("[OK]");
                logger.info((Object)sb.toString());
                continue;
            }
            catch (Exception e) {
                sb.append("[FAILED]");
                throw new ClientCommandPutException(sb.toString(), (Throwable)e);
            }
        }
        if (this.putDestructive) {
            String srcType = src.isDirectory() ? "Directory" : "File";
            StringBuilder sb = new StringBuilder(384);
            sb.append("Destructive put. ");
            sb.append(srcType);
            sb.append(" will be deleted [");
            sb.append(src.getAbsolutePath());
            sb.append(']');
            sb.trimToSize();
            logger.info((Object)sb.toString());
            if (!src.isDirectory()) {
                src.delete();
            } else {
                this.deleteLocalDir(src);
            }
        }
    }

    public void put(String name, byte[] content) throws ClientCommandPutException {
        ByteArrayInputStream ins = new ByteArrayInputStream(content);
        try {
            this.channelSftp.put((InputStream)ins, name, 0);
        }
        catch (SftpException e) {
            StringBuilder sb = new StringBuilder(256);
            sb.append("Failed to write input stream to file! [");
            sb.append(name);
            sb.append(']');
            sb.trimToSize();
            throw new ClientCommandPutException(sb.toString(), (Throwable)e);
        }
    }

    public void get(String rDir, String rFile, String lDir, String lFile, int mode) throws ClientCommandGetException {
        block24: {
            if (mode != 0 && mode != 1 && mode != 2) {
                StringBuilder sb = new StringBuilder(256);
                sb.append("Unsupported write mode for get [");
                sb.append(mode);
                sb.append("]. Available modes are OVERWRITE(1), RESUME(2) and APPEND(3).");
                throw new ClientCommandGetException(sb.toString());
            }
            try {
                this.channelSftp.cd(rDir);
            }
            catch (SftpException e) {
                StringBuilder sb = new StringBuilder(384);
                sb.append("Failed to call remote directory [");
                sb.append(rDir);
                sb.append(']');
                throw new ClientCommandGetException(sb.toString(), (Throwable)e);
            }
            try {
                File localDir = new File(lDir);
                if (localDir.exists() && localDir.isDirectory()) {
                    this.channelSftp.lcd(localDir.getAbsolutePath());
                } else {
                    localDir.mkdirs();
                    this.channelSftp.lcd(localDir.getAbsolutePath());
                }
            }
            catch (SftpException e) {
                StringBuilder sb = new StringBuilder(384);
                sb.append("Failed to call local directory [");
                sb.append(lDir);
                sb.append(']');
                throw new ClientCommandGetException(sb.toString(), (Throwable)e);
            }
            logger.debug((Object)("Current local dir [" + this.channelSftp.lpwd() + "]"));
            try {
                logger.debug((Object)("Current remote dir [" + this.channelSftp.pwd() + "]"));
            }
            catch (SftpException e) {
                throw new ClientCommandGetException((Throwable)e);
            }
            try {
                String file;
                SftpProgressMonitor monitor = null;
                if (rFile != null && lFile != null) {
                    this.channelSftp.get(rFile, lFile, monitor, mode);
                    StringBuilder sb = new StringBuilder(640);
                    sb.append("Getting [");
                    sb.append(rFile);
                    sb.append("] into [");
                    sb.append(lDir);
                    sb.append("] as [");
                    sb.append(lFile);
                    sb.append("] successful!");
                    logger.info((Object)sb.toString());
                    if (!this.isGetDestructive()) break block24;
                    try {
                        this.deleteRemoteFile(rFile);
                        break block24;
                    }
                    catch (ClientException e) {
                        throw new ClientCommandGetException((Throwable)e);
                    }
                }
                if (rFile != null && lFile == null) {
                    this.channelSftp.get(rFile, rFile, monitor, mode);
                    StringBuilder sb = new StringBuilder(640);
                    sb.append("Getting [");
                    sb.append(rFile);
                    sb.append("] into [");
                    sb.append(lDir);
                    sb.append("] successful!");
                    logger.info((Object)sb.toString());
                    if (!this.isGetDestructive()) break block24;
                    try {
                        this.deleteRemoteFile(rFile);
                        break block24;
                    }
                    catch (ClientException e) {
                        throw new ClientCommandGetException((Throwable)e);
                    }
                }
                String path = this.channelSftp.pwd();
                Vector v = this.channelSftp.ls(path);
                ArrayList<ChannelSftp.LsEntry> validFiles = new ArrayList<ChannelSftp.LsEntry>();
                ArrayList<ChannelSftp.LsEntry> validSubDirs = new ArrayList<ChannelSftp.LsEntry>();
                for (ChannelSftp.LsEntry i : v) {
                    if (i.getAttrs().isDir()) {
                        file = new String(i.getFilename());
                        if (file.equals(CURRENT_DIRECTORY) || file.equals(PARENT_DIRECTORY)) {
                            logger.debug((Object)("Ignoring directory [" + file + "]"));
                            continue;
                        }
                        validSubDirs.add(i);
                        continue;
                    }
                    validFiles.add(i);
                }
                for (ChannelSftp.LsEntry i : validFiles) {
                    file = new String(i.getFilename());
                    this.channelSftp.get(file, file, monitor, mode);
                    logger.info((Object)("File to get [" + file + "]"));
                    if (!this.isGetDestructive()) continue;
                    try {
                        this.deleteRemoteFile(file);
                    }
                    catch (ClientException e) {
                        throw new ClientCommandGetException((Throwable)e);
                    }
                }
                for (ChannelSftp.LsEntry i : validSubDirs) {
                    String newRemoteDir = rDir + this.tfs + i.getFilename();
                    String newLocalDir = lDir + this.lfs + i.getFilename();
                    this.get(newRemoteDir, newLocalDir, mode);
                }
            }
            catch (SftpException e) {
                String msg = new String("Exception while getting file(s)!");
                throw new ClientCommandGetException(msg, (Throwable)e);
            }
        }
    }

    public void get(String rDir, String lDir, int mode) throws ClientCommandGetException {
        this.get(rDir, null, lDir, null, mode);
    }

    public InputStream getContentAsStream(ClientListEntry entry) throws ClientCommandGetException {
        File srcFile = new File(entry.getUri().getPath());
        StringBuilder sb = new StringBuilder(384);
        sb.append("Trying to get data from file [");
        sb.append(srcFile.getPath());
        sb.append("] into an InputStream");
        sb.trimToSize();
        logger.info((Object)sb.toString());
        InputStream input = null;
        try {
            SftpProgressMonitor monitor = null;
            input = this.channelSftp.get(srcFile.getName(), monitor);
        }
        catch (SftpException e) {
            sb = new StringBuilder(384);
            sb.append("Failed to get file [");
            sb.append(srcFile.getName());
            sb.append("] from directory [");
            try {
                sb.append(this.channelSftp.pwd());
            }
            catch (SftpException e1) {
                throw new ClientCommandGetException((Throwable)e1);
            }
            sb.append(']');
            throw new ClientCommandGetException(sb.toString(), (Throwable)e);
        }
        return input;
    }

    public BaseFileTransferMappedRecord get(String filePath) throws ClientCommandGetException {
        try {
            URI uri = new URI(filePath);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                SftpProgressMonitor monitor = null;
                logger.info((Object)("getting file from filepath: [" + filePath + "]"));
                this.channelSftp.get(filePath, (OutputStream)output, monitor);
            }
            catch (SftpException e) {
                throw new ClientCommandGetException("Failed to get file from sftp [" + filePath + "]", (Throwable)e);
            }
            return BaseFileTransferUtils.createBaseFileTransferMappedRecord((URI)uri, (ByteArrayOutputStream)output);
        }
        catch (URISyntaxException e) {
            throw new ClientCommandGetException("could not create URI from filePath", (Throwable)e);
        }
    }

    public BaseFileTransferMappedRecord get(ClientListEntry entry) throws ClientCommandGetException {
        URI uri = entry.getUri();
        File srcFile = new File(uri.getPath());
        StringBuilder sb = new StringBuilder(384);
        sb.append("Getting file [");
        sb.append(srcFile.getPath());
        sb.append("] into an BaseFileTransferMappedRecord");
        sb.trimToSize();
        logger.info((Object)sb.toString());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        String fileName = srcFile.getName();
        try {
            SftpProgressMonitor monitor = null;
            this.channelSftp.get(fileName, (OutputStream)output, monitor);
        }
        catch (SftpException e) {
            sb = new StringBuilder(384);
            sb.append("Failed to get file [");
            sb.append(fileName);
            sb.append("] from directory [");
            try {
                sb.append(this.channelSftp.pwd());
            }
            catch (SftpException e1) {
                throw new ClientCommandGetException((Throwable)e1);
            }
            sb.append(']');
            throw new ClientCommandGetException(sb.toString(), (Throwable)e);
        }
        BaseFileTransferMappedRecord record = BaseFileTransferUtils.createBaseFileTransferMappedRecord((URI)uri, (ByteArrayOutputStream)output);
        return record;
    }

    public String pwd() throws ClientCommandPwdException {
        String currentDir = null;
        try {
            currentDir = new String(this.channelSftp.pwd());
        }
        catch (Exception e) {
            throw new ClientCommandPwdException("Failed to get working directory!", (Throwable)e);
        }
        return currentDir;
    }

    public void cd(String targetPath) throws ClientCommandCdException {
        try {
            this.channelSftp.cd(targetPath);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder(384);
            sb.append("Failed to call directory [");
            sb.append(targetPath);
            sb.append("] from [");
            try {
                sb.append(this.channelSftp.pwd());
            }
            catch (SftpException e1) {
                throw new ClientCommandCdException((Throwable)e1);
            }
            sb.append(']');
            throw new ClientCommandCdException(sb.toString(), (Throwable)e);
        }
    }

    public void mkdir(String newPath) throws ClientCommandMkdirException {
        try {
            this.createRemotePath(newPath, true);
        }
        catch (ClientException e) {
            throw new ClientCommandMkdirException((Throwable)e);
        }
    }

    private boolean deleteLocalDir(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            for (String child : children = dir.list()) {
                boolean success = this.deleteLocalDir(new File(dir, child));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private boolean remotePathExists(String remotePath) throws ClientException {
        boolean exists = false;
        try {
            SftpATTRS s = this.channelSftp.stat(remotePath);
            exists = true;
            StringBuilder sb = new StringBuilder(384);
            sb.append("Remote path already exists! [");
            sb.append(s.toString());
            sb.append(']');
            sb.trimToSize();
            logger.debug((Object)sb.toString());
        }
        catch (SftpException e) {
            if (e.id == 2 || e.id == 4) {
                exists = false;
                StringBuilder sb = new StringBuilder(384);
                sb.append("Remote path does not exist! [");
                sb.append(remotePath);
                sb.append(']');
                logger.debug((Object)sb.toString());
            }
            StringBuilder sb = new StringBuilder(384);
            sb.append("Failed to get attributes for remote path [");
            sb.append(remotePath);
            sb.append(']');
            throw new ClientException(sb.toString(), (Throwable)e);
        }
        return exists;
    }

    private URI getURI(String absDir, String filename) throws URISyntaxException {
        StringBuilder absolutePath = new StringBuilder(512);
        absolutePath.append(absDir);
        absolutePath.append('/');
        absolutePath.append(filename);
        absolutePath.trimToSize();
        StringBuilder userInfo = new StringBuilder(this.username.length() + 12 + 128);
        userInfo.append(this.username);
        userInfo.append(";fingerprint=");
        userInfo.append(this.session.getHostKey().getFingerPrint(this.jsch));
        userInfo.trimToSize();
        return new URI("sftp", userInfo.toString(), this.remoteHostname, this.remotePort, absolutePath.toString(), null, null);
    }

    private void createRemotePath(String newPath, boolean force) throws ClientException {
        StringBuilder file = new StringBuilder(256);
        String cwd = null;
        try {
            cwd = this.channelSftp.pwd();
        }
        catch (SftpException e) {
            throw new ClientException((Throwable)e);
        }
        if (newPath.startsWith("/")) {
            file.append(newPath);
        } else {
            file.append(cwd);
            file.append('/');
            file.append(newPath);
        }
        StringTokenizer st = new StringTokenizer(file.toString(), "/");
        ArrayList<String> pathElements = new ArrayList<String>();
        pathElements.add("/");
        while (st.hasMoreTokens()) {
            pathElements.add(st.nextToken());
        }
        boolean createFlag = false;
        for (String pathElement : pathElements) {
            StringBuilder sb;
            try {
                this.channelSftp.cd(pathElement);
            }
            catch (SftpException e) {
                if (e.id == 2) {
                    sb = new StringBuilder(640);
                    sb.append("Path element [");
                    sb.append(pathElement);
                    sb.append("] of [");
                    sb.append(file.toString());
                    sb.append("] does not exist!");
                    if (force) {
                        createFlag = true;
                        logger.info((Object)sb.toString());
                    }
                    throw new ClientException(sb.toString(), (Throwable)e);
                }
                sb = new StringBuilder(640);
                sb.append("Failed to navigate to path element [");
                sb.append(pathElement);
                sb.append("] of path element [");
                sb.append(file.toString());
                sb.append(']');
                throw new ClientException(sb.toString(), (Throwable)e);
            }
            if (createFlag) {
                try {
                    this.channelSftp.mkdir(pathElement);
                    this.channelSftp.cd(pathElement);
                    StringBuilder sb2 = new StringBuilder(640);
                    sb2.append("Created path element [");
                    sb2.append(pathElement);
                    sb2.append("] of path [");
                    sb2.append(newPath);
                    sb2.append(']');
                    logger.info((Object)sb2.toString());
                }
                catch (SftpException e) {
                    sb = new StringBuilder(640);
                    sb.append("Failed to create & navigate to path element [");
                    sb.append(pathElement);
                    sb.append("] of path [");
                    sb.append(newPath);
                    sb.append(']');
                    throw new ClientException(sb.toString(), (Throwable)e);
                }
            }
            createFlag = false;
        }
        try {
            this.channelSftp.cd(cwd);
        }
        catch (SftpException e) {
            StringBuilder sb = new StringBuilder(640);
            sb.append("Failed to reset working directory to [");
            sb.append(cwd);
            sb.append(']');
            logger.warn((Object)sb.toString(), (Throwable)e);
            throw new ClientException(sb.toString(), (Throwable)e);
        }
    }

    public void deleteRemoteFile(String filename) throws ClientException {
        try {
            this.channelSftp.rm(filename);
        }
        catch (SftpException e) {
            StringBuilder sb = new StringBuilder(384);
            sb.append("Exception while deleting source file or directory [");
            sb.append(filename);
            sb.append(']');
            logger.debug((Object)("Exception thrown whilst deleting file or directory [" + (Object)((Object)e) + "]"));
            throw new ClientException(sb.toString(), (Throwable)e);
        }
    }

    public List<ClientListEntry> ls(String path) throws ClientCommandLsException, URISyntaxException {
        try {
            return this.doList(path, null);
        }
        catch (ClientException e) {
            throw new ClientCommandLsException((Throwable)e);
        }
    }

    public List<ClientListEntry> ls(String path, ClientPolarisedFilter filter) throws ClientCommandLsException, URISyntaxException {
        ArrayList<ClientPolarisedFilter> filterList = new ArrayList<ClientPolarisedFilter>(1);
        filterList.add(filter);
        try {
            return this.doList(path, filterList);
        }
        catch (ClientException e) {
            throw new ClientCommandLsException((Throwable)e);
        }
    }

    public List<ClientListEntry> ls(String path, List<ClientPolarisedFilter> filterList) throws ClientCommandLsException, URISyntaxException {
        try {
            return this.doList(path, filterList);
        }
        catch (ClientException e) {
            throw new ClientCommandLsException((Throwable)e);
        }
    }

    private List<ClientListEntry> doList(String path, List<ClientPolarisedFilter> filters) throws ClientException, URISyntaxException {
        ArrayList<ClientListEntry> list = null;
        List filteredList = null;
        try {
            SftpATTRS ps = this.channelSftp.stat(path);
            if (ps.isDir()) {
                String startDir = this.channelSftp.pwd();
                this.channelSftp.cd(path);
                String currentDir = this.channelSftp.pwd();
                logger.debug((Object)("Listing directory [" + currentDir + "]"));
                Vector v = this.channelSftp.ls(CURRENT_DIRECTORY);
                list = new ArrayList(v.size());
                for (ChannelSftp.LsEntry lsEntry : v) {
                    URI fileUri = this.getURI(currentDir, lsEntry.getFilename());
                    ClientListEntry entry = this.convertLsEntryToClientListEntry(lsEntry, fileUri);
                    list.add(entry);
                }
                this.channelSftp.cd(startDir);
            } else {
                list = new ArrayList<ClientListEntry>(1);
                int fs = path.lastIndexOf(47);
                String dir = null;
                dir = path.startsWith(System.getProperty("file.separator")) ? path.substring(0, fs) : this.channelSftp.pwd() + path.substring(0, fs);
                String file = path.substring(fs);
                URI fileUri = this.getURI(dir, file);
                ClientListEntry entry = this.convertSftpATTRSToClientListEntry(ps, null, fileUri, file);
                list.add(entry);
            }
            if (filters != null && filters.size() > 0) {
                filteredList = BaseFileTransferUtils.filterList(list, filters);
            }
        }
        catch (SftpException e) {
            StringBuilder sb = new StringBuilder(384);
            sb.append("Failed to get listing for directory! [");
            sb.append(path);
            sb.append(']');
            throw new ClientException(sb.toString(), (Throwable)e);
        }
        if (filteredList != null) {
            return filteredList;
        }
        return list;
    }

    private List<String> listAbsoluteSourcePaths(File srcPath, FilenameFilter filter, boolean recurse) {
        File[] entries;
        File[] fileArray;
        String fileEncoding = System.getProperty("file.encoding");
        ArrayList<String> files = new ArrayList<String>();
        if (srcPath.isDirectory()) {
            fileArray = srcPath.listFiles();
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = srcPath;
        }
        for (File entry : entries = fileArray) {
            if (filter == null || filter.accept(srcPath, entry.getName())) {
                URI uri = entry.toURI();
                String path = new String(uri.getPath());
                if (!fileEncoding.equals("UTF-8")) {
                    files.add(BaseFileTransferUtils.stringEncoder((String)path));
                }
            }
            if (!recurse || !entry.isDirectory()) continue;
            files.addAll(this.listAbsoluteSourcePaths(entry, filter, recurse));
        }
        Collections.sort(files);
        return files;
    }

    private List<String> listRelativeSourcePaths(File src, List<String> absSrcPaths, ClientFilenameFormatter formatter) {
        ArrayList<String> relSrcPaths = new ArrayList<String>(absSrcPaths.size());
        URI uri = src.toURI();
        for (String asp : absSrcPaths) {
            String relSrcPath = new String(asp.substring(uri.getPath().length()));
            String formattedRelSrcPath = null;
            if (formatter != null) {
                formattedRelSrcPath = formatter.translateFilename(relSrcPath);
            }
            relSrcPaths.add(formattedRelSrcPath != null ? formattedRelSrcPath : relSrcPath);
        }
        return relSrcPaths;
    }

    public void setPutDestructive(boolean putDestructive) {
        this.putDestructive = putDestructive;
    }

    public boolean isGetDestructive() {
        return this.getDestructive;
    }

    public void setGetDestructive(boolean getDestructive) {
        this.getDestructive = getDestructive;
    }

    public void echoConfig(Level logLevel) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("SFTP configuration information:");
        sb.append("\nHostname         = [");
        sb.append(this.remoteHostname);
        sb.append("]\nKnown hosts file = [");
        sb.append(this.knownHosts.getAbsolutePath());
        sb.append("]\nLocal Host       = [");
        sb.append(this.localHostname);
        sb.append("]\nRemote Port      = [");
        sb.append(this.remotePort);
        sb.append("]\nPrivate key file = [");
        sb.append(this.prvKey.getAbsolutePath());
        sb.append("]\nUsername         = [");
        sb.append(this.username);
        sb.append("]");
        logger.log((Priority)logLevel, (Object)sb.toString());
    }

    public void echoStatus(Level logLevel) {
        String s1 = this.session == null ? "null" : "" + this.session.isConnected();
        String s2 = this.channel == null ? "null" : "" + this.channel.isConnected();
        String s3 = this.channelSftp == null ? "null" : "" + this.channelSftp.isConnected();
        StringBuilder sb = new StringBuilder(256);
        sb.append("SFTP status information:");
        sb.append(" \nSession connected?     = [");
        sb.append(s1);
        sb.append("]\nChannel connected?     = [");
        sb.append(s2);
        sb.append("]\nSftpChannel connected? = [");
        sb.append(s3);
        sb.append("]\nIsConnected()          = [");
        sb.append(this.isConnected());
        sb.append("]");
        logger.log((Priority)logLevel, (Object)sb.toString());
    }

    public void ensureConnection() throws ResourceException {
        if (!this.isConnected()) {
            try {
                this.connect();
            }
            catch (ClientConnectionException e1) {
                throw new ResourceException("Failed to ensure that the underlying connection is still open. Likely this was previously open, closed prematurely, and now cannot be reestablished", (Throwable)e1);
            }
        }
    }

    public InputStream getAsInputStream(String filePath) throws ClientCommandGetException {
        try {
            return this.channelSftp.get(filePath);
        }
        catch (SftpException e) {
            throw new ClientCommandGetException((Throwable)e);
        }
    }

    public void get(String filePath, OutputStream outputStream, int resume, long offset) throws ClientCommandGetException {
        SftpProgressMonitor monitor = null;
        try {
            this.channelSftp.get(filePath, outputStream, monitor, resume, offset);
        }
        catch (SftpException e) {
            throw new ClientCommandGetException((Throwable)e);
        }
    }

    public void get(String filePath, OutputStream outputStream) throws ClientCommandGetException {
        logger.debug((Object)("get called with filePath [" + filePath + "] and outputStream [" + outputStream + "]"));
        try {
            this.channelSftp.get(filePath, outputStream);
        }
        catch (SftpException e) {
            throw new ClientCommandGetException((Throwable)e);
        }
    }

    public void putWithOutputStream(String fileName, InputStream inputStream) throws ClientCommandPutException, ClientCommandLsException, ClientCommandMkdirException {
        try {
            this.ensureParentsExist(fileName);
            this.channelSftp.put(inputStream, fileName);
        }
        catch (SftpException e) {
            throw new ClientCommandPutException((Throwable)e);
        }
    }

    public void deleteRemoteDirectory(String directoryPath, boolean recurse) throws ClientException, ClientCommandLsException {
        try {
            if (recurse) {
                try {
                    List<ClientListEntry> entryList = this.ls(directoryPath);
                    for (ClientListEntry entry : entryList) {
                        String filePath = entry.getUri().getPath();
                        if (entry.isDirectory()) {
                            if (filePath.endsWith(CURRENT_DIRECTORY)) continue;
                            this.deleteRemoteDirectory(filePath, recurse);
                            continue;
                        }
                        this.deleteRemoteFile(filePath);
                    }
                }
                catch (URISyntaxException e) {
                    throw new ClientCommandLsException((Throwable)e);
                }
            }
            this.channelSftp.rmdir(directoryPath);
        }
        catch (SftpException e) {
            StringBuffer sb = new StringBuffer();
            sb.append("Exception while deleting  directory [");
            sb.append(directoryPath);
            sb.append(']');
            logger.debug((Object)("Exception thrown whilst deleting directory [" + (Object)((Object)e) + "]"));
            throw new ClientException(sb.toString(), (Throwable)e);
        }
    }

    private void ensureParentsExist(String filePath) throws ClientCommandLsException, ClientCommandMkdirException {
        logger.debug((Object)("ensureParentsExist called with [" + filePath + "]"));
        File file = new File(filePath);
        ArrayList parents = new ArrayList();
        BaseFileTransferUtils.findParents((File)file, parents);
        Collections.reverse(parents);
        for (File directory : parents) {
            if (this.dirExists(directory)) continue;
            logger.debug((Object)("creating new parent dir [" + directory.getPath() + "]"));
            this.mkdir(directory.getPath());
        }
    }

    private boolean dirExists(File directory) throws ClientCommandLsException {
        boolean dirFound = false;
        String directoryParentPath = null;
        try {
            directoryParentPath = this.channelSftp.pwd();
        }
        catch (SftpException e) {
            throw new ClientCommandLsException((Throwable)e);
        }
        if (directory.getParent() != null) {
            directoryParentPath = directory.getParentFile().getPath();
        }
        try {
            List<ClientListEntry> entries = this.ls(directoryParentPath);
            Iterator<ClientListEntry> iterator = entries.iterator();
            while (iterator.hasNext()) {
                File entryFile = new File(iterator.next().getLongFilename());
                if (!entryFile.getName().equals(directory.getName())) continue;
                dirFound = true;
            }
        }
        catch (URISyntaxException e) {
            throw new ClientCommandLsException((Throwable)e);
        }
        return dirFound;
    }

    public ClientListEntry convertLsEntryToClientListEntry(ChannelSftp.LsEntry lsEntry, URI fileUri) {
        SftpATTRS attrs = lsEntry.getAttrs();
        String longName = lsEntry.getLongname();
        String fileName = lsEntry.getFilename();
        return this.convertSftpATTRSToClientListEntry(attrs, longName, fileUri, fileName);
    }

    public ClientListEntry convertSftpATTRSToClientListEntry(SftpATTRS attrs, String longName, URI fileUri, String fileName) {
        ClientListEntry clientListEntry = new ClientListEntry();
        clientListEntry.setUri(fileUri);
        clientListEntry.setName(fileName);
        clientListEntry.setClientId(null);
        clientListEntry.setDtLastAccessed(new Date((long)attrs.getATime() * 1000L));
        clientListEntry.setDtLastModified(new Date((long)attrs.getMTime() * 1000L));
        clientListEntry.setSize(attrs.getSize());
        clientListEntry.isDirectory(attrs.isDir());
        clientListEntry.isLink(attrs.isLink());
        if (longName == null) {
            clientListEntry.setLongFilename(attrs.toString());
        } else {
            clientListEntry.setLongFilename(longName);
        }
        clientListEntry.setAtime((long)attrs.getATime());
        clientListEntry.setMtime((long)attrs.getMTime());
        clientListEntry.setAtimeString(attrs.getAtimeString());
        clientListEntry.setMtimeString(attrs.getMtimeString());
        clientListEntry.setFlags(attrs.getFlags());
        clientListEntry.setGid("" + attrs.getGId());
        clientListEntry.setUid("" + attrs.getUId());
        clientListEntry.setPermissions(attrs.getPermissions());
        clientListEntry.setPermissionsString(attrs.getPermissionsString());
        String[] a = attrs.getExtended();
        if (a != null && a.length > 0) {
            ArrayList<String> extended = new ArrayList<String>(a.length);
            for (int i = 0; i < a.length; ++i) {
                extended.add("" + a[i]);
            }
            clientListEntry.setExtended(extended);
        }
        return clientListEntry;
    }
}

