/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.sftp.outbound;

import java.io.File;
import java.io.Serializable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.ikasan.connector.base.command.TransactionalCommandConnection;
import org.ikasan.connector.base.command.TransactionalResource;
import org.ikasan.connector.base.outbound.EISConnection;
import org.ikasan.connector.basefiletransfer.net.ClientConnectionException;
import org.ikasan.connector.basefiletransfer.net.ClientInitialisationException;
import org.ikasan.connector.basefiletransfer.outbound.BaseFileTransferConnection;
import org.ikasan.connector.sftp.net.SFTPClient;
import org.ikasan.connector.sftp.outbound.SFTPConnectionImpl;
import org.ikasan.connector.sftp.outbound.SFTPConnectionRequestInfo;
import org.ikasan.connector.sftp.outbound.SFTPManagedConnectionFactory;
import org.ikasan.connector.sftp.outbound.SFTPManagedConnectionMetaData;

public class SFTPManagedConnection
extends TransactionalCommandConnection
implements Serializable {
    private static final long serialVersionUID = -4346795065043603050L;
    public static Logger logger = Logger.getLogger(SFTPManagedConnection.class);
    private SFTPClient sftpClient;
    protected SFTPManagedConnectionFactory managedConnectionFactory;
    private SFTPConnectionRequestInfo scri;

    public SFTPManagedConnection(SFTPManagedConnectionFactory managedConnectionFactory, SFTPConnectionRequestInfo scri) {
        logger.debug((Object)"Called constructor.");
        this.managedConnectionFactory = managedConnectionFactory;
        this.scri = scri;
        this.clientID = this.scri.getClientID();
        this.instanceOrdinal = ++instanceCount;
    }

    public void setManagedConnectionFactory(ManagedConnectionFactory managedConnectionFactory) {
        this.managedConnectionFactory = (SFTPManagedConnectionFactory)managedConnectionFactory;
    }

    public SFTPManagedConnectionFactory getManagedConnectionFactory() {
        logger.debug((Object)"Called getManagedConnectionFactory");
        return this.managedConnectionFactory;
    }

    public void setConnectionRequestInfo(SFTPConnectionRequestInfo scri) {
        this.scri = scri;
    }

    public SFTPConnectionRequestInfo getConnectionRequestInfo() {
        return this.scri;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) {
        logger.debug((Object)"Called getConnection()");
        SFTPConnectionImpl connection = new SFTPConnectionImpl((ManagedConnection)this);
        this.addConnection((EISConnection)connection);
        return connection;
    }

    public void destroy() throws ResourceException {
        logger.debug((Object)"Called destroy()");
        if (this.destroyed) {
            logger.debug((Object)"Already destroyed, returning");
            return;
        }
        this.cleanup();
        this.closeSession();
        this.destroyed = true;
    }

    public void cleanup() throws ResourceException {
        logger.debug((Object)"Called cleanup()");
        this.throwIfDestroyed();
        for (BaseFileTransferConnection sc : this.connections) {
            sc.invalidate();
        }
        this.connections.clear();
    }

    public void openSession() throws ResourceException {
        logger.debug((Object)"Called openSession.");
        this.createSFTPClient();
        this.sftpClient.echoConfig(Level.INFO);
    }

    protected void closeSession() {
        if (this.sftpClient == null) {
            logger.info((Object)"SFTPClient is null.  Closing Session aborted.");
        } else if (this.sftpClient.isConnected()) {
            logger.debug((Object)"Closing SFTP connection!");
            this.sftpClient.disconnect();
            logger.debug((Object)"Disconnected from SFTP host.");
        } else {
            logger.debug((Object)"Client was already disconnected.  Closing Session aborted.");
        }
    }

    private void createSFTPClient() throws ResourceException {
        logger.debug((Object)("Called createSFTPClient \nhost     [" + this.scri.getRemoteHostname() + "]\n" + "port     [" + this.scri.getRemotePort() + "]\n" + "pvkey    [" + this.scri.getPrivateKeyFilename() + "]\n" + "kwnhost  [" + this.scri.getKnownHostsFilename() + "]\n" + "maxretry [" + this.scri.getMaxRetryAttempts() + "]\n" + "user     [" + this.scri.getUsername() + "]"));
        File privateKey = null;
        try {
            privateKey = new File(this.scri.getPrivateKeyFilename());
        }
        catch (NullPointerException e) {
            throw new ResourceException("privateKeyFilename is null", (Throwable)e);
        }
        File knownHosts = null;
        try {
            knownHosts = new File(this.scri.getKnownHostsFilename());
        }
        catch (NullPointerException e) {
            throw new ResourceException("knownHostsFilename is null", (Throwable)e);
        }
        String username = null;
        if (this.scri.getUsername() == null) {
            throw new ResourceException("username is null");
        }
        username = this.scri.getUsername();
        String remoteHostname = null;
        if (this.scri.getRemoteHostname() == null) {
            throw new ResourceException("remote hostname is null");
        }
        remoteHostname = this.scri.getRemoteHostname();
        if (this.scri.getRemotePort() == null) {
            throw new ResourceException("port is null");
        }
        int remotePort = this.scri.getRemotePort();
        if (this.scri.getMaxRetryAttempts() == null) {
            throw new ResourceException("max retry attempts is null");
        }
        int maxRetryAttempts = this.scri.getMaxRetryAttempts();
        String localHostname = null;
        if (this.managedConnectionFactory.getLocalHostname() != null) {
            localHostname = this.managedConnectionFactory.getLocalHostname();
        }
        String preferredAuthentications = this.scri.getPreferredAuthentications();
        Integer connectionTimeout = this.scri.getConnectionTimeout();
        this.sftpClient = new SFTPClient(privateKey, knownHosts, username, remoteHostname, remotePort, localHostname, maxRetryAttempts, preferredAuthentications, connectionTimeout);
        try {
            this.sftpClient.validateConstructorArgs();
        }
        catch (ClientInitialisationException e) {
            throw new ResourceException((Throwable)e);
        }
        try {
            this.sftpClient.connect();
        }
        catch (ClientConnectionException e) {
            throw new ResourceException("Failed to open connection when creating SFTPManagedConnection", (Throwable)e);
        }
    }

    public SFTPManagedConnectionMetaData getMetaData() {
        logger.debug((Object)"Called getMetaData()");
        return new SFTPManagedConnectionMetaData(this);
    }

    public void associateConnection(Object connection) throws ResourceException {
        TransactionalCommandConnection smc;
        BaseFileTransferConnection sc;
        logger.debug((Object)"Called associateConnection()");
        this.throwIfDestroyed();
        if (connection instanceof BaseFileTransferConnection) {
            sc = (BaseFileTransferConnection)connection;
            smc = sc.getManagedConnection();
            if (smc == this) {
                return;
            }
        } else {
            throw new IllegalStateException("Invalid connection object [" + connection + "]");
        }
        smc.removeConnection((EISConnection)sc);
        this.addConnection((EISConnection)sc);
        sc.setManagedConnection((TransactionalCommandConnection)this);
    }

    public void forget(Xid arg0) {
        logger.debug((Object)"in forget");
    }

    public int getTransactionTimeout() {
        logger.debug((Object)"in getTransactionTimeout");
        return 0;
    }

    public XAResource getXAResource() {
        logger.debug((Object)"in getXAResource");
        return this;
    }

    public boolean isSameRM(XAResource arg0) {
        logger.debug((Object)"in isSameRM");
        return false;
    }

    public boolean setTransactionTimeout(int arg0) {
        logger.debug((Object)"in setTransactionTimeout");
        return false;
    }

    protected TransactionalResource getTransactionalResource() {
        return this.sftpClient;
    }

    protected void postRollback(Xid arg0) {
        logger.debug((Object)"in postRollback");
    }

    protected void postCommit(Xid arg0) {
        logger.debug((Object)"in postCommit");
    }

    protected boolean cleanupJournalOnComplete() {
        return this.scri.cleanupJournalOnComplete();
    }
}

