/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.sftp.outbound;

import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionSpec;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import org.apache.log4j.Logger;
import org.ikasan.connector.BaseFileTransferConnection;
import org.ikasan.connector.base.outbound.EISConnectionFactoryImpl;
import org.ikasan.connector.sftp.outbound.SFTPConnectionManager;
import org.ikasan.connector.sftp.outbound.SFTPConnectionRequestInfo;
import org.ikasan.connector.sftp.outbound.SFTPConnectionSpec;

public class SFTPConnectionFactory
extends EISConnectionFactoryImpl {
    private static final long serialVersionUID = -2362713339278565934L;
    private static Logger logger = Logger.getLogger(SFTPConnectionFactory.class);

    public SFTPConnectionFactory() {
    }

    public SFTPConnectionFactory(ManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager) {
        this(managedConnectionFactory, connectionManager, null);
    }

    public SFTPConnectionFactory(ManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager, ConnectionRequestInfo connectionRequestInfo) {
        logger.debug((Object)"Called SFTPConnectionFactory constructor");
        this.setManagedConnectionFactory(managedConnectionFactory);
        Object sftpConnectionManager = connectionManager;
        if (connectionManager == null) {
            logger.warn((Object)"connectionManager param is null. This would suggest the connectionManager has not been provided by the Application Server. Inform development if this was not intentional. Creating new ConnectionManager outside of the Application Server.");
            sftpConnectionManager = new SFTPConnectionManager();
        }
        this.setConnectionManager((ConnectionManager)sftpConnectionManager);
        this.setConnectionRequestInfo(connectionRequestInfo);
    }

    public Connection getConnection() throws ResourceException {
        logger.debug((Object)"Called getConnection()");
        return this.getConnection(null);
    }

    public Connection getConnection(ConnectionSpec connectionSpec) throws ResourceException {
        SFTPConnectionSpec spec = new SFTPConnectionSpec();
        ConnectionRequestInfo sftpConnectionRequestInfo = null;
        if (connectionSpec != null) {
            logger.debug((Object)("Called getConnection with connection Spec: \n[" + connectionSpec.toString() + "]"));
            if (!(connectionSpec instanceof SFTPConnectionSpec)) {
                throw new ResourceException("Invalid ConnectionSpec. Received [" + connectionSpec.getClass().getName() + "], expected [" + ((Object)((Object)spec)).getClass().getName() + "]");
            }
            sftpConnectionRequestInfo = this.connectionSpecToCRI(connectionSpec);
            logger.debug((Object)("CRI: [" + sftpConnectionRequestInfo.toString() + "]"));
        } else {
            logger.debug((Object)"No connection spec passed through.");
        }
        logger.debug((Object)"About to allocate a connection.");
        ConnectionManager cm = this.getConnectionManager();
        logger.debug((Object)("ConnectionManager of type [" + cm.getClass() + "]."));
        ManagedConnectionFactory mcf = this.getManagedConnectionFactory();
        Object object = cm.allocateConnection(mcf, sftpConnectionRequestInfo);
        if (!(object instanceof BaseFileTransferConnection)) {
            throw new ResourceException("ConnectionManager connection allocation returned an unknown object [" + object.getClass().getName() + "]");
        }
        return (BaseFileTransferConnection)object;
    }

    private ConnectionRequestInfo connectionSpecToCRI(ConnectionSpec spec) {
        logger.debug((Object)"Converting Connection Spec to CRI");
        SFTPConnectionSpec sftpConnectionSpec = (SFTPConnectionSpec)spec;
        SFTPConnectionRequestInfo scri = new SFTPConnectionRequestInfo();
        if (sftpConnectionSpec != null) {
            scri.setCleanupJournalOnComplete(sftpConnectionSpec.getCleanupJournalOnComplete());
            scri.setClientID(sftpConnectionSpec.getClientID());
            scri.setRemoteHostname(sftpConnectionSpec.getRemoteHostname());
            scri.setKnownHostsFilename(sftpConnectionSpec.getKnownHostsFilename());
            scri.setMaxRetryAttempts(sftpConnectionSpec.getMaxRetryAttempts());
            scri.setRemotePort(sftpConnectionSpec.getRemotePort());
            scri.setPrivateKeyFilename(sftpConnectionSpec.getPrivateKeyFilename());
            scri.setUsername(sftpConnectionSpec.getUsername());
            scri.setPassword(sftpConnectionSpec.getPassword());
            scri.setRemoteHostname(sftpConnectionSpec.getRemoteHostname());
            scri.setRemotePort(sftpConnectionSpec.getRemotePort());
            scri.setPollTime(sftpConnectionSpec.getPollTime());
            scri.setPreferredAuthentications(sftpConnectionSpec.getPreferredAuthentications());
            scri.setConnectionTimeout(sftpConnectionSpec.getConnectionTimeout());
        }
        return scri;
    }
}

