/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.sftp.outbound;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import org.apache.log4j.Logger;
import org.ikasan.connector.BaseFileTransferConnection;
import org.ikasan.connector.ConnectorException;
import org.ikasan.connector.base.command.ExecutionContext;
import org.ikasan.connector.base.command.ExecutionOutput;
import org.ikasan.connector.base.command.TransactionalCommandConnection;
import org.ikasan.connector.base.command.TransactionalResourceCommand;
import org.ikasan.connector.base.outbound.EISConnection;
import org.ikasan.connector.basefiletransfer.DataAccessUtil;
import org.ikasan.connector.basefiletransfer.net.BaseFileTransferMappedRecord;
import org.ikasan.connector.basefiletransfer.net.ClientListEntry;
import org.ikasan.connector.basefiletransfer.net.OlderFirstClientListEntryComparator;
import org.ikasan.connector.basefiletransfer.outbound.BaseFileTransferConnectionImpl;
import org.ikasan.connector.basefiletransfer.outbound.BaseFileTransferMappedRecordTransformer;
import org.ikasan.connector.basefiletransfer.outbound.command.ChecksumDeliveredCommand;
import org.ikasan.connector.basefiletransfer.outbound.command.ChecksumValidatorCommand;
import org.ikasan.connector.basefiletransfer.outbound.command.ChunkingRetrieveFileCommand;
import org.ikasan.connector.basefiletransfer.outbound.command.CleanupChunksCommand;
import org.ikasan.connector.basefiletransfer.outbound.command.DeliverBatchCommand;
import org.ikasan.connector.basefiletransfer.outbound.command.DeliverFileCommand;
import org.ikasan.connector.basefiletransfer.outbound.command.FileDiscoveryCommand;
import org.ikasan.connector.basefiletransfer.outbound.command.RetrieveFileCommand;
import org.ikasan.connector.basefiletransfer.outbound.command.util.FilenameRegexpMatchedTargetDirectorySelector;
import org.ikasan.connector.basefiletransfer.outbound.command.util.UnzipNotSupportedException;
import org.ikasan.connector.basefiletransfer.outbound.command.util.UnzippingFileProvider;
import org.ikasan.connector.basefiletransfer.outbound.persistence.BaseFileTransferDao;
import org.ikasan.connector.listener.TransactionCommitFailureListener;
import org.ikasan.connector.sftp.outbound.SFTPManagedConnection;
import org.ikasan.connector.util.chunking.io.ChunkInputStream;
import org.ikasan.connector.util.chunking.model.FileChunkHeader;
import org.ikasan.connector.util.chunking.model.FileConstituentHandle;
import org.ikasan.connector.util.chunking.model.dao.ChunkHeaderLoadException;
import org.ikasan.connector.util.chunking.model.dao.FileChunkDao;
import org.ikasan.filetransfer.Payload;
import org.ikasan.filetransfer.util.checksum.ChecksumSupplier;
import org.ikasan.filetransfer.util.checksum.Md5ChecksumSupplier;

public class SFTPConnectionImpl
extends BaseFileTransferConnectionImpl
implements BaseFileTransferConnection {
    private static Logger logger = Logger.getLogger(SFTPConnectionImpl.class);
    private String clientId;
    private ChecksumSupplier checksumSupplier = new Md5ChecksumSupplier();
    protected SFTPManagedConnection managedConnection;
    private Long chunkableThreshold = 0x100000L;

    public SFTPConnectionImpl(ManagedConnection mc) {
        super(mc);
        this.managedConnection = (SFTPManagedConnection)mc;
        this.clientId = this.managedConnection.getClientID();
    }

    public TransactionalCommandConnection getManagedConnection() {
        logger.debug((Object)"Called getManagedConnection()");
        for (TransactionCommitFailureListener listener : this.listeners) {
            this.managedConnection.addListener(listener);
        }
        return this.managedConnection;
    }

    public void setManagedConnection(TransactionalCommandConnection managedConnection) {
        logger.debug((Object)"Called setManagedConnection()");
        this.managedConnection = (SFTPManagedConnection)managedConnection;
    }

    public void close() {
        logger.debug((Object)"Called close()");
        if (this.managedConnection == null) {
            logger.debug((Object)"ManagedConnection is null, exiting close early.");
            return;
        }
        logger.debug((Object)"Calling closeSession.");
        this.managedConnection.closeSession();
        this.managedConnection.removeConnection((EISConnection)this);
        this.managedConnection.sendClosedEvent((EISConnection)this);
        if (this.managedConnection != null) {
            this.managedConnection = null;
        } else {
            logger.debug((Object)"Managed Connection was already set to null.");
        }
    }

    public void validate() {
        logger.debug((Object)"Called validate()...");
    }

    public Payload getDiscoveredFile(String sourceDir, String filenamePattern, boolean renameOnSuccess, String renameOnSuccessExtension, boolean moveOnSuccess, String moveOnSuccessNewPath, boolean chunking, int chunkSize, boolean checksum, long minAge, boolean destructive, boolean filterDuplicates, boolean filterOnFilename, boolean filterOnLastModifiedDate, boolean chronological, boolean isRecursive) throws ResourceException {
        Payload result = null;
        ExecutionContext executionContext = new ExecutionContext();
        logger.debug((Object)("Got clientId [" + this.clientId + "]"));
        logger.debug((Object)("Source = [" + sourceDir + "] moveOnSuccess = [" + moveOnSuccess + "] and archive dir = [" + moveOnSuccessNewPath + "]."));
        executionContext.put("clientId", (Object)this.clientId);
        BaseFileTransferDao baseFileTransferDao = DataAccessUtil.getBaseFileTransferDao();
        FileDiscoveryCommand fileDiscoveryCommand = new FileDiscoveryCommand(sourceDir, filenamePattern, baseFileTransferDao, minAge, filterDuplicates, filterOnFilename, filterOnLastModifiedDate, isRecursive);
        List entries = this.executeCommand((TransactionalResourceCommand)fileDiscoveryCommand, executionContext).getResultList();
        if (chronological) {
            List list = entries;
            logger.info((Object)"Sorting entries list by chronological order.");
            Collections.sort(list, new OlderFirstClientListEntryComparator());
        }
        logger.debug((Object)("got entries from FileDiscoveryCommand: [" + entries + "]"));
        if (!entries.isEmpty()) {
            ClientListEntry entry = (ClientListEntry)entries.get(0);
            String fullMovePath = moveOnSuccessNewPath;
            if (moveOnSuccess) {
                int lastIndexOf = entry.getUri().getPath().lastIndexOf("/");
                fullMovePath = fullMovePath + entry.getUri().getPath().substring(lastIndexOf);
            }
            result = this.sourceFile(entry, this.clientId, renameOnSuccess, renameOnSuccessExtension, moveOnSuccess, fullMovePath, chunking, chunkSize, checksum, destructive, baseFileTransferDao);
        }
        return result;
    }

    public void deliverPayload(Payload payload, String outputDir, Map<String, String> outputTargets, boolean overwrite, String renameExtension, boolean checksumDelivered, boolean unzip, boolean cleanup) throws ResourceException {
        String tempFilePath;
        ExecutionContext executionContext = new ExecutionContext();
        executionContext.put("payload", (Object)payload);
        FilenameRegexpMatchedTargetDirectorySelector selector = new FilenameRegexpMatchedTargetDirectorySelector(outputTargets);
        String outputTarget = selector.getTargetDirectory(payload, outputDir);
        if (this.isChunkReference(payload)) {
            ChunkInputStream chunkInputStream;
            FileChunkHeader fileChunkHeader;
            FileChunkHeader reconstitutedFileChunkHeader = FileChunkHeader.fromXml((String)new String(payload.getContent()));
            if (reconstitutedFileChunkHeader == null) {
                throw new ConnectorException("Could not deserialize payload content");
            }
            Long fileHeaderPrimaryKey = reconstitutedFileChunkHeader.getId();
            if (fileHeaderPrimaryKey == null) {
                throw new ConnectorException("Could not get pk from deserialized payload content");
            }
            FileChunkDao fileChunkDao = DataAccessUtil.getFileChunkDao();
            try {
                fileChunkHeader = fileChunkDao.load(fileHeaderPrimaryKey);
            }
            catch (ChunkHeaderLoadException e) {
                throw new ConnectorException("FileChunkHeader with pk [" + fileHeaderPrimaryKey + "] could not be reloaded from the database", (Throwable)e);
            }
            List<FileConstituentHandle> handles = this.getConstituentHandles(fileChunkDao, fileChunkHeader.getFileName(), fileChunkHeader.getChunkTimeStamp());
            try {
                chunkInputStream = new ChunkInputStream(handles, fileChunkDao);
            }
            catch (IOException e1) {
                throw new ResourceException("Exception creating ChunkInputStream", (Throwable)e1);
            }
            DeliverFileCommand deliveryCommand = null;
            if (!unzip) {
                executionContext.put("fileInputStream", (Object)chunkInputStream);
                executionContext.put("relativeFilePathParam", (Object)fileChunkHeader.getFileName());
                deliveryCommand = new DeliverFileCommand(outputTarget, renameExtension, overwrite, false, null);
            } else {
                try {
                    executionContext.put("batchedFileProvider", (Object)new UnzippingFileProvider((InputStream)chunkInputStream));
                }
                catch (UnzipNotSupportedException e) {
                    throw new ResourceException("Exception trying to unzip stream", (Throwable)e);
                }
                executionContext.put("batchedFileName", (Object)fileChunkHeader.getFileName());
                deliveryCommand = new DeliverBatchCommand(outputTarget, overwrite);
            }
            tempFilePath = (String)this.executeCommand((TransactionalResourceCommand)deliveryCommand, executionContext).getResult();
            if (cleanup) {
                logger.debug((Object)"about to cleanup file chunks");
                executionContext.put("fileChunkHeader", (Object)reconstitutedFileChunkHeader);
                HashMap<String, FileChunkDao> beanFactory = new HashMap<String, FileChunkDao>();
                beanFactory.put("fileChunkDao", fileChunkDao);
                CleanupChunksCommand cleanupChunksCommand = new CleanupChunksCommand();
                cleanupChunksCommand.setBeanFactory(beanFactory);
                this.executeCommand((TransactionalResourceCommand)cleanupChunksCommand, executionContext);
                logger.debug((Object)"back from file chunk cleanup");
            }
        } else {
            DeliverFileCommand deliveryCommand = null;
            BaseFileTransferMappedRecord mappedRecord = BaseFileTransferMappedRecordTransformer.payloadToMappedRecord((Payload)payload);
            if (!unzip) {
                executionContext.put("baseFileTransferMappedRecord", (Object)mappedRecord);
                deliveryCommand = new DeliverFileCommand(outputTarget, renameExtension, overwrite, false, null);
            } else {
                ByteArrayInputStream bais = new ByteArrayInputStream(mappedRecord.getContent());
                try {
                    executionContext.put("batchedFileProvider", (Object)new UnzippingFileProvider((InputStream)bais));
                }
                catch (UnzipNotSupportedException e) {
                    throw new ResourceException("Exception trying to unzip byte array", (Throwable)e);
                }
                executionContext.put("batchedFileName", (Object)mappedRecord.getName());
                deliveryCommand = new DeliverBatchCommand(outputTarget, overwrite);
            }
            tempFilePath = (String)this.executeCommand((TransactionalResourceCommand)deliveryCommand, executionContext).getResult();
        }
        if (checksumDelivered) {
            executionContext.put("deliveredFilePathParam", (Object)tempFilePath);
            ChecksumDeliveredCommand checksumDeliveredCommand = new ChecksumDeliveredCommand();
            this.executeCommand((TransactionalResourceCommand)checksumDeliveredCommand, executionContext);
        }
    }

    public void housekeep(int maxRows, int ageOfFiles) throws ResourceException {
        try {
            BaseFileTransferDao baseFileTransferDao = DataAccessUtil.getBaseFileTransferDao();
            baseFileTransferDao.housekeep(this.clientId, ageOfFiles, maxRows);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    protected ExecutionOutput executeCommand(TransactionalResourceCommand command, ExecutionContext executionContext) throws ResourceException {
        command.setExecutionContext(executionContext);
        return this.executeCommand(command);
    }

    private List<FileConstituentHandle> getConstituentHandles(FileChunkDao fileChunkDao, String fileName, Long fileChunkTimeStamp) throws ResourceException {
        List constituentHandles = fileChunkDao.findChunks(fileName, fileChunkTimeStamp, null, null);
        if (constituentHandles.isEmpty()) {
            throw new ResourceException("No chunks found for file: [" + fileName + "]");
        }
        return constituentHandles;
    }

    private Payload sourceFile(ClientListEntry entry, String clientID, boolean renameOnSuccess, String renameOnSuccessExtension, boolean moveOnSuccess, String moveOnSuccessNewPath, boolean chunking, int chunkSize, boolean checksum, boolean destructive, BaseFileTransferDao baseFileTransferDao) throws ResourceException {
        logger.info((Object)("sourceFile called with entry: [" + entry + "]"));
        logger.info((Object)("move on success = [" + moveOnSuccess + "] and path = [" + moveOnSuccessNewPath + "]."));
        Payload result = null;
        ExecutionContext executionContext = new ExecutionContext();
        executionContext.put("clientId", (Object)clientID);
        executionContext.put("retrievableFileParam", (Object)entry);
        if (chunking && this.shouldChunk(entry)) {
            FileChunkDao fileChunkDao = DataAccessUtil.getFileChunkDao();
            logger.debug((Object)"About to call ChunkingRetrieveFileCommand");
            ChunkingRetrieveFileCommand chunkingRetrieveFileCommand = new ChunkingRetrieveFileCommand(baseFileTransferDao, clientID, renameOnSuccess, renameOnSuccessExtension, moveOnSuccess, moveOnSuccessNewPath, fileChunkDao, chunkSize, destructive);
            Object executionResult = this.executeCommand((TransactionalResourceCommand)chunkingRetrieveFileCommand, executionContext).getResult();
            FileChunkHeader fileChunkHeader = (FileChunkHeader)executionResult;
            result = this.fileChunkHeaderToPayload(fileChunkHeader);
        } else {
            logger.info((Object)"About to call RetrieveFileCommand");
            RetrieveFileCommand retrieveFileCommand = new RetrieveFileCommand(baseFileTransferDao, renameOnSuccess, renameOnSuccessExtension, moveOnSuccess, moveOnSuccessNewPath, destructive);
            ExecutionOutput executionResult = this.executeCommand((TransactionalResourceCommand)retrieveFileCommand, executionContext);
            BaseFileTransferMappedRecord sftpMappedRecord = (BaseFileTransferMappedRecord)executionResult.getResult();
            if (sftpMappedRecord == null) {
                logger.warn((Object)"No file was picked up.");
                return result;
            }
            result = BaseFileTransferMappedRecordTransformer.mappedRecordToPayload((BaseFileTransferMappedRecord)sftpMappedRecord);
        }
        String sourcePath = entry.getUri().getPath();
        executionContext.put("payload", (Object)result);
        logger.debug((Object)"About to call ChecksumValidatorCommand");
        if (checksum) {
            logger.info((Object)"comparing checksum of sourced file with that in external checksum file");
            ChecksumValidatorCommand checksumValidatorCommand = new ChecksumValidatorCommand(this.checksumSupplier, destructive, sourcePath);
            this.executeCommand((TransactionalResourceCommand)checksumValidatorCommand, executionContext);
        } else {
            logger.info((Object)"checksumming disabled");
        }
        return result;
    }

    private boolean shouldChunk(ClientListEntry entry) {
        boolean result = false;
        if (this.chunkableThreshold != null) {
            result = entry.getSize() > this.chunkableThreshold;
        }
        return result;
    }

    protected ExecutionOutput executeCommand(TransactionalResourceCommand command) throws ResourceException {
        super.addListenersToCommand(command);
        return this.getManagedConnection().executeCommand(command);
    }
}

