/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.sftp.outbound;

import java.util.ResourceBundle;
import org.ikasan.connector.base.outbound.EISConnectionSpec;
import org.ikasan.connector.sftp.outbound.SFTPConnectionProperties;

public class SFTPConnectionSpec
extends EISConnectionSpec {
    private String remoteHostname = null;
    private String knownHostsFilename = null;
    private Integer maxRetryAttempts = 1;
    private Integer remotePort = 22;
    private String privateKeyFilename = null;
    private Integer connectionTimeout = 0;
    private String username = null;
    private String password = null;
    private String preferredAuthentications = new String();
    private Boolean cleanupJournalOnComplete = Boolean.TRUE;
    private Integer pollTime = 0;
    private static final long serialVersionUID = 1L;

    public SFTPConnectionSpec() {
    }

    public SFTPConnectionSpec(ResourceBundle bundle) {
        super(bundle);
        String prop = null;
        prop = bundle.getString(SFTPConnectionProperties.KNOWN_HOSTS.toString());
        this.setKnownHostsFilename(prop);
        prop = bundle.getString(SFTPConnectionProperties.MAX_RETRIES.toString());
        this.setMaxRetryAttempts(new Integer(prop));
        prop = bundle.getString(SFTPConnectionProperties.PRIVATE_KEY.toString());
        this.setPrivateKeyFilename(prop);
        prop = bundle.getString(SFTPConnectionProperties.USERNAME.toString());
        this.setUsername(prop);
        prop = bundle.getString(SFTPConnectionProperties.PASSWORD.toString());
        this.setPassword(prop);
        prop = bundle.getString(SFTPConnectionProperties.HOST.toString());
        this.setRemoteHostname(prop);
        prop = bundle.getString(SFTPConnectionProperties.PORT.toString());
        this.setRemotePort(new Integer(prop));
        prop = bundle.getString(SFTPConnectionProperties.CLEANUP_JOURNAL_ON_COMPLETE.toString());
        this.setCleanupJournalOnComplete(new Boolean(prop));
        prop = bundle.getString(SFTPConnectionProperties.POLLTIME.toString());
        if (prop != null) {
            this.setPollTime(new Integer(prop));
        }
    }

    public Boolean getCleanupJournalOnComplete() {
        return this.cleanupJournalOnComplete;
    }

    public void setCleanupJournalOnComplete(Boolean cleanupJournalOnComplete) {
        this.cleanupJournalOnComplete = cleanupJournalOnComplete;
    }

    public String getRemoteHostname() {
        return this.remoteHostname;
    }

    public void setRemoteHostname(String remoteHostname) {
        this.remoteHostname = remoteHostname;
    }

    public String getKnownHostsFilename() {
        return this.knownHostsFilename;
    }

    public void setKnownHostsFilename(String knownHostsFilename) {
        this.knownHostsFilename = knownHostsFilename;
    }

    public Integer getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public void setMaxRetryAttempts(Integer maxRetryAttempts) {
        this.maxRetryAttempts = maxRetryAttempts;
    }

    public Integer getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(Integer port) {
        this.remotePort = port;
    }

    public String getPrivateKeyFilename() {
        return this.privateKeyFilename;
    }

    public void setPrivateKeyFilename(String privateKeyFilename) {
        this.privateKeyFilename = privateKeyFilename;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getPollTime() {
        return this.pollTime;
    }

    public void setPollTime(Integer pollTime) {
        this.pollTime = pollTime;
    }

    public void setPreferredAuthentications(String preferredAuthentications) {
        this.preferredAuthentications = preferredAuthentications;
    }

    public String getPreferredAuthentications() {
        return this.preferredAuthentications;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public String toString() {
        String specAsString = "CleanupJournalOnComplete:         [" + this.cleanupJournalOnComplete + "]\n" + "Client Id:                        [" + super.getClientID() + "]\n" + "Connection Timeout:               [" + this.connectionTimeout + "]\n" + "Host:                             [" + this.remoteHostname + "]\n" + "Known hosts file name:            [" + this.knownHostsFilename + "]\n" + "Maximum amount of retries:        [" + this.maxRetryAttempts + "]\n" + "Port:                             [" + this.remotePort + "]\n" + "Poll time:                        [" + this.pollTime + "]\n" + "Private key file name:            [" + this.privateKeyFilename + "]\n" + "Preferred authentication order:   [" + this.preferredAuthentications + "]\n" + "Username:                         [" + this.username + "]";
        return specAsString;
    }
}

