/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.connector.sftp.outbound;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.ikasan.connector.base.command.TransactionalResourceCommandDAO;
import org.ikasan.connector.base.journal.TransactionJournal;
import org.ikasan.connector.base.journal.TransactionJournalImpl;
import org.ikasan.connector.base.outbound.EISManagedConnectionFactory;
import org.ikasan.connector.basefiletransfer.DataAccessUtil;
import org.ikasan.connector.sftp.outbound.SFTPConnectionFactory;
import org.ikasan.connector.sftp.outbound.SFTPConnectionRequestInfo;
import org.ikasan.connector.sftp.outbound.SFTPManagedConnection;
import org.ikasan.connector.util.chunking.model.dao.FileChunkDao;
import org.ikasan.filetransfer.util.Env;

public class SFTPManagedConnectionFactory
extends EISManagedConnectionFactory {
    private boolean cleanupJournalOnComplete = false;
    private String remoteHostname = null;
    private String localHostname = null;
    private String knownHostsFilename = null;
    private Integer maxRetryAttempts = null;
    private Integer remotePort = null;
    private String privateKeyFilename = null;
    private Integer connectionTimeout;
    private String username = null;
    private String password = null;
    private String preferredAuthentications = null;
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(SFTPManagedConnectionFactory.class);
    private TransactionJournal transactionJournal = null;

    public Object createConnectionFactory() {
        logger.debug((Object)"Called createConnectionFactory()");
        return new SFTPConnectionFactory((ManagedConnectionFactory)this, null);
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) {
        logger.debug((Object)"Called createConnectionFactory(connectionManager)");
        return new SFTPConnectionFactory((ManagedConnectionFactory)this, connectionManager);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        logger.debug((Object)"Called createManagedConnection");
        SFTPManagedConnection sftpManagedConnection = new SFTPManagedConnection(this, (SFTPConnectionRequestInfo)cri);
        sftpManagedConnection.setTransactionJournal(this.getTransactionJournal());
        sftpManagedConnection.openSession();
        return sftpManagedConnection;
    }

    public ManagedConnection matchManagedConnections(Set connections, Subject subject, ConnectionRequestInfo info) {
        logger.debug((Object)"Called matchManagedConnection()");
        int size = connections.size();
        logger.debug((Object)("Number of connections considered = [" + size + "]."));
        Iterator it = connections.iterator();
        SFTPConnectionRequestInfo scri = (SFTPConnectionRequestInfo)info;
        while (it.hasNext()) {
            Object obj = it.next();
            logger.debug((Object)("Considering object " + obj.getClass().getName()));
            if (!(obj instanceof SFTPManagedConnection)) continue;
            logger.debug((Object)"Object is a SFTPManagedConnection instance.");
            SFTPManagedConnection smc = (SFTPManagedConnection)obj;
            SFTPConnectionRequestInfo currentScri = smc.getConnectionRequestInfo();
            if (!currentScri.equals((Object)scri)) continue;
            logger.debug((Object)"Found matched Connection.");
            if (smc.transactionInProgress()) {
                logger.warn((Object)"Matched a managed connection, but it's already involved in transaction, if <track-connection-by-tx/> property is specified on your connection factory then this should not be occurring.");
                continue;
            }
            return smc;
        }
        logger.info((Object)"No matched Connection for object (or at least none that were not already involved in a txn).");
        return null;
    }

    public int hashCode() {
        logger.debug((Object)"Called hashCode()");
        int hashCode = this.remoteHostname.hashCode() + this.remotePort.hashCode() + this.username.hashCode() + this.knownHostsFilename.hashCode() + this.privateKeyFilename.hashCode() + this.clientID.hashCode();
        logger.debug((Object)("HashCode = [" + hashCode + "]."));
        return hashCode;
    }

    public boolean equals(Object object) {
        logger.debug((Object)"Called equals");
        if (object == null) {
            logger.debug((Object)"Object is null. Returning [false].");
            return false;
        }
        if (object instanceof SFTPManagedConnectionFactory) {
            logger.debug((Object)"Object is a SFTPManagedConnectionFactory");
            SFTPManagedConnectionFactory smcf = (SFTPManagedConnectionFactory)((Object)object);
            return this.compareSMCF(smcf);
        }
        logger.debug((Object)"Object is not valid, returning [false].");
        return false;
    }

    private boolean compareSMCF(SFTPManagedConnectionFactory smcf) {
        if (this.remoteHostname == null || this.remotePort == null || this.username == null || this.knownHostsFilename == null || this.privateKeyFilename == null || this.clientID == null) {
            logger.warn((Object)"One of the mandatory managed connection factory variables is null.");
            logger.warn((Object)("Hostname = [" + this.remoteHostname + "]"));
            logger.warn((Object)("Port = [" + this.remotePort + "]"));
            logger.warn((Object)("Username = [" + this.username + "]"));
            logger.warn((Object)("KnonwHostFileName = [" + this.knownHostsFilename + "]"));
            logger.warn((Object)("PrivateKeyFileName = [" + this.privateKeyFilename + "]"));
            logger.warn((Object)("ClientID = [" + this.clientID + "]."));
            return false;
        }
        if (this.remoteHostname.equalsIgnoreCase(smcf.remoteHostname) && this.remotePort == smcf.remotePort && this.username.equals(smcf.username) && this.knownHostsFilename.equals(smcf.knownHostsFilename) && this.privateKeyFilename.equals(smcf.privateKeyFilename) && this.clientID.equals(smcf.clientID)) {
            logger.debug((Object)"Object is equal. Returning [true].");
            return true;
        }
        logger.debug((Object)"Object is not equal. Returning [false].");
        return false;
    }

    protected TransactionJournal getTransactionJournal() {
        if (this.transactionJournal == null) {
            TransactionalResourceCommandDAO dao = DataAccessUtil.getTransactionalResourceCommandDAO();
            FileChunkDao fileChunkDao = DataAccessUtil.getFileChunkDao();
            HashMap<String, FileChunkDao> beanFactory = new HashMap<String, FileChunkDao>();
            beanFactory.put("fileChunkDao", fileChunkDao);
            this.transactionJournal = new TransactionJournalImpl(dao, this.clientID, beanFactory);
        }
        return this.transactionJournal;
    }

    public String getRemoteHostname() {
        return this.remoteHostname;
    }

    public void setRemoteHostname(String remoteHostname) {
        logger.debug((Object)("ra.xml setting hostname to: [" + remoteHostname + "]"));
        this.remoteHostname = remoteHostname;
    }

    public String getLocalHostname() {
        return this.localHostname;
    }

    public void setLocalHostname(String rtLocalHost) {
        Env env = new Env();
        String localHost = env.expandEnvVar(rtLocalHost);
        logger.debug((Object)("Setting localhost to [" + localHost + "]."));
        if (localHost != null && localHost.length() > 0) {
            this.localHostname = localHost;
        }
    }

    public String getKnownHostsFilename() {
        return this.knownHostsFilename;
    }

    public void setKnownHostsFilename(String knownHostsFilename) {
        logger.debug((Object)("ra.xml setting knownHostsFilename to: [" + knownHostsFilename + "]"));
        this.knownHostsFilename = knownHostsFilename;
    }

    public Integer getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(Integer remotePort) {
        logger.debug((Object)("ra.xml setting port to: [" + remotePort + "]"));
        this.remotePort = remotePort;
    }

    public String getPrivateKeyFilename() {
        return this.privateKeyFilename;
    }

    public void setPrivateKeyFilename(String privateKeyFilename) {
        logger.debug((Object)("ra.xml setting privateKeyFilename to: [" + privateKeyFilename + "]"));
        this.privateKeyFilename = privateKeyFilename;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        logger.debug((Object)("ra.xml setting username to: [" + username + "]"));
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        logger.debug((Object)("ra.xml setting password to: [" + password + "]"));
        this.password = password;
    }

    public Integer getMaxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public boolean isCleanupJournalOnComplete() {
        return this.cleanupJournalOnComplete;
    }

    public void setPreferredAuthentications(String preferredAuthentications) {
        this.preferredAuthentications = preferredAuthentications;
    }

    public String getPreferredAuthentications() {
        return this.preferredAuthentications;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }
}

