/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.error.reporting.dao;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.ikasan.error.reporting.dao.ErrorCategorisationDao;
import org.ikasan.error.reporting.model.ErrorCategorisation;
import org.ikasan.error.reporting.model.ErrorCategorisationLink;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class HibernateErrorCategorisationDao
extends HibernateDaoSupport
implements ErrorCategorisationDao {
    public static final String MODULE_NAMES = "moduleNames";
    public static final String FLOW_NAMES = "flowNames";
    public static final String COMPONENT_NAMES = "componentNames";
    public static final String START_DATE = "startDate";
    public static final String END_DATE = "endDate";
    public static final String ERROR_CATERORISED_COUNT_SQL = "select distinct count(Uri) from ErrorCategorisationLink l, ErrorOccurrence e where (l.ModuleName = e.ModuleName and l.FlowName = e.FlowName and l.FlowElementName = e.FlowElementName) or (l.ModuleName = e.ModuleName and l.FlowName = e.FlowName) or (l.ModuleName = e.ModuleName) and e.Timestamp <= :endDate and e.Timestamp >= :startDate and e.UserAction is NULL ";
    public static final String ERROR_CATERORISED_LINK_FIND_ALL_SQL = "select l from ErrorCategorisationLink as l  where l.moduleName = :moduleName and l.flowName = :flowName and l.flowElementName = :flowElementName ";
    public static final String ERROR_CATERORISED_LINK_FIND_ONE_SQL = "select l from ErrorCategorisationLink as l  where l.moduleName = :moduleName  and l.flowName = :flowName  and l.flowElementName = :flowElementName  and l.action = :action ";
    public final String MODULE_NAMES_CLAUSE = "and e.ModuleName in(:moduleNames) ";
    public final String FLOW_NAMES_CLAUSE = "and e.FlowName in (:flowNames) ";
    public final String COMPONENT_NAMES_CLAUSE = "and e.FlowElementName in (:componentNames) ";

    @Override
    public void save(ErrorCategorisation errorCategorisation) {
        this.getHibernateTemplate().saveOrUpdate((Object)errorCategorisation);
    }

    @Override
    public void save(ErrorCategorisationLink errorCategorisationLink) {
        this.getHibernateTemplate().saveOrUpdate((Object)errorCategorisationLink);
    }

    @Override
    public void delete(ErrorCategorisationLink errorCategorisationLink) {
        this.getHibernateTemplate().delete((Object)errorCategorisationLink);
    }

    @Override
    public List<ErrorCategorisationLink> find(String moduleName, String flowName, String flowElementName) {
        return (List)this.getHibernateTemplate().execute(session -> {
            Query query = session.createQuery(ERROR_CATERORISED_LINK_FIND_ALL_SQL);
            query.setParameter("moduleName", (Object)moduleName);
            query.setParameter("flowName", (Object)flowName);
            query.setParameter("flowElementName", (Object)flowElementName);
            return query.list();
        });
    }

    @Override
    public ErrorCategorisationLink find(String moduleName, String flowName, String flowElementName, String action) {
        return (ErrorCategorisationLink)this.getHibernateTemplate().execute(session -> {
            Query query = session.createQuery(ERROR_CATERORISED_LINK_FIND_ONE_SQL);
            query.setParameter("moduleName", (Object)moduleName);
            query.setParameter("flowName", (Object)flowName);
            query.setParameter("flowElementName", (Object)flowElementName);
            query.setParameter("action", (Object)action);
            List list = query.getResultList();
            if (list != null && !list.isEmpty()) {
                return (ErrorCategorisationLink)list.get(0);
            }
            return null;
        });
    }

    @Override
    public void delete(ErrorCategorisation errorCategorisation) {
        this.getHibernateTemplate().delete((Object)errorCategorisation);
    }

    @Override
    public List<ErrorCategorisation> findAll() {
        return (List)this.getHibernateTemplate().execute(session -> session.createQuery("from ErrorCategorisation").getResultList());
    }

    @Override
    public List<ErrorCategorisationLink> findAllErrorCategorisationLinks() {
        return (List)this.getHibernateTemplate().execute(session -> session.createQuery("from ErrorCategorisationLink").getResultList());
    }

    @Override
    public Long rowCount(final List<String> moduleNames, final List<String> flowNames, final List<String> flowElementNames, final Date startDate, final Date endDate) {
        return (Long)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException {
                StringBuilder queryBuffer = new StringBuilder(HibernateErrorCategorisationDao.ERROR_CATERORISED_COUNT_SQL);
                if (moduleNames != null && !moduleNames.isEmpty()) {
                    queryBuffer.append("and e.ModuleName in(:moduleNames) ");
                }
                if (flowNames != null && !flowNames.isEmpty()) {
                    queryBuffer.append("and e.FlowName in (:flowNames) ");
                }
                if (flowElementNames != null && !flowElementNames.isEmpty()) {
                    queryBuffer.append("and e.FlowElementName in (:componentNames) ");
                }
                NativeQuery query = session.createSQLQuery(queryBuffer.toString());
                if (moduleNames != null && !moduleNames.isEmpty()) {
                    query.setParameterList(HibernateErrorCategorisationDao.MODULE_NAMES, (Collection)moduleNames);
                }
                if (flowNames != null && !flowNames.isEmpty()) {
                    query.setParameterList(HibernateErrorCategorisationDao.FLOW_NAMES, (Collection)flowNames);
                }
                if (flowElementNames != null && !flowElementNames.isEmpty()) {
                    query.setParameterList(HibernateErrorCategorisationDao.COMPONENT_NAMES, (Collection)flowElementNames);
                }
                if (startDate == null) {
                    query.setParameter(HibernateErrorCategorisationDao.START_DATE, (Object)0);
                } else {
                    query.setParameter(HibernateErrorCategorisationDao.START_DATE, (Object)startDate.getTime());
                }
                if (endDate == null) {
                    query.setParameter(HibernateErrorCategorisationDao.END_DATE, (Object)System.currentTimeMillis());
                } else {
                    query.setParameter(HibernateErrorCategorisationDao.END_DATE, (Object)endDate.getTime());
                }
                List rowCountList = query.list();
                Long rowCount = 0L;
                if (!rowCountList.isEmpty()) {
                    if (rowCountList.get(0) instanceof BigInteger) {
                        rowCount = ((BigInteger)rowCountList.get(0)).longValue();
                    } else if (rowCountList.get(0) instanceof Integer) {
                        rowCount = ((Integer)rowCountList.get(0)).longValue();
                    }
                }
                return rowCount;
            }
        });
    }
}

