/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.error.reporting.dao;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.ikasan.error.reporting.dao.ErrorManagementDao;
import org.ikasan.error.reporting.model.ErrorOccurrenceAction;
import org.ikasan.error.reporting.model.ErrorOccurrenceImpl;
import org.ikasan.error.reporting.model.ErrorOccurrenceLink;
import org.ikasan.error.reporting.model.ErrorOccurrenceNote;
import org.ikasan.error.reporting.model.Note;
import org.ikasan.spec.error.reporting.ErrorOccurrence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class HibernateErrorManagementDao
extends HibernateDaoSupport
implements ErrorManagementDao {
    private static Logger logger = LoggerFactory.getLogger(HibernateErrorManagementDao.class);
    public static final String EVENT_IDS = "eventIds";
    public static final String NOW = "now";
    public static final String ERROR_OCCURRENCES_TO_DELETE_QUERY = "select uri from ErrorOccurrenceImpl eo  where eo.expiry < :now";
    public static final String ERROR_OCCURRENCE_DELETE_QUERY = "delete ErrorOccurrenceImpl eo  where eo.uri in(:eventIds)";
    public static final String ERROR_OCCURENCE_NOTES_TO_DELETE_QUERY = "select id.noteId from ErrorOccurrenceNote where id.errorUri in (:eventIds)";
    public static final String NOTES_DELETE_QUERY = "delete Note n  where n.id in(:eventIds)";
    public static final String ERROR_OCCURRENCE_NOTE_DELETE_QUERY = "delete ErrorOccurrenceNote where id.errorUri in (:eventIds)";
    public static final String UPDATE_HARVESTED_QUERY = "update ErrorOccurrenceImpl w set w.harvestedDateTime = :now, w.harvested = 1 where w.id in(:eventIds)";

    @Override
    public void saveErrorOccurrenceAction(ErrorOccurrenceAction errorOccurrenceAction) {
        this.getHibernateTemplate().saveOrUpdate((Object)errorOccurrenceAction);
    }

    @Override
    public void saveErrorOccurrence(ErrorOccurrence errorOccurrence) {
        this.getHibernateTemplate().saveOrUpdate((Object)errorOccurrence);
    }

    @Override
    public void saveNote(Note note) {
        this.getHibernateTemplate().saveOrUpdate((Object)note);
    }

    @Override
    public void deleteNote(final Note note) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery("delete from ErrorOccurrenceNote where noteId = :noteId");
                query.setParameter("noteId", (Object)note.getId());
                query.executeUpdate();
                return null;
            }
        });
        this.getHibernateTemplate().delete((Object)note);
    }

    @Override
    public void saveErrorOccurrenceLink(ErrorOccurrenceLink errorOccurrenceLink) {
        this.getHibernateTemplate().saveOrUpdate((Object)errorOccurrenceLink);
    }

    @Override
    public void saveErrorOccurrenceNote(ErrorOccurrenceNote errorOccurrenceNote) {
        this.getHibernateTemplate().saveOrUpdate((Object)errorOccurrenceNote);
    }

    @Override
    public void deleteErrorOccurence(ErrorOccurrence errorOccurrence) {
        this.getHibernateTemplate().delete((Object)errorOccurrence);
    }

    @Override
    public List<ErrorOccurrence> findErrorOccurrences(List<String> errorUris) {
        return (List)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(ErrorOccurrence.class);
            Root root = criteriaQuery.from(ErrorOccurrenceImpl.class);
            criteriaQuery.select((Selection)root).where((Expression)root.get("uri").in((Collection)errorUris)).orderBy(new Order[]{builder.desc((Expression)root.get("timestamp"))});
            Query query = session.createQuery(criteriaQuery);
            query.setFirstResult(0);
            query.setMaxResults(2000);
            return query.getResultList();
        });
    }

    @Override
    public List<Note> getNotesByErrorUri(final String errorUri) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery("select n from ErrorOccurrenceNote ecn, Note n  where  ecn.id.noteId = n.id and ecn.id.errorUri = :errorUri order by n.timestamp asc");
                query.setParameter("errorUri", (Object)errorUri);
                return query.list();
            }
        });
    }

    @Override
    public List<ErrorOccurrence> findActionErrorOccurrences(List<String> moduleName, List<String> flowName, List<String> flowElementname, Date startDate, Date endDate) {
        return (List)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(ErrorOccurrence.class);
            Root root = criteriaQuery.from(ErrorOccurrenceImpl.class);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (moduleName != null && moduleName.size() > 0) {
                predicates.add(root.get("moduleName").in((Collection)moduleName));
            }
            if (flowName != null && flowName.size() > 0) {
                predicates.add(root.get("flowName").in((Collection)flowName));
            }
            if (flowElementname != null && flowElementname.size() > 0) {
                predicates.add(root.get("flowElementName").in((Collection)flowElementname));
            }
            if (startDate != null) {
                predicates.add(builder.greaterThan((Expression)root.get("userActionTimestamp"), (Comparable)Long.valueOf(startDate.getTime())));
            }
            if (endDate != null) {
                predicates.add(builder.lessThan((Expression)root.get("userActionTimestamp"), (Comparable)Long.valueOf(endDate.getTime())));
            }
            predicates.add(root.get("userAction").isNotNull());
            criteriaQuery.select((Selection)root).where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.desc((Expression)root.get("userActionTimestamp"))});
            Query query = session.createQuery(criteriaQuery);
            query.setFirstResult(0);
            query.setMaxResults(2000);
            List rowList = query.getResultList();
            return rowList;
        });
    }

    @Override
    public List<ErrorOccurrenceAction> houseKeepErrorOccurrenceActions() {
        return null;
    }

    @Override
    public List<String> getAllErrorUrisWithNote() {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery("select ecn.id.errorUri from ErrorOccurrenceNote ecn");
                return query.list();
            }
        });
    }

    @Override
    public List<ErrorOccurrenceNote> getErrorOccurrenceNotesByErrorUri(final String errorUri) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery("select ecn from ErrorOccurrenceNote ecn, Note n  where  ecn.id.noteId = n.id and ecn.id.errorUri = :errorUri order by n.timestamp asc");
                query.setParameter("errorUri", (Object)errorUri);
                return query.list();
            }
        });
    }

    @Override
    public void close(final List<String> uris, final String user) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery("update ErrorOccurrenceImpl set userAction = 'close', actionedBy = :user, userActionTimestamp = :timestamp where uri in :errorUris");
                query.setParameterList("errorUris", (Collection)uris);
                query.setParameter("user", (Object)user);
                query.setParameter("timestamp", (Object)System.currentTimeMillis());
                logger.debug("Query: " + query);
                query.executeUpdate();
                return null;
            }
        });
    }

    @Override
    public Long getNumberOfModuleErrors(String moduleName, boolean excluded, boolean actioned, Date startDate, Date endDate) {
        return (Long)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(Long.class);
            Root root = criteriaQuery.from(ErrorOccurrenceImpl.class);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (moduleName != null) {
                predicates.add(builder.equal((Expression)root.get("moduleName"), (Object)moduleName));
            }
            if (startDate != null) {
                predicates.add(builder.greaterThan((Expression)root.get("timestamp"), (Comparable)Long.valueOf(startDate.getTime())));
            }
            if (endDate != null) {
                predicates.add(builder.lessThan((Expression)root.get("timestamp"), (Comparable)Long.valueOf(endDate.getTime())));
            }
            if (excluded) {
                predicates.add(builder.equal((Expression)root.get("action"), (Object)"ExcludeEvent"));
            }
            if (actioned) {
                predicates.add(root.get("userAction").isNotNull());
            } else {
                predicates.add(root.get("userAction").isNull());
            }
            criteriaQuery.select((Selection)builder.count((Expression)root)).where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.desc((Expression)root.get("userActionTimestamp"))});
            Query query = session.createQuery(criteriaQuery);
            List rowCountList = query.getResultList();
            if (!rowCountList.isEmpty()) {
                return (Long)rowCountList.get(0);
            }
            return new Long(0L);
        });
    }

    @Override
    public void housekeep(final Integer numToHousekeep) {
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(HibernateErrorManagementDao.ERROR_OCCURRENCES_TO_DELETE_QUERY);
                query.setLong(HibernateErrorManagementDao.NOW, System.currentTimeMillis());
                query.setMaxResults(numToHousekeep.intValue());
                List errorUris = query.list();
                if (errorUris.size() > 0) {
                    query = session.createQuery(HibernateErrorManagementDao.ERROR_OCCURRENCE_NOTE_DELETE_QUERY);
                    query.setParameterList(HibernateErrorManagementDao.EVENT_IDS, (Collection)errorUris);
                    query.executeUpdate();
                    query = session.createQuery(HibernateErrorManagementDao.ERROR_OCCURENCE_NOTES_TO_DELETE_QUERY);
                    query.setParameterList(HibernateErrorManagementDao.EVENT_IDS, (Collection)errorUris);
                    List errorOccurenceNotesIds = query.list();
                    if (errorOccurenceNotesIds.size() > 0) {
                        query = session.createQuery(HibernateErrorManagementDao.NOTES_DELETE_QUERY);
                        query.setParameterList(HibernateErrorManagementDao.EVENT_IDS, (Collection)errorOccurenceNotesIds);
                        query.executeUpdate();
                    }
                    query = session.createQuery(HibernateErrorManagementDao.ERROR_OCCURRENCE_DELETE_QUERY);
                    query.setParameterList(HibernateErrorManagementDao.EVENT_IDS, (Collection)errorUris);
                    query.executeUpdate();
                }
                return null;
            }
        });
    }

    @Override
    public List<ErrorOccurrence> getHarvestableRecords(int harvestingBatchSize) {
        return (List)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(ErrorOccurrence.class);
            Root root = criteriaQuery.from(ErrorOccurrenceImpl.class);
            criteriaQuery.select((Selection)root).where((Expression)builder.equal((Expression)root.get("harvestedDateTime"), (Object)0)).orderBy(new Order[]{builder.asc((Expression)root.get("timestamp"))});
            Query query = session.createQuery(criteriaQuery);
            query.setMaxResults(harvestingBatchSize);
            return query.getResultList();
        });
    }

    @Override
    public void updateAsHarvested(final List<ErrorOccurrence> events) {
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException {
                ArrayList<String> wiretapEventIds = new ArrayList<String>();
                for (ErrorOccurrence event : events) {
                    wiretapEventIds.add(event.getUri());
                }
                List partitionedIds = Lists.partition(wiretapEventIds, (int)300);
                for (List eventIds : partitionedIds) {
                    Query query = session.createQuery(HibernateErrorManagementDao.UPDATE_HARVESTED_QUERY);
                    query.setParameter(HibernateErrorManagementDao.NOW, (Object)System.currentTimeMillis());
                    query.setParameterList(HibernateErrorManagementDao.EVENT_IDS, (Collection)eventIds);
                    query.executeUpdate();
                }
                return null;
            }
        });
    }
}

