/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.error.reporting.dao;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.ikasan.error.reporting.model.ErrorOccurrenceImpl;
import org.ikasan.model.ArrayListPagedSearchResult;
import org.ikasan.spec.error.reporting.ErrorOccurrence;
import org.ikasan.spec.error.reporting.ErrorReportingServiceDao;
import org.ikasan.spec.search.PagedSearchResult;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class HibernateErrorReportingServiceDao
extends HibernateDaoSupport
implements ErrorReportingServiceDao<ErrorOccurrence, String> {
    private static Integer housekeepingBatchSize = 100;
    private static final String BATCHED_HOUSEKEEP_QUERY = "delete ErrorOccurrenceImpl s where s.uri in (:event_uris)";

    public ErrorOccurrence find(String uri) {
        return (ErrorOccurrence)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(ErrorOccurrence.class);
            Root root = criteriaQuery.from(ErrorOccurrenceImpl.class);
            criteriaQuery.select((Selection)root).where((Expression)builder.equal((Expression)root.get("uri"), (Object)uri));
            Query query = session.createQuery(criteriaQuery);
            List results = query.getResultList();
            if (results == null || results.size() == 0) {
                return null;
            }
            return (ErrorOccurrence)results.get(0);
        });
    }

    public Map<String, ErrorOccurrence> find(List<String> uris) {
        HashMap<String, ErrorOccurrence> results = new HashMap<String, ErrorOccurrence>();
        List partitions = Lists.partition(uris, (int)300);
        for (List partition : partitions) {
            Map<String, ErrorOccurrence> r = this.getUri(partition).collect(Collectors.toMap(e -> e.getUri(), e -> e));
            results.putAll(r);
        }
        return results;
    }

    private Stream<ErrorOccurrence> getUri(List<String> partition) {
        return (Stream)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(ErrorOccurrence.class);
            Root root = criteriaQuery.from(ErrorOccurrenceImpl.class);
            criteriaQuery.select((Selection)root).where((Expression)root.get("uri").in((Collection)partition));
            Query query = session.createQuery(criteriaQuery);
            return query.getResultStream();
        });
    }

    public List<ErrorOccurrence> find(List<String> moduleName, List<String> flowName, List<String> flowElementname, Date startDate, Date endDate, int size) {
        return (List)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(ErrorOccurrence.class);
            Root root = criteriaQuery.from(ErrorOccurrenceImpl.class);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (moduleName != null && moduleName.size() > 0) {
                predicates.add(root.get("moduleName").in((Collection)moduleName));
            }
            if (flowName != null && flowName.size() > 0) {
                predicates.add(root.get("flowName").in((Collection)flowName));
            }
            if (flowElementname != null && flowElementname.size() > 0) {
                predicates.add(root.get("flowElementName").in((Collection)flowElementname));
            }
            if (startDate != null) {
                predicates.add(builder.greaterThan((Expression)root.get("timestamp"), (Comparable)Long.valueOf(startDate.getTime())));
            }
            if (endDate != null) {
                predicates.add(builder.lessThan((Expression)root.get("timestamp"), (Comparable)Long.valueOf(endDate.getTime())));
            }
            predicates.add(root.get("userAction").isNull());
            criteriaQuery.select((Selection)root).where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.desc((Expression)root.get("timestamp"))});
            Query query = session.createQuery(criteriaQuery);
            query.setMaxResults(size);
            return query.getResultList();
        });
    }

    public PagedSearchResult<ErrorOccurrence> find(final int pageNo, final int pageSize, final String orderBy, final boolean orderAscending, final String moduleName, final String flowName, final String componentName, final Date fromDate, final Date untilDate) {
        return (PagedSearchResult)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException {
                CriteriaBuilder builder = session.getCriteriaBuilder();
                CriteriaQuery criteriaQuery = builder.createQuery(ErrorOccurrence.class);
                Root root = criteriaQuery.from(ErrorOccurrenceImpl.class);
                List<Predicate> predicates = this.getCriteria(builder, (Root<ErrorOccurrenceImpl>)root);
                criteriaQuery.select((Selection)root).where(predicates.toArray(new Predicate[predicates.size()]));
                if (orderBy != null) {
                    if (orderAscending) {
                        criteriaQuery.orderBy(new Order[]{builder.asc((Expression)root.get(orderBy))});
                    } else {
                        criteriaQuery.orderBy(new Order[]{builder.desc((Expression)root.get(orderBy))});
                    }
                } else {
                    criteriaQuery.orderBy(new Order[]{builder.desc((Expression)root.get("timestamp"))});
                }
                Query query = session.createQuery(criteriaQuery);
                query.setMaxResults(pageSize);
                int firstResult = pageNo * pageSize;
                query.setFirstResult(firstResult);
                List results = query.getResultList();
                Long rowCount = this.rowCount(session);
                return new ArrayListPagedSearchResult(results, firstResult, rowCount.longValue());
            }

            private Long rowCount(Session session) {
                CriteriaBuilder builder = session.getCriteriaBuilder();
                CriteriaQuery metaDataCriteriaQuery = builder.createQuery(Long.class);
                Root root = metaDataCriteriaQuery.from(ErrorOccurrenceImpl.class);
                List<Predicate> predicates = this.getCriteria(builder, (Root<ErrorOccurrenceImpl>)root);
                metaDataCriteriaQuery.select((Selection)builder.count((Expression)root)).where(predicates.toArray(new Predicate[predicates.size()]));
                Query metaDataQuery = session.createQuery(metaDataCriteriaQuery);
                List rowCountList = metaDataQuery.getResultList();
                if (!rowCountList.isEmpty()) {
                    return (Long)rowCountList.get(0);
                }
                return new Long(0L);
            }

            private List<Predicate> getCriteria(CriteriaBuilder builder, Root<ErrorOccurrenceImpl> root) {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (moduleName != null) {
                    predicates.add(builder.equal((Expression)root.get("moduleName"), (Object)moduleName));
                }
                if (flowName != null) {
                    predicates.add(builder.equal((Expression)root.get("flowName"), (Object)flowName));
                }
                if (componentName != null) {
                    predicates.add(builder.equal((Expression)root.get("flowElementName"), (Object)componentName));
                }
                if (fromDate != null) {
                    predicates.add(builder.greaterThan((Expression)root.get("timestamp"), (Comparable)Long.valueOf(fromDate.getTime())));
                }
                if (untilDate != null) {
                    predicates.add(builder.lessThan((Expression)root.get("timestamp"), (Comparable)Long.valueOf(untilDate.getTime())));
                }
                predicates.add(root.get("userAction").isNull());
                return predicates;
            }
        });
    }

    public void save(ErrorOccurrence errorOccurrence) {
        this.getHibernateTemplate().saveOrUpdate((Object)errorOccurrence);
    }

    public void save(List<ErrorOccurrence> errorOccurrences) {
        errorOccurrences.forEach(errorOccurrence -> this.save((ErrorOccurrence)errorOccurrence));
    }

    public void deleteExpired() {
        while (this.housekeepablesExist()) {
            List<String> housekeepableBatch = this.getHousekeepableBatch();
            this.getHibernateTemplate().execute(session -> {
                Query query = session.createQuery(BATCHED_HOUSEKEEP_QUERY);
                query.setParameterList("event_uris", (Collection)housekeepableBatch);
                query.executeUpdate();
                return null;
            });
        }
    }

    private List<String> getHousekeepableBatch() {
        return (List)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(String.class);
            Root root = criteriaQuery.from(ErrorOccurrenceImpl.class);
            criteriaQuery.select((Selection)root.get("uri")).where((Expression)builder.lessThan((Expression)root.get("expiry"), (Comparable)Long.valueOf(System.currentTimeMillis())));
            Query query = session.createQuery(criteriaQuery);
            query.setMaxResults(housekeepingBatchSize.intValue());
            return query.getResultList();
        });
    }

    private boolean housekeepablesExist() {
        return (Boolean)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(Long.class);
            Root root = criteriaQuery.from(ErrorOccurrenceImpl.class);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.lessThan((Expression)root.get("expiry"), (Comparable)Long.valueOf(System.currentTimeMillis())));
            criteriaQuery.select((Selection)builder.count((Expression)root)).where(predicates.toArray(new Predicate[predicates.size()]));
            Query query = session.createQuery(criteriaQuery);
            List rowCountList = query.getResultList();
            Long rowCount = new Long(0L);
            if (!rowCountList.isEmpty()) {
                rowCount = (Long)rowCountList.get(0);
            }
            return new Boolean(rowCount > 0L);
        });
    }

    public Long rowCount(List<String> moduleName, List<String> flowName, List<String> flowElementname, Date startDate, Date endDate) {
        return (Long)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(Long.class);
            Root root = criteriaQuery.from(ErrorOccurrenceImpl.class);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (moduleName != null && moduleName.size() > 0) {
                predicates.add(root.get("moduleName").in((Collection)moduleName));
            }
            if (flowName != null && flowName.size() > 0) {
                predicates.add(root.get("flowName").in((Collection)flowName));
            }
            if (flowElementname != null && flowElementname.size() > 0) {
                predicates.add(root.get("flowElementName").in((Collection)flowElementname));
            }
            if (startDate != null) {
                predicates.add(builder.greaterThan((Expression)root.get("timestamp"), (Comparable)Long.valueOf(startDate.getTime())));
            }
            if (endDate != null) {
                predicates.add(builder.lessThan((Expression)root.get("timestamp"), (Comparable)Long.valueOf(endDate.getTime())));
            }
            predicates.add(root.get("userAction").isNull());
            criteriaQuery.select((Selection)builder.count((Expression)root)).where(predicates.toArray(new Predicate[predicates.size()]));
            Query query = session.createQuery(criteriaQuery);
            List rowCountList = query.getResultList();
            Long rowCount = new Long(0L);
            if (!rowCountList.isEmpty()) {
                rowCount = (Long)rowCountList.get(0);
            }
            return rowCount;
        });
    }

    public List<ErrorOccurrence> find(List<String> moduleName, List<String> flowName, List<String> flowElementname, Date startDate, Date endDate, String action, String exceptionClass, int size) {
        return (List)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(ErrorOccurrence.class);
            Root root = criteriaQuery.from(ErrorOccurrenceImpl.class);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (moduleName != null && moduleName.size() > 0) {
                predicates.add(root.get("moduleName").in((Collection)moduleName));
            }
            if (flowName != null && flowName.size() > 0) {
                predicates.add(root.get("flowName").in((Collection)flowName));
            }
            if (flowElementname != null && flowElementname.size() > 0) {
                predicates.add(root.get("flowElementName").in((Collection)flowElementname));
            }
            if (startDate != null) {
                predicates.add(builder.greaterThan((Expression)root.get("timestamp"), (Comparable)Long.valueOf(startDate.getTime())));
            }
            if (endDate != null) {
                predicates.add(builder.lessThan((Expression)root.get("timestamp"), (Comparable)Long.valueOf(endDate.getTime())));
            }
            if (exceptionClass != null) {
                predicates.add(builder.equal((Expression)root.get("exceptionClass"), (Object)exceptionClass));
            }
            if (action != null) {
                predicates.add(builder.equal((Expression)root.get("action"), (Object)action));
            }
            predicates.add(root.get("userAction").isNull());
            criteriaQuery.select((Selection)root).where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.desc((Expression)root.get("timestamp"))});
            Query query = session.createQuery(criteriaQuery);
            query.setMaxResults(size);
            List rowList = query.getResultList();
            return rowList;
        });
    }
}

