/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.error.reporting.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ikasan.spec.error.reporting.ErrorOccurrence;
import org.ikasan.spec.error.reporting.ErrorReportingServiceDao;
import org.ikasan.spec.search.PagedSearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapErrorReportingServiceDao<T>
implements ErrorReportingServiceDao<ErrorOccurrence, String> {
    private static Logger logger = LoggerFactory.getLogger(MapErrorReportingServiceDao.class);
    LinkedHashMap<String, ErrorOccurrence> errorOccurrences;

    public MapErrorReportingServiceDao(LinkedHashMap<String, ErrorOccurrence> errorOccurrences) {
        this.errorOccurrences = errorOccurrences;
        if (errorOccurrences == null) {
            throw new IllegalArgumentException("errorOccurrences implementation cannot be 'null'");
        }
    }

    public ErrorOccurrence find(String uri) {
        return this.errorOccurrences.get(uri);
    }

    public void save(ErrorOccurrence errorOccurrence) {
        this.errorOccurrences.put(errorOccurrence.getUri(), errorOccurrence);
    }

    public void save(List<ErrorOccurrence> errorOccurrences) {
        errorOccurrences.forEach(errorOccurrence -> this.save((ErrorOccurrence)errorOccurrence));
    }

    public void deleteExpired() {
        ArrayList<String> expiredIdentifiers = new ArrayList<String>();
        long expiryTime = System.currentTimeMillis();
        for (Map.Entry<String, ErrorOccurrence> entry : this.errorOccurrences.entrySet()) {
            if (entry.getValue().getExpiry() >= expiryTime) continue;
            expiredIdentifiers.add(entry.getKey());
        }
        for (String expiredIdentifier : expiredIdentifiers) {
            this.errorOccurrences.remove(expiredIdentifier);
        }
        if (logger.isDebugEnabled()) {
            logger.info("Deleted expired errorOccurrences events for identifiers[" + expiredIdentifiers + "]");
        }
    }

    public Map find(List uris) {
        return null;
    }

    public List<ErrorOccurrence> find(List<String> moduleName, List<String> flowName, List<String> flowElementname, Date startDate, Date endDate, int size) {
        return null;
    }

    public Long rowCount(List<String> moduleName, List<String> flowName, List<String> flowElementname, Date startDate, Date endDate) {
        return null;
    }

    public List<ErrorOccurrence> find(List<String> moduleName, List<String> flowName, List<String> flowElementname, Date startDate, Date endDate, String action, String exceptionClass, int size) {
        return null;
    }

    public PagedSearchResult<ErrorOccurrence> find(int pageNo, int pageSize, String orderBy, boolean orderAscending, String moduleName, String flowName, String componentName, Date fromDate, Date untilDate) {
        return null;
    }
}

