/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.error.reporting.model;

import org.ikasan.error.reporting.model.ErrorOccurrenceImpl;

public class ErrorOccurrenceAction {
    private String uri;
    private String moduleName;
    private String flowName;
    private String flowElementName;
    private String errorDetail;
    private String errorMessage;
    private String exceptionClass;
    private String eventLifeIdentifier;
    private String eventRelatedIdentifier;
    private String action;
    private byte[] event;
    private long timestamp;
    private long expiry;
    private String userAction;
    private String actionedBy;
    private long userActionTimestamp;

    private ErrorOccurrenceAction() {
    }

    public ErrorOccurrenceAction(ErrorOccurrenceImpl errorOccurrence, String userAction, String actionedBy, long timeToLive) {
        if (errorOccurrence == null) {
            throw new IllegalArgumentException("errorOccurrence cannot be 'null");
        }
        this.moduleName = errorOccurrence.getModuleName();
        if (this.moduleName == null) {
            throw new IllegalArgumentException("moduleName cannot be 'null");
        }
        this.flowName = errorOccurrence.getFlowName();
        if (this.flowName == null) {
            throw new IllegalArgumentException("flowName cannot be 'null");
        }
        this.flowElementName = errorOccurrence.getFlowElementName();
        if (this.flowElementName == null) {
            throw new IllegalArgumentException("flowElementName cannot be 'null");
        }
        this.actionedBy = actionedBy;
        if (this.actionedBy == null) {
            throw new IllegalArgumentException("actionedBy cannot be 'null");
        }
        this.userAction = userAction;
        if (this.userAction == null) {
            throw new IllegalArgumentException("actiouserActionnedBy cannot be 'null");
        }
        this.errorDetail = errorOccurrence.getErrorDetail();
        this.exceptionClass = errorOccurrence.getExceptionClass();
        this.action = errorOccurrence.getAction();
        this.errorMessage = errorOccurrence.getErrorMessage();
        this.event = errorOccurrence.getEvent();
        this.timestamp = errorOccurrence.getTimestamp();
        this.userActionTimestamp = System.currentTimeMillis();
        this.uri = errorOccurrence.getUri();
        this.expiry = System.currentTimeMillis() + timeToLive;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    private void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getFlowName() {
        return this.flowName;
    }

    private void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public String getFlowElementName() {
        return this.flowElementName;
    }

    private void setFlowElementName(String flowElementName) {
        this.flowElementName = flowElementName;
    }

    public String getErrorDetail() {
        return this.errorDetail;
    }

    private void setErrorDetail(String errorDetail) {
        this.errorDetail = errorDetail;
    }

    public String getEventLifeIdentifier() {
        return this.eventLifeIdentifier;
    }

    public void setEventLifeIdentifier(String eventLifeIdentifier) {
        this.eventLifeIdentifier = eventLifeIdentifier;
    }

    public byte[] getEvent() {
        return this.event;
    }

    private void setEvent(byte[] event) {
        this.event = event;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    private void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getExpiry() {
        return this.expiry;
    }

    private void setExpiry(long expiry) {
        this.expiry = expiry;
    }

    public String getEventRelatedIdentifier() {
        return this.eventRelatedIdentifier;
    }

    public void setEventRelatedIdentifier(String eventRelatedIdentifier) {
        this.eventRelatedIdentifier = eventRelatedIdentifier;
    }

    public String getUri() {
        return this.uri;
    }

    private void setUri(String uri) {
        this.uri = uri;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getExceptionClass() {
        return this.exceptionClass;
    }

    public void setExceptionClass(String exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    public String getUserAction() {
        return this.userAction;
    }

    public void setUserAction(String userAction) {
        this.userAction = userAction;
    }

    public String getActionedBy() {
        return this.actionedBy;
    }

    public void setActionedBy(String actionedBy) {
        this.actionedBy = actionedBy;
    }

    public long getUserActionTimestamp() {
        return this.userActionTimestamp;
    }

    public void setUserActionTimestamp(long userActionTimestamp) {
        this.userActionTimestamp = userActionTimestamp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
        result = 31 * result + (this.actionedBy == null ? 0 : this.actionedBy.hashCode());
        result = 31 * result + (this.errorDetail == null ? 0 : this.errorDetail.hashCode());
        result = 31 * result + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
        result = 31 * result + (this.eventLifeIdentifier == null ? 0 : this.eventLifeIdentifier.hashCode());
        result = 31 * result + (this.eventRelatedIdentifier == null ? 0 : this.eventRelatedIdentifier.hashCode());
        result = 31 * result + (this.exceptionClass == null ? 0 : this.exceptionClass.hashCode());
        result = 31 * result + (int)(this.expiry ^ this.expiry >>> 32);
        result = 31 * result + (this.flowElementName == null ? 0 : this.flowElementName.hashCode());
        result = 31 * result + (this.flowName == null ? 0 : this.flowName.hashCode());
        result = 31 * result + (this.moduleName == null ? 0 : this.moduleName.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        result = 31 * result + (this.userAction == null ? 0 : this.userAction.hashCode());
        result = 31 * result + (int)(this.userActionTimestamp ^ this.userActionTimestamp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorOccurrenceAction other = (ErrorOccurrenceAction)obj;
        if (this.action == null ? other.action != null : !this.action.equals(other.action)) {
            return false;
        }
        if (this.actionedBy == null ? other.actionedBy != null : !this.actionedBy.equals(other.actionedBy)) {
            return false;
        }
        if (this.errorDetail == null ? other.errorDetail != null : !this.errorDetail.equals(other.errorDetail)) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.event == null ? other.event != null : !this.event.equals(other.event)) {
            return false;
        }
        if (this.eventLifeIdentifier == null ? other.eventLifeIdentifier != null : !this.eventLifeIdentifier.equals(other.eventLifeIdentifier)) {
            return false;
        }
        if (this.eventRelatedIdentifier == null ? other.eventRelatedIdentifier != null : !this.eventRelatedIdentifier.equals(other.eventRelatedIdentifier)) {
            return false;
        }
        if (this.exceptionClass == null ? other.exceptionClass != null : !this.exceptionClass.equals(other.exceptionClass)) {
            return false;
        }
        if (this.expiry != other.expiry) {
            return false;
        }
        if (this.flowElementName == null ? other.flowElementName != null : !this.flowElementName.equals(other.flowElementName)) {
            return false;
        }
        if (this.flowName == null ? other.flowName != null : !this.flowName.equals(other.flowName)) {
            return false;
        }
        if (this.moduleName == null ? other.moduleName != null : !this.moduleName.equals(other.moduleName)) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
            return false;
        }
        if (this.userAction == null ? other.userAction != null : !this.userAction.equals(other.userAction)) {
            return false;
        }
        return this.userActionTimestamp == other.userActionTimestamp;
    }

    public String toString() {
        return "ErrorOccurrenceAction [uri=" + this.uri + ", moduleName=" + this.moduleName + ", flowName=" + this.flowName + ", flowElementName=" + this.flowElementName + ", errorDetail=" + this.errorDetail + ", errorMessage=" + this.errorMessage + ", exceptionClass=" + this.exceptionClass + ", eventLifeIdentifier=" + this.eventLifeIdentifier + ", eventRelatedIdentifier=" + this.eventRelatedIdentifier + ", action=" + this.action + ", event=" + this.event + ", timestamp=" + this.timestamp + ", expiry=" + this.expiry + ", userAction=" + this.userAction + ", actionedBy=" + this.actionedBy + ", userActionTimestamp=" + this.userActionTimestamp + "]";
    }
}

