/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.error.reporting.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ikasan.error.reporting.dao.ErrorCategorisationDao;
import org.ikasan.error.reporting.model.CategorisedErrorOccurrence;
import org.ikasan.error.reporting.model.ErrorCategorisation;
import org.ikasan.error.reporting.model.ErrorCategorisationLink;
import org.ikasan.error.reporting.model.ErrorOccurrenceImpl;
import org.ikasan.error.reporting.service.ErrorCategorisationService;
import org.ikasan.spec.error.reporting.ErrorReportingServiceDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorCategorisationServiceImpl
implements ErrorCategorisationService {
    private static Logger logger = LoggerFactory.getLogger(ErrorCategorisationServiceImpl.class);
    private ErrorCategorisationDao errorCategorisationDao;
    private ErrorReportingServiceDao errorReportingService;

    public ErrorCategorisationServiceImpl(ErrorCategorisationDao errorCategorisationDao, ErrorReportingServiceDao errorReportingService) {
        this.errorCategorisationDao = errorCategorisationDao;
        if (this.errorCategorisationDao == null) {
            throw new IllegalArgumentException("errorCategorisationDao cannot be null!!");
        }
        this.errorReportingService = errorReportingService;
        if (this.errorReportingService == null) {
            throw new IllegalArgumentException("errorReportingService cannot be null!!");
        }
    }

    @Override
    public void save(ErrorCategorisation errorCategorisation) {
        this.errorCategorisationDao.save(errorCategorisation);
    }

    @Override
    public List<ErrorCategorisationLink> find(String moduleName, String flowName, String flowElementName) {
        return this.errorCategorisationDao.find(moduleName, flowName, flowElementName);
    }

    @Override
    public ErrorCategorisationLink find(String moduleName, String flowName, String flowElementName, String action) {
        return this.errorCategorisationDao.find(moduleName, flowName, flowElementName, action);
    }

    @Override
    public void delete(ErrorCategorisation errorCategorisation) {
        this.errorCategorisationDao.delete(errorCategorisation);
    }

    @Override
    public void save(ErrorCategorisationLink errorCategorisationLink) {
        this.errorCategorisationDao.save(errorCategorisationLink);
    }

    @Override
    public void delete(ErrorCategorisationLink errorCategorisationLink) {
        this.errorCategorisationDao.delete(errorCategorisationLink);
    }

    @Override
    public List<CategorisedErrorOccurrence> findCategorisedErrorOccurences(List<String> moduleNames, List<String> flowNames, List<String> flowElementNames, String action, String exceptionClass, String errorCategory, Date startDate, Date endDate, int size) {
        List errorOccurrences = this.errorReportingService.find(moduleNames, flowNames, flowElementNames, startDate, endDate, size);
        Map<CategorisedErrorKey, ErrorCategorisation> categorisedErrorMap = this.getErrorCategorisationMap();
        ArrayList<CategorisedErrorOccurrence> categorisedErrorOccurrences = new ArrayList<CategorisedErrorOccurrence>();
        for (ErrorOccurrenceImpl errorOccurrence : errorOccurrences) {
            logger.debug("Action: " + this.getAction(errorOccurrence));
            if (errorOccurrence.getExceptionClass() == null) {
                errorOccurrence.setExceptionClass("");
            }
            CategorisedErrorKey key = new CategorisedErrorKey(errorOccurrence.getModuleName(), errorOccurrence.getFlowName(), errorOccurrence.getFlowElementName(), this.getAction(errorOccurrence), errorOccurrence.getExceptionClass().trim());
            logger.debug("Using key " + key);
            ErrorCategorisation errorCategorisation = categorisedErrorMap.get(key);
            logger.debug("errorCategorisation: " + errorCategorisation);
            if (errorCategorisation == null) {
                key = new CategorisedErrorKey(errorOccurrence.getModuleName(), errorOccurrence.getFlowName(), errorOccurrence.getFlowElementName(), this.getAction(errorOccurrence), "");
                logger.debug("Using key " + key);
                errorCategorisation = categorisedErrorMap.get(key);
                logger.debug("errorCategorisation: " + errorCategorisation);
            }
            if (errorCategorisation == null) {
                key = new CategorisedErrorKey(errorOccurrence.getModuleName(), errorOccurrence.getFlowName(), errorOccurrence.getFlowElementName(), "", "");
                logger.debug("Using key " + key);
                errorCategorisation = categorisedErrorMap.get(key);
                logger.debug("errorCategorisation: " + errorCategorisation);
            }
            if (errorCategorisation == null) {
                key = new CategorisedErrorKey(errorOccurrence.getModuleName(), errorOccurrence.getFlowName(), "", this.getAction(errorOccurrence), errorOccurrence.getExceptionClass().trim());
                logger.debug("Using key " + key);
                errorCategorisation = categorisedErrorMap.get(key);
                logger.debug("errorCategorisation: " + errorCategorisation);
            }
            if (errorCategorisation == null) {
                key = new CategorisedErrorKey(errorOccurrence.getModuleName(), errorOccurrence.getFlowName(), "", "", errorOccurrence.getExceptionClass().trim());
                logger.debug("Using key " + key);
                errorCategorisation = categorisedErrorMap.get(key);
                logger.debug("errorCategorisation: " + errorCategorisation);
            }
            if (errorCategorisation == null) {
                key = new CategorisedErrorKey(errorOccurrence.getModuleName(), errorOccurrence.getFlowName(), "", this.getAction(errorOccurrence), "");
                logger.debug("Using key " + key);
                errorCategorisation = categorisedErrorMap.get(key);
                logger.debug("errorCategorisation: " + errorCategorisation);
            }
            if (errorCategorisation == null) {
                key = new CategorisedErrorKey(errorOccurrence.getModuleName(), errorOccurrence.getFlowName(), "", "", "");
                logger.debug("Using key " + key);
                errorCategorisation = categorisedErrorMap.get(key);
                logger.debug("errorCategorisation: " + errorCategorisation);
            }
            if (errorCategorisation == null) {
                key = new CategorisedErrorKey(errorOccurrence.getModuleName(), "", "", this.getAction(errorOccurrence), errorOccurrence.getExceptionClass().trim());
                logger.debug("Using key " + key);
                errorCategorisation = categorisedErrorMap.get(key);
                logger.debug("errorCategorisation: " + errorCategorisation);
            }
            if (errorCategorisation == null) {
                key = new CategorisedErrorKey(errorOccurrence.getModuleName(), "", "", "", errorOccurrence.getExceptionClass().trim());
                logger.debug("Using key " + key);
                errorCategorisation = categorisedErrorMap.get(key);
                logger.debug("errorCategorisation: " + errorCategorisation);
            }
            if (errorCategorisation == null) {
                key = new CategorisedErrorKey(errorOccurrence.getModuleName(), "", "", this.getAction(errorOccurrence), "");
                logger.debug("Using key " + key);
                errorCategorisation = categorisedErrorMap.get(key);
                logger.debug("errorCategorisation: " + errorCategorisation);
            }
            if (errorCategorisation == null) {
                key = new CategorisedErrorKey(errorOccurrence.getModuleName(), "", "", "", "");
                logger.debug("Using key " + key);
                errorCategorisation = categorisedErrorMap.get(key);
                logger.debug("errorCategorisation: " + errorCategorisation);
            }
            if (errorCategorisation == null) {
                key = new CategorisedErrorKey("", "", "", this.getAction(errorOccurrence), errorOccurrence.getExceptionClass().trim());
                logger.debug("Using key " + key);
                errorCategorisation = categorisedErrorMap.get(key);
                logger.debug("errorCategorisation: " + errorCategorisation);
            }
            if (errorCategorisation == null) {
                key = new CategorisedErrorKey("", "", "", "", errorOccurrence.getExceptionClass().trim());
                logger.debug("Using key " + key);
                errorCategorisation = categorisedErrorMap.get(key);
                logger.debug("errorCategorisation: " + errorCategorisation);
            }
            if (errorCategorisation == null) {
                key = new CategorisedErrorKey("", "", "", this.getAction(errorOccurrence), "");
                logger.debug("Using key " + key);
                errorCategorisation = categorisedErrorMap.get(key);
                logger.debug("errorCategorisation: " + errorCategorisation);
            }
            if (errorCategorisation == null) {
                key = new CategorisedErrorKey("", "", "", "", "");
                logger.debug("Using key " + key);
                errorCategorisation = categorisedErrorMap.get(key);
                logger.debug("errorCategorisation: " + errorCategorisation);
            }
            if (errorCategorisation == null || errorCategory != null && !errorCategory.equals(errorCategorisation.getErrorCategory())) continue;
            categorisedErrorOccurrences.add(new CategorisedErrorOccurrence(errorOccurrence, errorCategorisation));
        }
        logger.debug("returning: " + categorisedErrorOccurrences.size());
        return categorisedErrorOccurrences;
    }

    protected Map<CategorisedErrorKey, ErrorCategorisation> getErrorCategorisationMap() {
        List<ErrorCategorisationLink> errorCategorisations = this.errorCategorisationDao.findAllErrorCategorisationLinks();
        HashMap<CategorisedErrorKey, ErrorCategorisation> map = new HashMap<CategorisedErrorKey, ErrorCategorisation>();
        for (ErrorCategorisationLink errorCategorisationLink : errorCategorisations) {
            CategorisedErrorKey key = new CategorisedErrorKey(errorCategorisationLink.getModuleName().trim(), errorCategorisationLink.getFlowName().trim(), errorCategorisationLink.getFlowElementName().trim(), errorCategorisationLink.getAction().trim(), errorCategorisationLink.getExceptionClass().trim());
            logger.debug("Adding key " + key);
            logger.debug("Adding value " + errorCategorisationLink.getErrorCategorisation());
            map.put(key, errorCategorisationLink.getErrorCategorisation());
        }
        return map;
    }

    protected String getAction(ErrorOccurrenceImpl errorOccurrence) {
        if (errorOccurrence.getAction() == null) {
            return null;
        }
        if (errorOccurrence.getAction().startsWith("ExcludeEvent")) {
            return "ExcludeEvent";
        }
        if (errorOccurrence.getAction().startsWith("Stop")) {
            return "Stop";
        }
        if (errorOccurrence.getAction().startsWith("Retry")) {
            return "Retry";
        }
        if (errorOccurrence.getAction().startsWith("Warning")) {
            return "Warning";
        }
        return "";
    }

    @Override
    public Long rowCount(List<String> moduleNames, List<String> flowNames, List<String> flowElementNames, Date startDate, Date endDate) {
        return this.errorCategorisationDao.rowCount(moduleNames, flowNames, flowElementNames, startDate, endDate);
    }

    private class CategorisedErrorKey {
        String moduleName;
        String flowName;
        String flowElementName;
        String action;
        String exceptionClass;

        public CategorisedErrorKey(String moduleName, String flowName, String flowElementName, String action, String exceptionClass) {
            this.moduleName = moduleName;
            this.flowName = flowName;
            this.flowElementName = flowElementName;
            this.action = action;
            this.exceptionClass = exceptionClass;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
            result = 31 * result + (this.exceptionClass == null ? 0 : this.exceptionClass.hashCode());
            result = 31 * result + (this.flowElementName == null ? 0 : this.flowElementName.hashCode());
            result = 31 * result + (this.flowName == null ? 0 : this.flowName.hashCode());
            result = 31 * result + (this.moduleName == null ? 0 : this.moduleName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CategorisedErrorKey other = (CategorisedErrorKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.action == null ? other.action != null : !this.action.equals(other.action)) {
                return false;
            }
            if (this.exceptionClass == null ? other.exceptionClass != null : !this.exceptionClass.equals(other.exceptionClass)) {
                return false;
            }
            if (this.flowElementName == null ? other.flowElementName != null : !this.flowElementName.equals(other.flowElementName)) {
                return false;
            }
            if (this.flowName == null ? other.flowName != null : !this.flowName.equals(other.flowName)) {
                return false;
            }
            return !(this.moduleName == null ? other.moduleName != null : !this.moduleName.equals(other.moduleName));
        }

        private ErrorCategorisationServiceImpl getOuterType() {
            return ErrorCategorisationServiceImpl.this;
        }

        public String toString() {
            return "CategorisedErrorKey [moduleName=" + this.moduleName + ", flowName=" + this.flowName + ", flowElementName=" + this.flowElementName + ", action=" + this.action + ", exceptionClass=" + this.exceptionClass + "]";
        }
    }
}

