/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.error.reporting.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.ikasan.error.reporting.dao.ErrorManagementDao;
import org.ikasan.error.reporting.dao.ErrorOccurrenceConverter;
import org.ikasan.error.reporting.model.ErrorOccurrenceNote;
import org.ikasan.error.reporting.model.ModuleErrorCount;
import org.ikasan.error.reporting.model.Note;
import org.ikasan.spec.error.reporting.ErrorOccurrence;
import org.ikasan.spec.error.reporting.ErrorReportingManagementService;
import org.ikasan.spec.error.reporting.ErrorReportingServiceDao;
import org.ikasan.spec.harvest.HarvestService;
import org.ikasan.spec.housekeeping.HousekeepService;
import org.ikasan.spec.persistence.BatchInsert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorReportingManagementServiceImpl
implements ErrorReportingManagementService<ErrorOccurrence, Note, ErrorOccurrenceNote, ModuleErrorCount>,
HousekeepService,
HarvestService<ErrorOccurrence>,
BatchInsert<ErrorOccurrence> {
    private static Logger logger = LoggerFactory.getLogger(ErrorReportingManagementServiceImpl.class);
    public static final String CLOSE = "close";
    private ErrorManagementDao errorManagementDao;
    private ErrorReportingServiceDao errorReportingServiceDao;
    private int batchSize = 100;
    private int transactionBatchSize = 1000;
    private ErrorOccurrenceConverter errorOccurrenceConverter;

    public ErrorReportingManagementServiceImpl(ErrorManagementDao errorManagementDao, ErrorReportingServiceDao errorReportingServiceDao) {
        this.errorManagementDao = errorManagementDao;
        if (this.errorManagementDao == null) {
            throw new IllegalArgumentException("errorManagementDao cannot be null!");
        }
        this.errorReportingServiceDao = errorReportingServiceDao;
        if (this.errorReportingServiceDao == null) {
            throw new IllegalArgumentException("errorManagementDao cannot be null!");
        }
        this.errorOccurrenceConverter = new ErrorOccurrenceConverter();
    }

    public void update(List<String> uris, String noteString, String user) {
        Note note = null;
        if (noteString != null && noteString.length() > 0) {
            note = new Note(noteString, user);
            this.errorManagementDao.saveNote(note);
        }
        for (String uri : uris) {
            if (note == null) continue;
            ErrorOccurrenceNote errorOccurrenceNote = new ErrorOccurrenceNote(uri, note);
            this.errorManagementDao.saveErrorOccurrenceNote(errorOccurrenceNote);
        }
    }

    public void close(List<String> uris, String noteString, String user) {
        Note note = null;
        if (noteString != null && noteString.length() > 0) {
            note = new Note(noteString, user);
            this.errorManagementDao.saveNote(note);
        }
        for (String uri : uris) {
            ErrorOccurrenceNote errorOccurrenceNote = new ErrorOccurrenceNote(uri, note);
            this.errorManagementDao.saveErrorOccurrenceNote(errorOccurrenceNote);
        }
        int i = 0;
        while (i < uris.size()) {
            ArrayList<String> batchUris = new ArrayList<String>();
            int endMarker = 0;
            endMarker = i + this.batchSize < uris.size() ? i + this.batchSize : uris.size();
            batchUris.addAll(uris.subList(i, endMarker));
            this.errorManagementDao.close(batchUris, user);
            if (i + this.batchSize < uris.size()) {
                i += this.batchSize;
                continue;
            }
            i = uris.size();
        }
    }

    public List<ErrorOccurrence> find(List<String> moduleName, List<String> flowName, List<String> flowElementname, Date startDate, Date endDate) {
        return new ArrayList<ErrorOccurrence>(this.errorManagementDao.findActionErrorOccurrences(moduleName, flowName, flowElementname, startDate, endDate));
    }

    public void setTimeToLive(Long timeToLive) {
    }

    public void deleteNote(Note note) {
        this.errorManagementDao.deleteNote(note);
    }

    public void updateNote(Note note) {
        this.errorManagementDao.saveNote(note);
    }

    public List<String> getAllErrorUrisWithNote() {
        return this.errorManagementDao.getAllErrorUrisWithNote();
    }

    public List<Note> getNotesByErrorUri(String errorUri) {
        return this.errorManagementDao.getNotesByErrorUri(errorUri);
    }

    public List<ErrorOccurrenceNote> getErrorOccurrenceNotesByErrorUri(String errorUri) {
        return this.errorManagementDao.getErrorOccurrenceNotesByErrorUri(errorUri);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public List<ModuleErrorCount> getModuleErrorCount(List<String> moduleNames, boolean excluded, boolean actioned, Date startDate, Date endDate) {
        ArrayList<ModuleErrorCount> errorCounts = new ArrayList<ModuleErrorCount>();
        for (String moduleName : moduleNames) {
            ModuleErrorCount errorCount = new ModuleErrorCount(moduleName, this.errorManagementDao.getNumberOfModuleErrors(moduleName, excluded, actioned, startDate, endDate));
            errorCounts.add(errorCount);
        }
        return errorCounts;
    }

    public boolean housekeepablesExist() {
        return true;
    }

    public void setHousekeepingBatchSize(Integer housekeepingBatchSize) {
        this.batchSize = housekeepingBatchSize;
    }

    public void setTransactionBatchSize(Integer transactionBatchSize) {
        this.transactionBatchSize = transactionBatchSize;
    }

    public void housekeep() {
        for (int deleted = 0; deleted < this.transactionBatchSize; deleted += this.batchSize) {
            this.errorManagementDao.housekeep(this.batchSize);
        }
    }

    public List<ErrorOccurrence> harvest(int transactionBatchSize) {
        return new ArrayList<ErrorOccurrence>(this.errorManagementDao.getHarvestableRecords(transactionBatchSize));
    }

    public boolean harvestableRecordsExist() {
        return true;
    }

    public void saveHarvestedRecord(ErrorOccurrence harvestedRecord) {
        this.errorManagementDao.saveErrorOccurrence(harvestedRecord);
    }

    public void updateAsHarvested(List<ErrorOccurrence> events) {
        this.errorManagementDao.updateAsHarvested(events);
    }

    public void insert(List<ErrorOccurrence> entities) {
        entities = this.errorOccurrenceConverter.convert(entities);
        this.errorReportingServiceDao.save(entities);
    }
}

