/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.error.reporting.service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.ikasan.error.reporting.model.ErrorOccurrenceImpl;
import org.ikasan.spec.error.reporting.ErrorOccurrence;
import org.ikasan.spec.error.reporting.ErrorReportingService;
import org.ikasan.spec.error.reporting.ErrorReportingServiceDao;
import org.ikasan.spec.flow.FlowEvent;
import org.ikasan.spec.search.PagedSearchResult;
import org.ikasan.spec.serialiser.Serialiser;

public class ErrorReportingServiceDefaultImpl<EVENT>
implements ErrorReportingService<EVENT, ErrorOccurrence> {
    String moduleName;
    String flowName;
    ErrorReportingServiceDao<ErrorOccurrence, String> errorReportingServiceDao;
    Long timeToLive = ErrorReportingService.DEFAULT_TIME_TO_LIVE;
    Serialiser<Object, byte[]> serialiser;

    public ErrorReportingServiceDefaultImpl(String moduleName, String flowName, Serialiser<Object, byte[]> serialiser, ErrorReportingServiceDao<ErrorOccurrence, String> errorReportingServiceDao) {
        this(serialiser, errorReportingServiceDao);
        this.moduleName = moduleName;
        if (moduleName == null) {
            throw new IllegalArgumentException("moduleName cannot be 'null'");
        }
        this.flowName = flowName;
        if (flowName == null) {
            throw new IllegalArgumentException("flowName cannot be 'null'");
        }
    }

    public ErrorReportingServiceDefaultImpl(Serialiser<Object, byte[]> serialiser, ErrorReportingServiceDao<ErrorOccurrence, String> errorReportingServiceDao) {
        this.serialiser = serialiser;
        if (serialiser == null) {
            throw new IllegalArgumentException("serialiser cannot be 'null'");
        }
        this.errorReportingServiceDao = errorReportingServiceDao;
        if (errorReportingServiceDao == null) {
            throw new IllegalArgumentException("errorReportingServiceDao cannot be 'null'");
        }
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public ErrorOccurrence find(String uri) {
        return (ErrorOccurrence)this.errorReportingServiceDao.find((Object)uri);
    }

    public Map<String, ErrorOccurrence> find(List<String> uris) {
        return this.errorReportingServiceDao.find(uris);
    }

    public String notify(String flowElementName, EVENT event, Throwable throwable) {
        return this.notify(flowElementName, event, throwable, null);
    }

    public String notify(String flowElementName, EVENT event, Throwable throwable, String resolvedAction) {
        ErrorOccurrence errorOccurrence = this.newErrorOccurrence(flowElementName, event, throwable);
        errorOccurrence.setAction(resolvedAction);
        this.errorReportingServiceDao.save((Object)errorOccurrence);
        return errorOccurrence.getUri();
    }

    public String notify(String flowElementName, Throwable throwable) {
        return this.notify(flowElementName, throwable, (String)null);
    }

    public String notify(String flowElementName, Throwable throwable, String resolvedAction) {
        ErrorOccurrenceImpl errorOccurrence = this.newErrorOccurrence(flowElementName, throwable);
        errorOccurrence.setAction(resolvedAction);
        this.errorReportingServiceDao.save((Object)errorOccurrence);
        return errorOccurrence.getUri();
    }

    public void setTimeToLive(Long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void housekeep() {
        this.errorReportingServiceDao.deleteExpired();
    }

    private ErrorOccurrence newErrorOccurrence(String flowElementName, EVENT event, Throwable throwable) {
        if (event instanceof FlowEvent) {
            FlowEvent flowEvent = (FlowEvent)event;
            ErrorOccurrenceImpl errorOccurrence = new ErrorOccurrenceImpl(this.moduleName, this.flowName, flowElementName, this.flattenThrowable(throwable), throwable.getMessage(), throwable.getClass().getName(), this.timeToLive, (byte[])this.serialiser.serialise(flowEvent.getPayload()), flowEvent.getPayload().toString());
            errorOccurrence.setEventLifeIdentifier((String)flowEvent.getIdentifier());
            errorOccurrence.setEventRelatedIdentifier((String)flowEvent.getRelatedIdentifier());
            return errorOccurrence;
        }
        return new ErrorOccurrenceImpl(this.moduleName, this.flowName, flowElementName, this.flattenThrowable(throwable), throwable.getMessage(), throwable.getClass().getName(), this.timeToLive, (byte[])this.serialiser.serialise(event), event.toString());
    }

    private ErrorOccurrenceImpl newErrorOccurrence(String flowElementName, Throwable throwable) {
        return new ErrorOccurrenceImpl(this.moduleName, this.flowName, flowElementName, this.flattenThrowable(throwable), throwable.getMessage(), throwable.getClass().getName(), this.timeToLive);
    }

    private String flattenThrowable(Throwable throwable) {
        StringBuffer flattenedBuffer = new StringBuffer();
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            flattenedBuffer.append(cause.toString());
            flattenedBuffer.append("\n");
            for (StackTraceElement stackTraceElement : cause.getStackTrace()) {
                flattenedBuffer.append(stackTraceElement.toString());
                flattenedBuffer.append("\n");
            }
            if (cause.getCause() == null) continue;
            flattenedBuffer.append("caused by ...\n");
        }
        return flattenedBuffer.toString();
    }

    public List<ErrorOccurrence> find(List<String> moduleName, List<String> flowName, List<String> flowElementname, Date startDate, Date endDate, int size) {
        return this.errorReportingServiceDao.find(moduleName, flowName, flowElementname, startDate, endDate, size);
    }

    public PagedSearchResult<ErrorOccurrence> find(int pageNo, int pageSize, String orderBy, boolean orderAscending, String moduleName, String flowName, String componentName, Date fromDate, Date untilDate) {
        return this.errorReportingServiceDao.find(pageNo, pageSize, orderBy, orderAscending, moduleName, flowName, componentName, fromDate, untilDate);
    }

    public Long rowCount(List<String> moduleName, List<String> flowName, List<String> flowElementname, Date startDate, Date endDate) {
        return this.errorReportingServiceDao.rowCount(moduleName, flowName, flowElementname, startDate, endDate);
    }

    public List<ErrorOccurrence> find(List<String> moduleName, List<String> flowName, List<String> flowElementname, Date startDate, Date endDate, String action, String exceptionClass, int size) {
        return this.errorReportingServiceDao.find(moduleName, flowName, flowElementname, startDate, endDate, action, exceptionClass, size);
    }
}

