/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.ikasan.job.orchestration.model.context.ContextTemplateImpl;
import org.ikasan.job.orchestration.model.context.JobLockImpl;
import org.ikasan.job.orchestration.model.instance.ContextInstanceImpl;
import org.ikasan.job.orchestration.model.job.FileEventDrivenJobImpl;
import org.ikasan.job.orchestration.model.job.GlobalEventJobImpl;
import org.ikasan.job.orchestration.model.job.InternalEventDrivenJobImpl;
import org.ikasan.job.orchestration.model.job.QuartzScheduleDrivenJobImpl;
import org.ikasan.job.orchestration.model.job.SchedulerJobImpl;
import org.ikasan.job.orchestration.model.notification.EmailNotificationContextImpl;
import org.ikasan.job.orchestration.model.notification.EmailNotificationDetailsImpl;
import org.ikasan.job.orchestration.model.profile.ContextProfileRecordImpl;
import org.ikasan.job.orchestration.util.ObjectMapperFactory;
import org.ikasan.spec.scheduled.context.model.ContextTemplate;
import org.ikasan.spec.scheduled.context.model.JobLock;
import org.ikasan.spec.scheduled.instance.model.ContextInstance;
import org.ikasan.spec.scheduled.instance.model.SchedulerJobInstance;
import org.ikasan.spec.scheduled.job.model.FileEventDrivenJob;
import org.ikasan.spec.scheduled.job.model.GlobalEventJob;
import org.ikasan.spec.scheduled.job.model.InternalEventDrivenJob;
import org.ikasan.spec.scheduled.job.model.QuartzScheduleDrivenJob;
import org.ikasan.spec.scheduled.job.model.SchedulerJob;
import org.ikasan.spec.scheduled.notification.model.EmailNotificationContext;
import org.ikasan.spec.scheduled.notification.model.EmailNotificationDetails;
import org.ikasan.spec.scheduled.profile.model.ContextProfileRecord;
import org.ikasan.spec.scheduled.status.model.ContextJobInstanceStatusWrapper;
import org.ikasan.spec.scheduled.status.model.ContextMachineStatusWrapper;

public class ContextService {
    private ObjectMapper objectMapper = ObjectMapperFactory.newInstance();

    public boolean isValidJSON(String json) throws JsonProcessingException {
        this.objectMapper.readTree(json);
        return true;
    }

    public ContextTemplate getContextTemplate(String context) throws JsonProcessingException {
        return (ContextTemplate)this.objectMapper.readValue(context, ContextTemplateImpl.class);
    }

    public String getContextTemplateString(ContextTemplate context) throws JsonProcessingException {
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)context);
    }

    public ContextInstance getContextInstance(String context) throws JsonProcessingException {
        return (ContextInstance)this.objectMapper.readValue(context, ContextInstanceImpl.class);
    }

    public String getContextInstanceString(ContextInstance context) throws JsonProcessingException {
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)context);
    }

    public String getContextInstanceString(Map<String, ContextInstance> context) throws JsonProcessingException {
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(context);
    }

    public String getSchedulerJobInstance(SchedulerJobInstance schedulerJobInstance) throws JsonProcessingException {
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)schedulerJobInstance);
    }

    public String getSchedulerJobInstance(Map<String, SchedulerJobInstance> schedulerJobInstance) throws JsonProcessingException {
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(schedulerJobInstance);
    }

    public SchedulerJob getSchedulerJob(String schedulerJob) throws JsonProcessingException {
        return (SchedulerJob)this.objectMapper.readValue(schedulerJob, SchedulerJobImpl.class);
    }

    public JobLock getJobLock(String jobLock) throws JsonProcessingException {
        return (JobLock)this.objectMapper.readValue(jobLock, JobLockImpl.class);
    }

    public String getSchedulerJobString(SchedulerJob schedulerJob) throws JsonProcessingException {
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)schedulerJob);
    }

    public QuartzScheduleDrivenJob getQuartzScheduleDrivenJob(String schedulerJob) throws JsonProcessingException {
        return (QuartzScheduleDrivenJob)this.objectMapper.readValue(schedulerJob, QuartzScheduleDrivenJobImpl.class);
    }

    public String getQuartzScheduleDrivenJobString(QuartzScheduleDrivenJob schedulerJob) throws JsonProcessingException {
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)schedulerJob);
    }

    public FileEventDrivenJob getFileEventDrivenJob(String schedulerJob) throws JsonProcessingException {
        return (FileEventDrivenJob)this.objectMapper.readValue(schedulerJob, FileEventDrivenJobImpl.class);
    }

    public String getFileEventDrivenJobString(FileEventDrivenJob schedulerJob) throws JsonProcessingException {
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)schedulerJob);
    }

    public InternalEventDrivenJob getInternalEventDrivenJob(String schedulerJob) throws JsonProcessingException {
        return (InternalEventDrivenJob)this.objectMapper.readValue(schedulerJob, InternalEventDrivenJobImpl.class);
    }

    public String getInternalEventDrivenJobString(InternalEventDrivenJob schedulerJob) throws JsonProcessingException {
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)schedulerJob);
    }

    public GlobalEventJob getGlobalEventJob(String schedulerJob) throws JsonProcessingException {
        return (GlobalEventJob)this.objectMapper.readValue(schedulerJob, GlobalEventJobImpl.class);
    }

    public String getGlobalEventJobString(GlobalEventJob schedulerJob) throws JsonProcessingException {
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)schedulerJob);
    }

    public ContextProfileRecord getContextProfileRecord(String contextProfileRecord) throws JsonProcessingException {
        return (ContextProfileRecord)this.objectMapper.readValue(contextProfileRecord, ContextProfileRecordImpl.class);
    }

    public EmailNotificationDetails getEmailNotificationDetails(String emailNotificationDetails) throws JsonProcessingException {
        return (EmailNotificationDetails)this.objectMapper.readValue(emailNotificationDetails, EmailNotificationDetailsImpl.class);
    }

    public EmailNotificationContext getEmailNotificationContext(String emailNotificationContext) throws JsonProcessingException {
        return (EmailNotificationContext)this.objectMapper.readValue(emailNotificationContext, EmailNotificationContextImpl.class);
    }

    public String getContextJobInstanceStatus(ContextJobInstanceStatusWrapper contextJobInstanceStatusWrapper) throws JsonProcessingException {
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)contextJobInstanceStatusWrapper);
    }

    public String getContextMachineStatus(ContextMachineStatusWrapper contextMachineStatusWrapper) throws JsonProcessingException {
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)contextMachineStatusWrapper);
    }

    public ContextTemplate getParent(ContextTemplate context, ContextTemplate currentContext) {
        AtomicReference parent = new AtomicReference();
        if (context.getContexts() != null) {
            context.getContexts().forEach(c -> {
                if (c.getName().equals(currentContext.getName())) {
                    parent.set(context);
                }
            });
            if (parent.get() != null) {
                return (ContextTemplate)parent.get();
            }
            context.getContexts().forEach(c -> {
                ContextTemplate parentContext = this.getParent((ContextTemplate)c, currentContext);
                if (parentContext != null) {
                    parent.set(parentContext);
                }
            });
        }
        return (ContextTemplate)parent.get();
    }

    public ContextInstance getParent(ContextInstance context, ContextInstance currentContext) {
        AtomicReference parent = new AtomicReference();
        if (context.getContexts() != null) {
            context.getContexts().forEach(c -> {
                if (c.getName().equals(currentContext.getName())) {
                    parent.set(context);
                }
            });
            if (parent.get() != null) {
                return (ContextInstance)parent.get();
            }
            context.getContexts().forEach(c -> {
                ContextInstance parentContext = this.getParent((ContextInstance)c, currentContext);
                if (parentContext != null) {
                    parent.set(parentContext);
                }
            });
        }
        return (ContextInstance)parent.get();
    }
}

