/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.job.orchestration.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;
import org.ikasan.job.orchestration.model.context.ContextBundleImpl;
import org.ikasan.job.orchestration.service.ContextService;
import org.ikasan.job.orchestration.util.ContextHelper;
import org.ikasan.spec.scheduled.context.model.Context;
import org.ikasan.spec.scheduled.context.model.ContextBundle;
import org.ikasan.spec.scheduled.context.model.ContextTemplate;
import org.ikasan.spec.scheduled.job.model.SchedulerJob;
import org.ikasan.spec.scheduled.notification.model.EmailNotificationContext;
import org.ikasan.spec.scheduled.notification.model.EmailNotificationDetails;
import org.ikasan.spec.scheduled.profile.model.ContextProfileRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContextImportZipUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ContextImportZipUtils.class);
    public static final String[] UNSAFE_FILENAME_CHAR = new String[]{"\\", ":", "/", "*", "?", "\"", "<", ">", "|"};
    public static final String[] REPLACE_UNSAFE_FILENAME_CHAR = new String[]{"_", "_", "_", "_", "_", "_", "_", "_", "_"};

    public static ContextBundle extractZipFile(InputStream inputStream) {
        ArrayList<SchedulerJob> contextJobs = new ArrayList<SchedulerJob>();
        ArrayList<ContextProfileRecord> contextProfileRecords = new ArrayList<ContextProfileRecord>();
        ArrayList<EmailNotificationDetails> emailNotificationDetails = new ArrayList<EmailNotificationDetails>();
        AtomicReference emailNotificationContexts = new AtomicReference();
        AtomicReference atomicContextTemplate = new AtomicReference();
        ConcurrentHashMap<String, List<ContextTemplate>> dirToTemplates = new ConcurrentHashMap<String, List<ContextTemplate>>();
        try {
            ContextService contextService = new ContextService();
            AtomicReference parentDirectory = new AtomicReference();
            ContextImportZipUtils.readZipInputStream(inputStream, (entry, outputStream) -> {
                if (parentDirectory.get() == null) {
                    parentDirectory.set(entry.getName());
                }
                String contextDirectory = parentDirectory + "context/";
                String fileJobsDirectory = parentDirectory + "jobs/file/";
                String internalJobsDirectory = parentDirectory + "jobs/internal/";
                String quartzJobsDirectory = parentDirectory + "jobs/quartz/";
                String globalJobsDirectory = parentDirectory + "jobs/global/";
                String contextProfileDirectory = parentDirectory + "profiles/";
                String emailNotificationDirectory = parentDirectory + "notification/";
                String emailNotificationDetailDirectory = parentDirectory + "notification_details/";
                if (!entry.isDirectory() && entry.getName().startsWith(contextDirectory) && entry.getName().endsWith(".json")) {
                    String directory = ContextImportZipUtils.getLeafDirectoryFromPath(entry.getName());
                    atomicContextTemplate.set((ContextTemplate)ContextImportZipUtils.getContextArtifact("contextTemplate", outputStream.toString(), contextService));
                    dirToTemplates.computeIfAbsent(directory, x -> new CopyOnWriteArrayList()).add((ContextTemplate)ContextImportZipUtils.getContextArtifact("contextTemplate", outputStream.toString(), contextService));
                } else if (!entry.isDirectory() && entry.getName().startsWith(fileJobsDirectory) && entry.getName().endsWith(".json")) {
                    contextJobs.add((SchedulerJob)ContextImportZipUtils.getContextArtifact("file", outputStream.toString(), contextService));
                } else if (!entry.isDirectory() && entry.getName().startsWith(internalJobsDirectory) && entry.getName().endsWith(".json")) {
                    contextJobs.add((SchedulerJob)ContextImportZipUtils.getContextArtifact("internal", outputStream.toString(), contextService));
                } else if (!entry.isDirectory() && entry.getName().startsWith(quartzJobsDirectory) && entry.getName().endsWith(".json")) {
                    contextJobs.add((SchedulerJob)ContextImportZipUtils.getContextArtifact("quartz", outputStream.toString(), contextService));
                } else if (!entry.isDirectory() && entry.getName().startsWith(globalJobsDirectory) && entry.getName().endsWith(".json")) {
                    contextJobs.add((SchedulerJob)ContextImportZipUtils.getContextArtifact("global", outputStream.toString(), contextService));
                } else if (!entry.isDirectory() && entry.getName().startsWith(contextProfileDirectory) && entry.getName().endsWith(".json")) {
                    contextProfileRecords.add((ContextProfileRecord)ContextImportZipUtils.getContextArtifact("profiles", outputStream.toString(), contextService));
                } else if (!entry.isDirectory() && entry.getName().startsWith(emailNotificationDirectory) && entry.getName().endsWith(".json")) {
                    emailNotificationContexts.set((EmailNotificationContext)ContextImportZipUtils.getContextArtifact("notification", outputStream.toString(), contextService));
                } else if (!entry.isDirectory() && entry.getName().startsWith(emailNotificationDetailDirectory) && entry.getName().endsWith(".json")) {
                    emailNotificationDetails.add((EmailNotificationDetails)ContextImportZipUtils.getContextArtifact("notification_details", outputStream.toString(), contextService));
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Could not read zip file, Error: " + e.getMessage());
            throw new RuntimeException(e);
        }
        ContextTemplate contextTemplate = (ContextTemplate)((List)dirToTemplates.get("context")).get(0);
        ContextImportZipUtils.rebuildSubContexts(contextTemplate, dirToTemplates);
        return new ContextBundleImpl(contextTemplate, contextJobs, contextProfileRecords, emailNotificationDetails, (EmailNotificationContext)emailNotificationContexts.get());
    }

    protected static String getLeafDirectoryFromPath(String path) {
        String[] splitPath = path.split("/");
        return splitPath[splitPath.length - 2];
    }

    protected static void rebuildSubContexts(ContextTemplate currentRoot, Map<String, List<ContextTemplate>> dirToTemplates) {
        List<ContextTemplate> dirContexts = dirToTemplates.get(ContextImportZipUtils.sanitiseForUseAsFilename(currentRoot.getName()));
        if (dirContexts != null) {
            List sortedDirContexts = dirContexts.stream().sorted(Comparator.comparingInt(Context::getOrdinal)).collect(Collectors.toList());
            currentRoot.setContexts(sortedDirContexts);
            for (ContextTemplate subContext : dirContexts) {
                ContextImportZipUtils.rebuildSubContexts(subContext, dirToTemplates);
            }
        }
    }

    private static void readZipInputStream(InputStream inputStream, BiConsumer<ZipEntry, ByteArrayOutputStream> biConsumer) {
        try {
            ZipEntry entry;
            ZipInputStream zipInput = new ZipInputStream(inputStream);
            while ((entry = zipInput.getNextEntry()) != null) {
                int length;
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((length = zipInput.read(buffer)) != -1) {
                    outStream.write(buffer, 0, length);
                }
                biConsumer.accept(entry, outStream);
            }
        }
        catch (Exception e) {
            LOG.warn("Could not read zip input stream, Error: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static Object getContextArtifact(String type, String json, ContextService service) {
        try {
            switch (type) {
                case "contextTemplate": {
                    return service.getContextTemplate(json);
                }
                case "file": {
                    return service.getFileEventDrivenJob(json);
                }
                case "internal": {
                    return service.getInternalEventDrivenJob(json);
                }
                case "quartz": {
                    return service.getQuartzScheduleDrivenJob(json);
                }
                case "global": {
                    return service.getGlobalEventJob(json);
                }
                case "profiles": {
                    return service.getContextProfileRecord(json);
                }
                case "notification": {
                    return service.getEmailNotificationContext(json);
                }
                case "notification_details": {
                    return service.getEmailNotificationDetails(json);
                }
            }
            throw new RuntimeException("Unknown job type: " + type);
        }
        catch (JsonProcessingException e) {
            LOG.warn(String.format("Could not read json for job type %s, Error: %s", type, e.getMessage()));
            throw new RuntimeException(e);
        }
    }

    public static String sanitiseForUseAsFilename(String toBeSanitised) {
        return StringUtils.replaceEach((String)toBeSanitised, (String[])UNSAFE_FILENAME_CHAR, (String[])REPLACE_UNSAFE_FILENAME_CHAR).replace("_" + ContextHelper.ENV_NAME_REPLACEMENT, "");
    }
}

