/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.component.endpoint.mongo.test;

import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.ArtifactStoreBuilder;
import de.flapdoodle.embed.mongo.config.DownloadConfigBuilder;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.RuntimeConfigBuilder;
import de.flapdoodle.embed.mongo.config.Storage;
import de.flapdoodle.embed.mongo.distribution.Feature;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.mongo.distribution.Versions;
import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.distribution.GenericVersion;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.ikasan.component.endpoint.mongo.test.EmbeddedMongoConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedMongo {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedMongo.class);
    private MongodExecutable mongodExecutable;
    private static EmbeddedMongo staticReference;
    private MongoClient mongoClient;
    private final EmbeddedMongoConfiguration configuration;

    @Deprecated
    public EmbeddedMongo(int port) {
        this.configuration = new EmbeddedMongoConfiguration();
        this.configuration.setPort(port);
        this.overrideConfigurationWithSystemProperties();
    }

    public EmbeddedMongo() {
        this.configuration = new EmbeddedMongoConfiguration();
        this.overrideConfigurationWithSystemProperties();
    }

    public EmbeddedMongo(EmbeddedMongoConfiguration configuration) {
        this.configuration = configuration;
        this.overrideConfigurationWithSystemProperties();
    }

    private void overrideConfigurationWithSystemProperties() {
        String sysCustomMongoDatabaseDir = System.getProperty("ikasan.flapdoodle.customMongoDatabaseDir");
        String sysLocalMongoDistDir = System.getProperty("ikasan.localMongoDistDirProperty");
        String sysCustomMongoVersion = System.getProperty("ikasan.flapdoodle.customMongoVersion");
        String sysCustomMongoArchiveStorageDir = System.getProperty("ikasan.flapdoodle.customMongoArchiveStorageDir");
        String sysCustomMongoPort = System.getProperty("ikasan.flapdoodle.customMongoPort");
        if (sysCustomMongoDatabaseDir != null) {
            this.configuration.setDatabaseDirectory(sysCustomMongoDatabaseDir);
        }
        if (sysLocalMongoDistDir != null) {
            this.configuration.setDistributionDirectory(sysLocalMongoDistDir);
        }
        if (sysCustomMongoVersion != null) {
            this.configuration.setVersion(sysCustomMongoVersion);
        }
        if (sysCustomMongoArchiveStorageDir != null) {
            this.configuration.setArchiveStorageDirectory(sysCustomMongoArchiveStorageDir);
        }
        if (sysCustomMongoPort != null) {
            this.configuration.setPort(new Integer(sysCustomMongoPort));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MongoClient start() {
        Class<EmbeddedMongo> clazz = EmbeddedMongo.class;
        synchronized (EmbeddedMongo.class) {
            if (staticReference == null) {
                Command command = Command.MongoD;
                MongodStarter runtime = null;
                DownloadConfigBuilder downloadConfigBuilder = this.setupDownloadConfigBuilder(command);
                IRuntimeConfig runtimeConfig = new RuntimeConfigBuilder().defaults(command).artifactStore((AbstractBuilder)new ArtifactStoreBuilder().defaults(command).download(downloadConfigBuilder.build())).build();
                runtime = MongodStarter.getInstance((IRuntimeConfig)runtimeConfig);
                try {
                    MongodConfigBuilder mongodConfigBuilder = this.setupMongodConfigBuilder();
                    this.mongodExecutable = (MongodExecutable)runtime.prepare((IExecutableProcessConfig)mongodConfigBuilder.build());
                    MongodProcess mongodProcess = (MongodProcess)this.mongodExecutable.start();
                    staticReference = this;
                    this.mongoClient = new MongoClient(new ServerAddress(((IMongodConfig)mongodProcess.getConfig()).net().getServerAddress(), ((IMongodConfig)mongodProcess.getConfig()).net().getPort()));
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to start embeddedMongo", e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return EmbeddedMongo.staticReference.mongoClient;
        }
    }

    private MongodConfigBuilder setupMongodConfigBuilder() throws UnknownHostException, IOException {
        MongodConfigBuilder builder = new MongodConfigBuilder();
        builder = this.configuration.getPort() != null ? builder.net(new Net(this.configuration.getPort().intValue(), Network.localhostIsIPv6())) : builder.net(new Net());
        String customMongoDatabaseDirectory = this.configuration.getDatabaseDirectory();
        String customMongoVersion = this.configuration.getVersion();
        if (customMongoDatabaseDirectory != null) {
            logger.info("Custom mongo database dir set to [{}]", (Object)customMongoDatabaseDirectory);
            builder.replication(new Storage(customMongoDatabaseDirectory, null, 0));
        }
        if (customMongoVersion != null) {
            logger.info("Custom mongo version set to [{}]", (Object)customMongoVersion);
            builder.version(Versions.withFeatures((IVersion)new GenericVersion(customMongoVersion), (Feature[])new Feature[]{Feature.SYNC_DELAY}));
        } else {
            builder.version((IFeatureAwareVersion)Version.Main.PRODUCTION);
        }
        return builder;
    }

    private DownloadConfigBuilder setupDownloadConfigBuilder(Command command) {
        DownloadConfigBuilder builder = new DownloadConfigBuilder();
        builder = builder.defaultsForCommand(command);
        String localMongoDistDir = this.configuration.getDistributionDirectory();
        String customMongoArchiveDownloadDirectory = this.configuration.getArchiveStorageDirectory();
        if (localMongoDistDir != null) {
            logger.info("Custom local mongo dist dir set to [{}]", (Object)localMongoDistDir);
            builder.downloadPath(this.getLocalMongoDistributionPath(localMongoDistDir));
        }
        if (customMongoArchiveDownloadDirectory != null) {
            logger.info("Custom mongo artifact storage dir set to [{}]", (Object)customMongoArchiveDownloadDirectory);
            builder.artifactStorePath(this.getIDirectory(customMongoArchiveDownloadDirectory));
        }
        return builder;
    }

    private IDirectory getIDirectory(final String customMongoArchiveDownloadDirectory) {
        return new IDirectory(){

            public File asFile() {
                return new File(customMongoArchiveDownloadDirectory);
            }

            public boolean isGenerated() {
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        Class<EmbeddedMongo> clazz = EmbeddedMongo.class;
        synchronized (EmbeddedMongo.class) {
            if (staticReference != null) {
                EmbeddedMongo.staticReference.mongodExecutable.stop();
                staticReference = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private String getLocalMongoDistributionPath(String mongoDistributionDirectory) {
        URL resource = null;
        try {
            resource = new File(mongoDistributionDirectory).toURI().toURL();
        }
        catch (MalformedURLException e) {
            logger.error("Could not get local mongo distribution path", (Throwable)e);
        }
        return resource.toString();
    }

    public EmbeddedMongoConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getMongoDistributionDirectory() {
        return this.configuration.getDistributionDirectory();
    }
}

