/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.security.service.authentication;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Set;
import org.ikasan.security.model.IkasanPrincipal;
import org.ikasan.security.model.Policy;
import org.ikasan.security.model.Role;
import org.ikasan.security.model.User;
import org.ikasan.security.service.SecurityService;
import org.ikasan.security.service.UserService;
import org.ikasan.security.service.authentication.IkasanAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticator;

public class LdapLocalAuthenticationProvider
implements AuthenticationProvider {
    private static Logger logger = LoggerFactory.getLogger(LdapLocalAuthenticationProvider.class);
    private LdapAuthenticator authenticator;
    private SecurityService securityService;
    private UserService userService;

    public LdapLocalAuthenticationProvider(BindAuthenticator authenticator, SecurityService securityService, UserService userService) {
        this.authenticator = authenticator;
        if (this.authenticator == null) {
            throw new IllegalArgumentException("authenticator cannot be null!");
        }
        this.securityService = securityService;
        if (this.securityService == null) {
            throw new IllegalArgumentException("securityService cannot be null!");
        }
        this.userService = userService;
        if (this.userService == null) {
            throw new IllegalArgumentException("userService cannot be null!");
        }
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        DirContextOperations authAdapter = this.authenticator.authenticate(authentication);
        User user = this.userService.loadUserByUsername(authentication.getName());
        Set principals = user.getPrincipals();
        ArrayList<Policy> authorities = new ArrayList<Policy>();
        for (IkasanPrincipal principal : principals) {
            Set roles = principal.getRoles();
            for (Role role : roles) {
                Set policies = role.getPolicies();
                for (Policy policy : policies) {
                    if (authorities.contains(policy)) continue;
                    authorities.add(policy);
                }
            }
        }
        IkasanAuthentication ikasanAuthentication = new IkasanAuthentication(true, (Principal)user, authorities, (String)authentication.getCredentials(), user.getPreviousAccessTimestamp());
        return ikasanAuthentication;
    }

    public boolean supports(Class<?> clazz) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(clazz);
    }
}

