/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.security.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.ikasan.security.dao.SecurityDao;
import org.ikasan.security.model.AuthenticationMethod;
import org.ikasan.security.model.IkasanPrincipal;
import org.ikasan.security.model.Policy;
import org.ikasan.security.model.PolicyLink;
import org.ikasan.security.model.PolicyLinkType;
import org.ikasan.security.model.Role;
import org.ikasan.security.model.User;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.orm.hibernate4.HibernateCallback;
import org.springframework.orm.hibernate4.support.HibernateDaoSupport;

public class HibernateSecurityDao
extends HibernateDaoSupport
implements SecurityDao {
    @Override
    public void saveOrUpdateRole(Role role) {
        role.setUpdatedDateTime(new Date());
        this.getHibernateTemplate().saveOrUpdate((Object)role);
    }

    @Override
    public void saveOrUpdatePolicy(Policy policy) {
        policy.setUpdatedDateTime(new Date());
        this.getHibernateTemplate().saveOrUpdate((Object)policy);
    }

    @Override
    public void saveOrUpdatePrincipal(IkasanPrincipal principal) {
        principal.setUpdatedDateTime(new Date());
        this.getHibernateTemplate().saveOrUpdate((Object)principal);
    }

    @Override
    public IkasanPrincipal getPrincipalByName(String name) {
        DetachedCriteria criteria = DetachedCriteria.forClass(IkasanPrincipal.class);
        criteria.add((Criterion)Restrictions.eq((String)"name", (Object)name));
        IkasanPrincipal principal = (IkasanPrincipal)DataAccessUtils.uniqueResult((Collection)this.getHibernateTemplate().findByCriteria(criteria));
        return principal;
    }

    @Override
    public List<Policy> getAllPolicies() {
        DetachedCriteria criteria = DetachedCriteria.forClass(Policy.class);
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public List<Role> getAllRoles() {
        DetachedCriteria criteria = DetachedCriteria.forClass(Role.class);
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public List<IkasanPrincipal> getAllPrincipals() {
        DetachedCriteria criteria = DetachedCriteria.forClass(IkasanPrincipal.class);
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public Policy getPolicyByName(String name) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Policy.class);
        criteria.add((Criterion)Restrictions.eq((String)"name", (Object)name));
        Policy policy = (Policy)DataAccessUtils.uniqueResult((Collection)this.getHibernateTemplate().findByCriteria(criteria));
        return policy;
    }

    @Override
    public Role getRoleByName(String name) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Role.class);
        criteria.add((Criterion)Restrictions.eq((String)"name", (Object)name));
        Role role = (Role)DataAccessUtils.uniqueResult((Collection)this.getHibernateTemplate().findByCriteria(criteria));
        return role;
    }

    @Override
    public void deleteRole(Role role) {
        this.getHibernateTemplate().delete((Object)role);
    }

    @Override
    public void deletePolicy(Policy policy) {
        this.getHibernateTemplate().delete((Object)policy);
    }

    @Override
    public void deletePrincipal(IkasanPrincipal principal) {
        this.getHibernateTemplate().delete((Object)principal);
    }

    @Override
    public void saveOrUpdateAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.getHibernateTemplate().saveOrUpdate((Object)authenticationMethod);
    }

    @Override
    public AuthenticationMethod getAuthenticationMethod(Long id) {
        DetachedCriteria criteria = DetachedCriteria.forClass(AuthenticationMethod.class);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)id));
        AuthenticationMethod authenticationMethod = (AuthenticationMethod)DataAccessUtils.uniqueResult((Collection)this.getHibernateTemplate().findByCriteria(criteria));
        return authenticationMethod;
    }

    @Override
    public List<AuthenticationMethod> getAuthenticationMethods() {
        DetachedCriteria criteria = DetachedCriteria.forClass(AuthenticationMethod.class);
        criteria.addOrder(Order.asc((String)"order"));
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public List<IkasanPrincipal> getAllPrincipalsWithRole(String roleName) {
        DetachedCriteria criteria = DetachedCriteria.forClass(IkasanPrincipal.class);
        criteria.createCriteria("roles").add((Criterion)Restrictions.eq((String)"name", (Object)roleName));
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public List<IkasanPrincipal> getPrincipalsByRoleNames(List<String> names) {
        DetachedCriteria criteria = DetachedCriteria.forClass(IkasanPrincipal.class);
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        criteria.createCriteria("roles").add(Restrictions.in((String)"name", names));
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public List<IkasanPrincipal> getPrincipalByNameLike(String name) {
        List results = this.getHibernateTemplate().findByNamedParam("from IkasanPrincipal where name LIKE :name", "name", (Object)(name + '%'));
        return results;
    }

    @Override
    public List<PolicyLinkType> getAllPolicyLinkTypes() {
        DetachedCriteria criteria = DetachedCriteria.forClass(PolicyLinkType.class);
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public List<Policy> getPolicyByNameLike(String name) {
        List results = this.getHibernateTemplate().findByNamedParam("from Policy where name LIKE :name", "name", (Object)(name + '%'));
        return results;
    }

    @Override
    public List<Role> getRoleByNameLike(String name) {
        List results = this.getHibernateTemplate().findByNamedParam("from Role where name LIKE :name", "name", (Object)(name + '%'));
        return results;
    }

    @Override
    public void saveOrUpdatePolicyLink(PolicyLink policyLink) {
        this.getHibernateTemplate().saveOrUpdate((Object)policyLink);
    }

    @Override
    public void saveOrUpdatePolicyLinkType(PolicyLinkType policyLinkType) {
        this.getHibernateTemplate().saveOrUpdate((Object)policyLinkType);
    }

    @Override
    public void deletePolicyLink(PolicyLink policyLink) {
        this.getHibernateTemplate().delete((Object)policyLink);
    }

    @Override
    public List<Policy> getAllPoliciesWithRole(String roleName) {
        DetachedCriteria criteria = DetachedCriteria.forClass(Policy.class);
        criteria.createCriteria("roles").add((Criterion)Restrictions.eq((String)"name", (Object)roleName));
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public void deleteAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.getHibernateTemplate().delete((Object)authenticationMethod);
    }

    @Override
    public long getNumberOfAuthenticationMethods() {
        return (Long)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery("select count(*) from AuthenticationMethod");
                return (Long)query.uniqueResult();
            }
        });
    }

    @Override
    public AuthenticationMethod getAuthenticationMethodByOrder(long order) {
        DetachedCriteria criteria = DetachedCriteria.forClass(AuthenticationMethod.class);
        criteria.add((Criterion)Restrictions.eq((String)"order", (Object)order));
        AuthenticationMethod authenticationMethod = (AuthenticationMethod)DataAccessUtils.uniqueResult((Collection)this.getHibernateTemplate().findByCriteria(criteria));
        return authenticationMethod;
    }

    @Override
    public List<User> getUsersAssociatedWithPrincipal(final long principalId) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery("select u from UserPrincipal as up, User as u  where  u.id = up.userId and up.ikasanPrincipalId = :principalId");
                query.setParameter("principalId", (Object)principalId);
                return query.list();
            }
        });
    }
}

