/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.security.model;

import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.ikasan.security.model.Authority;
import org.ikasan.security.model.IkasanPrincipal;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class User
implements UserDetails,
Principal {
    private static final long serialVersionUID = 8975017088981341914L;
    private Long id;
    private String username;
    private String password;
    private String email;
    private String firstName;
    private String surname;
    private String department;
    private boolean enabled;
    private Set<Authority> grantedAuthorities = new HashSet<Authority>();
    private Set<IkasanPrincipal> principals;
    private long previousAccessTimestamp;

    public User(String username, String password, String email, boolean enabled) {
        this.username = username;
        this.password = password;
        this.email = email;
        this.enabled = enabled;
    }

    private User() {
    }

    private Set<Authority> getGrantedAuthorities() {
        return this.grantedAuthorities;
    }

    public void setGrantedAuthorities(Set<Authority> grantedAuthorities) {
        this.grantedAuthorities = grantedAuthorities;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.grantedAuthorities;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getName() {
        return this.username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void grantAuthority(Authority authority) {
        if (this.grantedAuthorities.contains(authority)) {
            throw new IllegalArgumentException("Authority [" + authority + "] is already granted to user [" + this + "]");
        }
        this.grantedAuthorities.add(authority);
    }

    public void revokeAuthority(Authority authority) {
        if (!this.grantedAuthorities.contains(authority)) {
            throw new IllegalArgumentException("Authority [" + authority + "] has not been granted to user [" + this + "]");
        }
        this.grantedAuthorities.remove(authority);
    }

    public Long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public Set<IkasanPrincipal> getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(Set<IkasanPrincipal> principals) {
        this.principals = principals;
    }

    public long getPreviousAccessTimestamp() {
        return this.previousAccessTimestamp;
    }

    public void setPreviousAccessTimestamp(long previousAccessTimestamp) {
        this.previousAccessTimestamp = previousAccessTimestamp;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.department == null ? 0 : this.department.hashCode());
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + (this.firstName == null ? 0 : this.firstName.hashCode());
        result = 31 * result + (this.grantedAuthorities == null ? 0 : this.grantedAuthorities.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.principals == null ? 0 : this.principals.hashCode());
        result = 31 * result + (this.surname == null ? 0 : this.surname.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        if (this.department == null ? other.department != null : !this.department.equals(other.department)) {
            return false;
        }
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.firstName == null ? other.firstName != null : !this.firstName.equals(other.firstName)) {
            return false;
        }
        if (this.grantedAuthorities == null ? other.grantedAuthorities != null : !this.grantedAuthorities.equals(other.grantedAuthorities)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.principals == null ? other.principals != null : !this.principals.equals(other.principals)) {
            return false;
        }
        if (this.surname == null ? other.surname != null : !this.surname.equals(other.surname)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    @Override
    public String toString() {
        return this.username;
    }
}

