/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.security.service.authentication;

import java.security.Principal;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.ikasan.security.model.Policy;
import org.ikasan.security.model.PolicyLink;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class IkasanAuthentication
implements Authentication {
    private Logger logger = Logger.getLogger(IkasanAuthentication.class);
    private boolean isAuthenticated;
    private List<GrantedAuthority> authorities;
    private Principal principal;
    private String credentials;
    private long previousLoginTimestamp;

    public IkasanAuthentication(boolean isAuthenticated, Principal principal, List<GrantedAuthority> authorities, String credentials, long previousLoginTimestamp) {
        this.isAuthenticated = isAuthenticated;
        this.authorities = authorities;
        this.principal = principal;
        this.credentials = credentials;
        this.previousLoginTimestamp = previousLoginTimestamp;
    }

    public String getName() {
        return this.principal.getName();
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public Object getDetails() {
        throw new UnsupportedOperationException();
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        this.isAuthenticated = isAuthenticated;
    }

    public long getPreviousLoginTimestamp() {
        return this.previousLoginTimestamp;
    }

    public void setPreviousLoginTimestamp(long previousLoginTimestamp) {
        this.previousLoginTimestamp = previousLoginTimestamp;
    }

    public boolean hasGrantedAuthority(String authorityName) {
        for (GrantedAuthority grantedAuthority : this.getAuthorities()) {
            if (!grantedAuthority.getAuthority().equals(authorityName)) continue;
            return true;
        }
        return false;
    }

    public boolean canAccessLinkedItem(String linkedItemType, Long linkedItemId) {
        for (GrantedAuthority grantedAuthority : this.getAuthorities()) {
            this.logger.debug((Object)("Policy: " + (Policy)grantedAuthority));
            PolicyLink policyLink = ((Policy)grantedAuthority).getPolicyLink();
            this.logger.debug((Object)("PolicyLink: " + policyLink));
            if (policyLink == null || !policyLink.getPolicyLinkType().getName().equals(linkedItemType) || !policyLink.getTargetId().equals(linkedItemId)) continue;
            return true;
        }
        return false;
    }
}

