/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.security.service.authentication;

import java.util.ArrayList;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ikasan.security.model.IkasanPrincipal;
import org.ikasan.security.model.Policy;
import org.ikasan.security.model.Role;
import org.ikasan.security.model.User;
import org.ikasan.security.service.SecurityService;
import org.ikasan.security.service.UserService;
import org.ikasan.security.service.authentication.IkasanAuthentication;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticator;

public class LdapAuthenticationProvider
implements AuthenticationProvider {
    private static Logger logger = Logger.getLogger(LdapAuthenticationProvider.class);
    private LdapAuthenticator authenticator;
    private SecurityService securityService;
    private UserService userService;

    public LdapAuthenticationProvider(BindAuthenticator authenticator, SecurityService securityService, UserService userService) {
        this.authenticator = authenticator;
        if (this.authenticator == null) {
            throw new IllegalArgumentException("authenticator cannot be null!");
        }
        this.securityService = securityService;
        if (this.securityService == null) {
            throw new IllegalArgumentException("securityService cannot be null!");
        }
        this.userService = userService;
        if (this.userService == null) {
            throw new IllegalArgumentException("userService cannot be null!");
        }
    }

    public LdapAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(LdapAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public boolean supports(Class<?> clazz) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(clazz);
    }

    public Authentication authenticate(Authentication auth) {
        DirContextOperations authAdapter = this.authenticator.authenticate(auth);
        User user = this.userService.loadUserByUsername(auth.getName());
        Set<IkasanPrincipal> principals = user.getPrincipals();
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        for (IkasanPrincipal principal : principals) {
            Set<Role> roles = principal.getRoles();
            for (Role role : roles) {
                Set<Policy> policies = role.getPolicies();
                for (Policy policy : policies) {
                    if (authorities.contains(policy)) continue;
                    authorities.add(policy);
                }
            }
        }
        IkasanAuthentication ikasanAuthentication = new IkasanAuthentication(true, user, authorities, (String)auth.getCredentials(), user.getPreviousAccessTimestamp());
        logger.debug((Object)("Returning authentication: " + ikasanAuthentication));
        return ikasanAuthentication;
    }
}

