/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.security.service.authentication;

import java.util.ArrayList;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ikasan.security.model.IkasanPrincipal;
import org.ikasan.security.model.Policy;
import org.ikasan.security.model.Role;
import org.ikasan.security.model.User;
import org.ikasan.security.service.SecurityService;
import org.ikasan.security.service.UserService;
import org.ikasan.security.service.authentication.IkasanAuthentication;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.encoding.ShaPasswordEncoder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;

public class LocalAuthenticationProvider
implements AuthenticationProvider {
    private static Logger logger = Logger.getLogger(LocalAuthenticationProvider.class);
    private SecurityService securityService;
    private UserService userService;

    public LocalAuthenticationProvider(SecurityService securityService, UserService userService) {
        this.securityService = securityService;
        if (this.securityService == null) {
            throw new IllegalArgumentException("securityService cannot be null!");
        }
        this.userService = userService;
        if (this.userService == null) {
            throw new IllegalArgumentException("userService cannot be null!");
        }
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String userName = ((UsernamePasswordAuthenticationToken)authentication).getName();
        String password = (String)((UsernamePasswordAuthenticationToken)authentication).getCredentials();
        ShaPasswordEncoder encoder = new ShaPasswordEncoder();
        String shaPassword = encoder.encodePassword(password, null);
        User user = this.userService.loadUserByUsername(userName);
        if (user.getPassword().equals(shaPassword)) {
            Set<IkasanPrincipal> principals = user.getPrincipals();
            ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
            for (IkasanPrincipal principal : principals) {
                Set<Role> roles = principal.getRoles();
                for (Role role : roles) {
                    Set<Policy> policies = role.getPolicies();
                    for (Policy policy : policies) {
                        if (authorities.contains(policy)) continue;
                        authorities.add(policy);
                    }
                }
            }
            IkasanAuthentication ikasanAuthentication = new IkasanAuthentication(true, user, authorities, (String)authentication.getCredentials(), user.getPreviousAccessTimestamp());
            return ikasanAuthentication;
        }
        return null;
    }

    public boolean supports(Class<?> clazz) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(clazz);
    }
}

