/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.security.util;

import org.apache.log4j.Logger;
import org.ikasan.security.dao.UserDao;
import org.ikasan.security.model.Authority;
import org.ikasan.security.model.User;
import org.ikasan.security.service.UserService;
import org.springframework.beans.factory.InitializingBean;

public class InitialisePermission
implements InitializingBean {
    private Logger logger = Logger.getLogger(InitialisePermission.class);
    private static String ROLE_USER = "ROLE_USER";
    private static String ROLE_USER_DESC = "Users who may log into the system";
    private static String ROLE_ADMIN = "ROLE_ADMIN";
    private static String ROLE_ADMIN_DESC = "Users who may perform administration functions on the system";
    private static Authority ADMIN_AUTHORITY = new Authority(ROLE_ADMIN, ROLE_ADMIN_DESC);
    private static Authority USER_AUTHORITY = new Authority(ROLE_USER, ROLE_USER_DESC);
    private UserService userService;
    private String moduleName;
    private UserDao userDao;
    private User rootAdminUser;
    private User moduleAdminUser;

    public InitialisePermission(UserService userService, String moduleName, UserDao userDao) {
        this.userService = userService;
        if (userService == null) {
            throw new IllegalArgumentException("userService cannot be 'null'");
        }
        this.userDao = userDao;
        if (userDao == null) {
            throw new IllegalArgumentException("userDao cannot be 'null'");
        }
        this.moduleName = moduleName;
        if (moduleName == null) {
            throw new IllegalArgumentException("moduleName cannot be 'null'");
        }
    }

    protected void createAuthority(Authority authority) {
        if (!this.userService.getAuthorities().contains(authority)) {
            this.userService.createAuthority(authority);
        }
    }

    public void setRootAdminUser(User rootAdminUser) {
        this.rootAdminUser = rootAdminUser;
    }

    public void setModuleAdminUser(User moduleAdminUser) {
        this.moduleAdminUser = moduleAdminUser;
    }

    public void afterPropertiesSet() throws Exception {
        StringBuilder logMsg;
        if (this.rootAdminUser != null) {
            logMsg = new StringBuilder();
            this.createAuthority(USER_AUTHORITY);
            this.createAuthority(ADMIN_AUTHORITY);
            User _user = this.userDao.getUser(this.rootAdminUser.getUsername());
            if (_user == null) {
                _user = this.rootAdminUser;
                logMsg.append("Created ");
            } else {
                logMsg.append("Updated ");
            }
            _user.grantAuthority(USER_AUTHORITY);
            _user.grantAuthority(ADMIN_AUTHORITY);
            this.userDao.save(_user);
            this.logger.info((Object)(logMsg.toString() + " root admin user[" + this.rootAdminUser.getUsername() + "] and permissioned."));
        }
        if (this.moduleAdminUser != null) {
            logMsg = new StringBuilder();
            this.createAuthority(USER_AUTHORITY);
            Authority userModuleAuthority = new Authority("USER_" + this.moduleName, this.moduleName + " user perms.");
            this.createAuthority(userModuleAuthority);
            Authority adminModuleAuthority = new Authority("ADMIN_" + this.moduleName, this.moduleName + " admin perms.");
            this.createAuthority(adminModuleAuthority);
            User _user = this.userDao.getUser(this.moduleAdminUser.getUsername());
            if (_user == null) {
                _user = this.moduleAdminUser;
                logMsg.append("Created ");
            } else {
                logMsg.append("Updated ");
            }
            _user.grantAuthority(USER_AUTHORITY);
            _user.grantAuthority(userModuleAuthority);
            _user.grantAuthority(adminModuleAuthority);
            this.userDao.save(_user);
            this.logger.info((Object)(logMsg.toString() + " module admin user[" + this.moduleAdminUser.getUsername() + "] and permissioned."));
        }
    }
}

