/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.security.model;

import java.security.Principal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.ikasan.security.model.Role;

public class IkasanPrincipal
implements Principal {
    private Long id;
    private String name;
    private String type;
    private String description;
    private Set<Role> roles;
    private Date createdDateTime;
    private Date updatedDateTime;

    public IkasanPrincipal() {
        long now = System.currentTimeMillis();
        this.createdDateTime = new Date(now);
        this.updatedDateTime = new Date(now);
    }

    public IkasanPrincipal(String name, String type, String description) {
        this.name = name;
        this.type = type;
        this.description = description;
        long now = System.currentTimeMillis();
        this.createdDateTime = new Date(now);
        this.updatedDateTime = new Date(now);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Date getCreatedDateTime() {
        return this.createdDateTime;
    }

    public void setCreatedDateTime(Date createdDateTime) {
        this.createdDateTime = createdDateTime;
    }

    public Date getUpdatedDateTime() {
        return this.updatedDateTime;
    }

    public void setUpdatedDateTime(Date updatedDateTime) {
        this.updatedDateTime = updatedDateTime;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addRole(Role role) {
        if (this.roles != null) {
            if (!this.roles.contains(role)) {
                this.roles.add(role);
            }
        } else {
            this.roles = new HashSet<Role>();
            this.roles.add(role);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IkasanPrincipal that = (IkasanPrincipal)o;
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    @Override
    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "IkasanPrincipal [id=" + this.id + ", name=" + this.name + ", type=" + this.type + ", description=" + this.description + ", roles=" + this.roles + ", createdDateTime=" + this.createdDateTime + ", updatedDateTime=" + this.updatedDateTime + "]";
    }
}

