/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.security.model;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.ikasan.security.model.Policy;

public class Role
implements Comparable<Role> {
    private Long id;
    private String name = "";
    private String description = "";
    private Set<Policy> policies;
    private Date createdDateTime;
    private Date updatedDateTime;

    public Role() {
        long now = System.currentTimeMillis();
        this.createdDateTime = new Date(now);
        this.updatedDateTime = new Date(now);
    }

    public Role(String name, String description) {
        this.description = description;
        this.name = name;
        long now = System.currentTimeMillis();
        this.createdDateTime = new Date(now);
        this.updatedDateTime = new Date(now);
    }

    public void addPolicy(Policy policy) {
        if (this.policies != null) {
            if (!this.policies.contains(policy)) {
                this.policies.add(policy);
            }
        } else {
            this.policies = new HashSet<Policy>();
            this.policies.add(policy);
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getCreatedDateTime() {
        return this.createdDateTime;
    }

    public void setCreatedDateTime(Date createdDateTime) {
        this.createdDateTime = createdDateTime;
    }

    public Date getUpdatedDateTime() {
        return this.updatedDateTime;
    }

    public void setUpdatedDateTime(Date updatedDateTime) {
        this.updatedDateTime = updatedDateTime;
    }

    public Set<Policy> getPolicies() {
        return this.policies;
    }

    public void setPolicies(Set<Policy> policies) {
        this.policies = policies;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Role other = (Role)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "Role [id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", createdDateTime=" + this.createdDateTime + ", updatedDateTime=" + this.updatedDateTime + "]";
    }

    @Override
    public int compareTo(Role role) {
        if (role.hashCode() == this.hashCode()) {
            return 0;
        }
        return role.hashCode() - this.hashCode();
    }
}

