/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.security.service;

import java.util.List;
import org.ikasan.security.model.AuthenticationMethod;
import org.ikasan.security.service.AuthenticationService;
import org.ikasan.security.service.AuthenticationServiceException;
import org.ikasan.security.service.SecurityService;
import org.ikasan.security.service.authentication.AuthenticationProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

public class AuthenticationServiceImpl
implements AuthenticationService {
    private static Logger logger = LoggerFactory.getLogger(AuthenticationServiceImpl.class);
    private AuthenticationProviderFactory<AuthenticationMethod> authenticationProviderFactory;
    private SecurityService securityService;

    public AuthenticationServiceImpl(AuthenticationProviderFactory<AuthenticationMethod> authenticationProviderFactory, SecurityService securityService) {
        this.authenticationProviderFactory = authenticationProviderFactory;
        if (this.authenticationProviderFactory == null) {
            throw new IllegalArgumentException("authenticationProviderFactory cannot be null!");
        }
        this.securityService = securityService;
        if (this.securityService == null) {
            throw new IllegalArgumentException("securityService cannot be null!");
        }
    }

    @Override
    public Authentication login(String username, String password) throws AuthenticationServiceException {
        Authentication authentication = null;
        List<AuthenticationMethod> authMethods = this.securityService.getAuthenticationMethods();
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        for (AuthenticationMethod authMethod : authMethods) {
            if (!authMethod.isEnabled()) continue;
            try {
                AuthenticationProvider authProvider = this.authenticationProviderFactory.getAuthenticationProvider(authMethod);
                authentication = authProvider.authenticate((Authentication)auth);
            }
            catch (Exception exception) {}
        }
        if (authentication == null) {
            AuthenticationProvider authProvider = this.authenticationProviderFactory.getLocalAuthenticationProvider();
            try {
                authentication = authProvider.authenticate((Authentication)auth);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info("Authentication failed for user " + username);
                throw new AuthenticationServiceException("Error authenticating!" + e);
            }
        }
        if (authentication == null) {
            logger.info("Authentication failed for user " + username + ". Authentication is null!!");
            throw new AuthenticationServiceException("Invalid user name or password.");
        }
        if (authentication.getAuthorities() == null || authentication.getAuthorities().size() == 0) {
            logger.info(username + " not authorised for this application!!");
            throw new AuthenticationServiceException("User not authorised for this application.");
        }
        return authentication;
    }

    @Override
    public Authentication authenticateLocal(String username, String password) throws AuthenticationServiceException {
        Authentication authentication = null;
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        AuthenticationProvider authProvider = this.authenticationProviderFactory.getLocalAuthenticationProvider();
        try {
            authentication = authProvider.authenticate((Authentication)auth);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("Authentication failed for user " + username);
            throw new AuthenticationServiceException("Error authenticating!" + e);
        }
        if (authentication == null) {
            logger.info("Authentication failed for user " + username + ". Authentication is null!!");
            throw new AuthenticationServiceException("Invalid user name or password.");
        }
        if (authentication.getAuthorities() == null || authentication.getAuthorities().size() == 0) {
            logger.info(username + " not authorised for this application!!");
            throw new AuthenticationServiceException("User not authorised for this application.");
        }
        return authentication;
    }
}

