/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.security.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import org.ikasan.security.dao.SecurityDao;
import org.ikasan.security.dao.UserDao;
import org.ikasan.security.model.AuthenticationMethod;
import org.ikasan.security.model.IkasanPrincipal;
import org.ikasan.security.model.User;
import org.ikasan.security.service.LdapService;
import org.ikasan.security.service.LdapServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.control.PagedResult;
import org.springframework.ldap.control.PagedResultsCookie;
import org.springframework.ldap.control.PagedResultsDirContextProcessor;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;

public class LdapServiceImpl
implements LdapService {
    private static Logger logger = LoggerFactory.getLogger(LdapServiceImpl.class);
    private SecurityDao securityDao;
    private UserDao userDao;
    private AuthenticationMethod authenticationMethod;
    private PasswordEncoder passwordEncoder;

    public LdapServiceImpl(SecurityDao securityDao, UserDao userDao, PasswordEncoder passwordEncoder) {
        this.securityDao = securityDao;
        if (this.securityDao == null) {
            throw new IllegalArgumentException("securityDao cannot be null!");
        }
        this.userDao = userDao;
        if (this.userDao == null) {
            throw new IllegalArgumentException("userDao cannot be null!");
        }
        this.passwordEncoder = passwordEncoder;
        if (this.userDao == null) {
            throw new IllegalArgumentException("passwordEncoder cannot be null!");
        }
    }

    protected LdapUser getLdapUser(String userName) throws LdapServiceException {
        AuthenticationMethod authenticationMethod = this.getAuthenticationMethod();
        DefaultSpringSecurityContextSource contextSource = this.getContextSource();
        FilterBasedLdapUserSearch userSearch = new FilterBasedLdapUserSearch(authenticationMethod.getLdapUserSearchBaseDn(), "CN={0}", (BaseLdapPathContextSource)contextSource);
        DirContextOperations dir = null;
        try {
            dir = userSearch.searchForUser(userName);
        }
        catch (UsernameNotFoundException e) {
            logger.warn("An exception occurred trying to search for LDAP user: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (RuntimeException e) {
            logger.warn("An exception occurred trying to search for LDAP user: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        String accountType = dir.getStringAttribute(authenticationMethod.getAccountTypeAttributeName());
        LdapUser user = null;
        String email = dir.getStringAttribute(authenticationMethod.getEmailAttributeName());
        String surname = dir.getStringAttribute(authenticationMethod.getSurnameAttributeName());
        String firstName = dir.getStringAttribute(authenticationMethod.getFirstNameAttributeName());
        String accountName = dir.getStringAttribute(authenticationMethod.getUserAccountNameAttributeName());
        if (accountName == null) {
            return null;
        }
        if (email == null || email.length() == 0) {
            email = "no email";
        }
        if (surname == null || surname.length() == 0) {
            surname = "no surname";
        }
        if (firstName == null || firstName.length() == 0) {
            firstName = "no firstname";
        }
        user = new LdapUser();
        user.accountName = accountName.toLowerCase();
        user.email = email;
        user.surname = surname;
        user.accountType = accountType;
        user.firstName = firstName;
        user.department = dir.getStringAttribute(authenticationMethod.getDepartmentAttributeName());
        user.description = dir.getStringAttribute(authenticationMethod.getLdapUserDescriptionAttributeName());
        user.memberOf = dir.getStringAttributes(authenticationMethod.getMemberofAttributeName());
        return user;
    }

    public List<String> getAllLdapUsers() throws LdapServiceException {
        PagedResult result;
        AuthenticationMethod authenticationMethod = this.getAuthenticationMethod();
        DefaultSpringSecurityContextSource contextSource = this.getContextSource();
        contextSource.setBase(authenticationMethod.getLdapUserSearchBaseDn());
        try {
            contextSource.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new LdapServiceException();
        }
        LdapTemplate ldapTemplate = new LdapTemplate((ContextSource)contextSource);
        PagedResultsCookie cookie = null;
        ArrayList<String> results = new ArrayList<String>();
        do {
            result = this.getAllUsers(cookie, ldapTemplate);
            results.addAll(result.getResultList());
        } while ((cookie = result.getCookie()).getCookie() != null);
        logger.debug("Returning users: " + results.size());
        return results;
    }

    protected PagedResult getAllUsers(PagedResultsCookie cookie, LdapTemplate ldapTemplate) {
        PagedResultsDirContextProcessor contextProcessor = new PagedResultsDirContextProcessor(200, cookie);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        List groups = ldapTemplate.search("", this.authenticationMethod.getUserSynchronisationFilter(), searchControls, (AttributesMapper)new ApplicationUserAttributeMapper(), (DirContextProcessor)contextProcessor);
        return new PagedResult(groups, contextProcessor.getCookie());
    }

    public List<String> getAllApplicationSecurity() throws LdapServiceException {
        PagedResult result;
        AuthenticationMethod authenticationMethod = this.getAuthenticationMethod();
        DefaultSpringSecurityContextSource contextSource = this.getContextSource();
        contextSource.setBase(authenticationMethod.getApplicationSecurityBaseDn());
        try {
            contextSource.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new LdapServiceException();
        }
        LdapTemplate ldapTemplate = new LdapTemplate((ContextSource)contextSource);
        PagedResultsCookie cookie = null;
        ArrayList<String> results = new ArrayList<String>();
        do {
            result = this.getAllGroups(cookie, ldapTemplate);
            results.addAll(result.getResultList());
        } while ((cookie = result.getCookie()).getCookie() != null);
        return results;
    }

    protected PagedResult getAllGroups(PagedResultsCookie cookie, LdapTemplate ldapTemplate) {
        PagedResultsDirContextProcessor contextProcessor = new PagedResultsDirContextProcessor(200, cookie);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        List groups = ldapTemplate.search("", this.authenticationMethod.getGroupSynchronisationFilter(), searchControls, (AttributesMapper)new ApplicationSecurityGroupAttributeMapper(), (DirContextProcessor)contextProcessor);
        return new PagedResult(groups, contextProcessor.getCookie());
    }

    public IkasanPrincipal getApplicationSecurity(String userName) throws LdapServiceException {
        AuthenticationMethod authenticationMethod = this.getAuthenticationMethod();
        DefaultSpringSecurityContextSource contextSource = this.getContextSource();
        FilterBasedLdapUserSearch userSearch = new FilterBasedLdapUserSearch(authenticationMethod.getApplicationSecurityBaseDn(), "CN={0}", (BaseLdapPathContextSource)contextSource);
        DirContextOperations dir = null;
        try {
            dir = userSearch.searchForUser(userName);
        }
        catch (UsernameNotFoundException e) {
            return null;
        }
        catch (RuntimeException e) {
            throw new LdapServiceException(e);
        }
        String accountName = dir.getStringAttribute(authenticationMethod.getApplicationSecurityGroupAttributeName());
        String description = dir.getStringAttribute(authenticationMethod.getApplicationSecurityDescriptionAttributeName());
        IkasanPrincipal principal = null;
        if (accountName != null && accountName.length() > 0) {
            principal = new IkasanPrincipal();
            principal.setName(accountName);
            principal.setType("application");
            if (description != null && description.length() > 0) {
                principal.setDescription(description);
            } else {
                principal.setDescription("No description");
            }
        }
        return principal;
    }

    @Override
    public void synchronize(AuthenticationMethod authenticationMethod) throws LdapServiceException {
        this.authenticationMethod = authenticationMethod;
        List<String> applicationSecurities = this.getAllApplicationSecurity();
        for (String applicationSecurity : applicationSecurities) {
            IkasanPrincipal principal = this.securityDao.getPrincipalByName(applicationSecurity);
            if (principal == null) {
                principal = this.getApplicationSecurity(applicationSecurity);
            }
            if (principal == null) continue;
            this.securityDao.saveOrUpdatePrincipal(principal);
        }
        List<String> users = this.getAllLdapUsers();
        for (String username : users) {
            IkasanPrincipal principal;
            LdapUser ldapUser = this.getLdapUser(username);
            if (ldapUser == null) continue;
            ArrayList<IkasanPrincipal> ikasanPrincipals = new ArrayList<IkasanPrincipal>();
            User user = this.userDao.getUser(ldapUser.accountName);
            if (user == null) {
                String encodedPassword = this.passwordEncoder.encodePassword("pa55word", null);
                user = new User(ldapUser.accountName, encodedPassword, ldapUser.email, true);
                user.setDepartment(ldapUser.department);
                user.setFirstName(ldapUser.firstName);
                user.setSurname(ldapUser.surname);
                user.setPrincipals(new HashSet<IkasanPrincipal>(ikasanPrincipals));
                this.userDao.save(user);
                user = this.userDao.getUser(ldapUser.accountName);
            }
            if ((principal = this.securityDao.getPrincipalByName(ldapUser.accountName)) == null) {
                principal = new IkasanPrincipal();
                principal.setName(ldapUser.accountName);
                principal.setType("user");
                if (ldapUser.description == null) {
                    principal.setDescription("No description");
                } else {
                    principal.setDescription(ldapUser.description);
                }
                this.securityDao.saveOrUpdatePrincipal(principal);
            }
            ikasanPrincipals.add(principal);
            if (ldapUser.memberOf != null) {
                for (String name : ldapUser.memberOf) {
                    DistinguishedName dn;
                    String cn;
                    if (!name.contains(this.getAuthenticationMethod().getApplicationSecurityBaseDn()) || (principal = this.securityDao.getPrincipalByName(cn = (dn = new DistinguishedName(name)).getValue("cn"))) == null) continue;
                    ikasanPrincipals.add(principal);
                }
            }
            user.setEmail(ldapUser.email);
            user.setFirstName(ldapUser.firstName);
            user.setSurname(ldapUser.surname);
            user.setDepartment(ldapUser.department);
            user.setPrincipals(new HashSet<IkasanPrincipal>(ikasanPrincipals));
            this.userDao.save(user);
        }
    }

    protected AuthenticationMethod getAuthenticationMethod() throws LdapServiceException {
        if (this.authenticationMethod == null) {
            throw new LdapServiceException("Null AuthenticationMethod!");
        }
        return this.authenticationMethod;
    }

    protected DefaultSpringSecurityContextSource getContextSource() throws LdapServiceException {
        DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(this.authenticationMethod.getLdapServerUrl());
        contextSource.setUserDn(this.authenticationMethod.getLdapBindUserDn());
        contextSource.setPassword(this.authenticationMethod.getLdapBindUserPassword());
        try {
            contextSource.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new LdapServiceException();
        }
        return contextSource;
    }

    protected class LdapUser {
        String accountType;
        String accountName;
        String email;
        String firstName;
        String surname;
        String department;
        String description;
        String[] memberOf;

        protected LdapUser() {
        }

        public String toString() {
            return "LdapUser [accountType=" + this.accountType + ", accountName=" + this.accountName + ", email=" + this.email + ", firstName=" + this.firstName + ", surname=" + this.surname + ", department=" + this.department + ", description=" + this.description + ", memberOf=" + Arrays.toString(this.memberOf) + "]";
        }
    }

    protected class ApplicationUserAttributeMapper
    implements AttributesMapper {
        protected ApplicationUserAttributeMapper() {
        }

        public Object mapFromAttributes(Attributes attributes) throws NamingException {
            return attributes.get("name").get();
        }
    }

    protected class ApplicationSecurityGroupAttributeMapper
    implements AttributesMapper {
        protected ApplicationSecurityGroupAttributeMapper() {
        }

        public Object mapFromAttributes(Attributes attributes) throws NamingException {
            return attributes.get(LdapServiceImpl.this.authenticationMethod.getApplicationSecurityGroupAttributeName()).get();
        }
    }
}

