/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.security.service;

import java.util.List;
import org.ikasan.security.dao.SecurityDao;
import org.ikasan.security.model.AuthenticationMethod;
import org.ikasan.security.model.IkasanPrincipal;
import org.ikasan.security.model.IkasanPrincipalLite;
import org.ikasan.security.model.Policy;
import org.ikasan.security.model.PolicyLink;
import org.ikasan.security.model.PolicyLinkType;
import org.ikasan.security.model.Role;
import org.ikasan.security.model.User;
import org.ikasan.security.service.SecurityService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityServiceImpl
implements SecurityService {
    private static Logger logger = LoggerFactory.getLogger(SecurityServiceImpl.class);
    private SecurityDao securityDao;

    public SecurityServiceImpl(SecurityDao securityDao) {
        this.securityDao = securityDao;
        if (this.securityDao == null) {
            throw new IllegalArgumentException("securityDao cannot be null!");
        }
    }

    @Override
    public IkasanPrincipal createNewPrincipal(String name, String type) {
        IkasanPrincipal principal = new IkasanPrincipal();
        principal.setName(name);
        principal.setType(type);
        principal.setDescription("description");
        this.securityDao.saveOrUpdatePrincipal(principal);
        return principal;
    }

    @Override
    public void savePrincipal(IkasanPrincipal principal) {
        this.securityDao.saveOrUpdatePrincipal(principal);
    }

    @Override
    public Role createNewRole(String name, String description) {
        Role role = new Role();
        role.setName(name);
        role.setDescription(description);
        this.securityDao.saveOrUpdateRole(role);
        return role;
    }

    @Override
    public Policy createNewPolicy(String name, String description) {
        Policy policy = new Policy();
        policy.setName(name);
        policy.setDescription(description);
        this.securityDao.saveOrUpdatePolicy(policy);
        return policy;
    }

    @Override
    public void saveRole(Role role) {
        this.securityDao.saveOrUpdateRole(role);
    }

    @Override
    public void savePolicy(Policy policy) {
        this.securityDao.saveOrUpdatePolicy(policy);
    }

    @Override
    public IkasanPrincipal findPrincipalByName(String name) {
        return this.securityDao.getPrincipalByName(name);
    }

    @Override
    public void deletePrincipal(IkasanPrincipal principal) {
        this.securityDao.deletePrincipal(principal);
    }

    @Override
    public void deleteRole(Role role) {
        this.securityDao.deleteRole(role);
    }

    @Override
    public void deletePolicy(Policy policy) {
        this.securityDao.deletePolicy(policy);
    }

    @Override
    public List<IkasanPrincipal> getAllPrincipals() {
        return this.securityDao.getAllPrincipals();
    }

    @Override
    public List<IkasanPrincipalLite> getAllPrincipalLites() {
        return this.securityDao.getAllPrincipalLites();
    }

    @Override
    public List<IkasanPrincipal> getPrincipalByNameLike(String name) {
        return this.securityDao.getPrincipalByNameLike(name);
    }

    @Override
    public List<Role> getAllRoles() {
        return this.securityDao.getAllRoles();
    }

    @Override
    public List<Policy> getAllPolicies() {
        return this.securityDao.getAllPolicies();
    }

    @Override
    public void saveOrUpdateAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.securityDao.saveOrUpdateAuthenticationMethod(authenticationMethod);
    }

    @Override
    public List<AuthenticationMethod> getAuthenticationMethods() {
        return this.securityDao.getAuthenticationMethods();
    }

    @Override
    public Role findRoleByName(String name) {
        return this.securityDao.getRoleByName(name);
    }

    @Override
    public Policy findPolicyByName(String name) {
        return this.securityDao.getPolicyByName(name);
    }

    @Override
    public List<IkasanPrincipal> getAllPrincipalsWithRole(String roleName) {
        return this.securityDao.getAllPrincipalsWithRole(roleName);
    }

    @Override
    public List<IkasanPrincipal> getPrincipalsByName(List<String> names) {
        return this.securityDao.getPrincipalsByRoleNames(names);
    }

    @Override
    public List<PolicyLinkType> getAllPolicyLinkTypes() {
        return this.securityDao.getAllPolicyLinkTypes();
    }

    @Override
    public List<Policy> getPolicyByNameLike(String name) {
        return this.securityDao.getPolicyByNameLike(name);
    }

    @Override
    public void savePolicyLink(PolicyLink policyLink) {
        this.securityDao.saveOrUpdatePolicyLink(policyLink);
    }

    @Override
    public void deletePolicyLink(PolicyLink policyLink) {
        this.securityDao.deletePolicyLink(policyLink);
    }

    @Override
    public List<Policy> getAllPoliciesWithRole(String roleName) {
        return this.securityDao.getAllPoliciesWithRole(roleName);
    }

    @Override
    public List<Role> getRoleByNameLike(String name) {
        return this.securityDao.getRoleByNameLike(name);
    }

    @Override
    public AuthenticationMethod getAuthenticationMethod(Long id) {
        return this.securityDao.getAuthenticationMethod(id);
    }

    @Override
    public void deleteAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.securityDao.deleteAuthenticationMethod(authenticationMethod);
    }

    @Override
    public long getNumberOfAuthenticationMethods() {
        return this.securityDao.getNumberOfAuthenticationMethods();
    }

    @Override
    public AuthenticationMethod getAuthenticationMethodByOrder(long order) {
        return this.securityDao.getAuthenticationMethodByOrder(order);
    }

    @Override
    public List<User> getUsersAssociatedWithPrincipal(long principalId) {
        return this.securityDao.getUsersAssociatedWithPrincipal(principalId);
    }

    @Override
    public Role getRoleById(Long id) {
        return this.securityDao.getRoleById(id);
    }

    @Override
    public Policy getPolicyById(Long id) {
        return this.securityDao.getPolicyById(id);
    }
}

