/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.security.service;

import java.util.List;
import org.ikasan.security.dao.UserDao;
import org.ikasan.security.model.IkasanPrincipal;
import org.ikasan.security.model.Policy;
import org.ikasan.security.model.Role;
import org.ikasan.security.model.User;
import org.ikasan.security.model.UserLite;
import org.ikasan.security.service.SecurityService;
import org.ikasan.security.service.UserService;
import org.springframework.dao.DataAccessException;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class UserServiceImpl
implements UserService {
    private UserDao userDao;
    private SecurityService securityService;
    private PasswordEncoder passwordEncoder;

    public UserServiceImpl(UserDao userDao, SecurityService securityService, PasswordEncoder passwordEncoder) {
        this.userDao = userDao;
        this.securityService = securityService;
        this.passwordEncoder = passwordEncoder;
    }

    @Override
    public List<User> getUsers() {
        return this.userDao.getUsers();
    }

    @Override
    public List<UserLite> getUserLites() {
        return this.userDao.getUserLites();
    }

    public void changePassword(String oldPassword, String newPassword) {
        throw new UnsupportedOperationException("As administrators can change passwords for other users we have our own userChangePasssword method.");
    }

    public void createUser(UserDetails userDetails) {
        String username = userDetails.getUsername();
        String password = userDetails.getPassword();
        String email = "";
        String firstName = "";
        String surname = "";
        String department = "";
        if (userDetails instanceof User) {
            User tempUser = (User)userDetails;
            email = tempUser.getEmail();
            firstName = tempUser.getFirstName();
            surname = tempUser.getSurname();
            department = tempUser.getDepartment();
        }
        boolean enabled = userDetails.isEnabled();
        if (username == null || "".equals(username)) {
            throw new IllegalArgumentException("userDetails must contain a non empty username");
        }
        if (password == null || "".equals(password)) {
            throw new IllegalArgumentException("userDetails must contain a non empty password");
        }
        if (email == null || "".equals(email)) {
            throw new IllegalArgumentException("user must contain a non empty email address");
        }
        if (this.userExists(username)) {
            throw new IllegalArgumentException("userDetails must contain a unique username");
        }
        String encodedPassword = this.passwordEncoder.encodePassword(password, null);
        User userToCreate = new User(username, encodedPassword, email, enabled);
        userToCreate.setFirstName(firstName);
        userToCreate.setSurname(surname);
        userToCreate.setDepartment(department);
        this.userDao.save(userToCreate);
    }

    public void deleteUser(String username) {
        this.userDao.delete(this.getUserForOperation(username));
    }

    @Override
    public void disableUser(String username) {
        User user = this.getUserForOperation(username);
        user.setEnabled(false);
        this.userDao.save(user);
    }

    @Override
    public void enableUser(String username) {
        User user = this.getUserForOperation(username);
        user.setEnabled(true);
        this.userDao.save(user);
    }

    private User getUserForOperation(String username) throws IllegalArgumentException {
        User user = this.userDao.getUser(username);
        if (user == null) {
            throw new IllegalArgumentException("user does not exist with username [" + username + "]");
        }
        return user;
    }

    public void updateUser(UserDetails userDetails) {
        this.userDao.save((User)userDetails);
    }

    public boolean userExists(String username) {
        return this.userDao.getUser(username) != null;
    }

    @Override
    public User loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        User user = this.userDao.getUser(username);
        if (user == null) {
            throw new UsernameNotFoundException("Unknown username : " + username);
        }
        return user;
    }

    @Override
    public List<Policy> getAuthorities() {
        List<Policy> policies = this.securityService.getAllPolicies();
        return policies;
    }

    @Override
    public void grantAuthority(String username, String authority) {
        User user = this.loadUserByUsername(username);
        Policy nongrantedPolicy = this.securityService.findPolicyByName(authority);
        IkasanPrincipal userPrincipal = this.securityService.findPrincipalByName("user");
        Role userRole = this.securityService.findRoleByName("User");
        user.addPrincipal(userPrincipal);
        userPrincipal.addRole(userRole);
        userRole.addPolicy(nongrantedPolicy);
        this.userDao.save(user);
    }

    @Override
    public void revokeAuthority(String username, String authority) {
        User user = this.loadUserByUsername(username);
        Policy nongrantedPolicy = this.securityService.findPolicyByName(authority);
        user.revokePolicy(nongrantedPolicy);
        this.userDao.save(user);
    }

    @Override
    public void changeUsersPassword(String username, String newPassword, String confirmNewPassword) throws IllegalArgumentException {
        if (!newPassword.equals(confirmNewPassword)) {
            throw new IllegalArgumentException("Passwords do not match, please try again.");
        }
        String encodedPassword = this.passwordEncoder.encodePassword(newPassword, null);
        User user = this.loadUserByUsername(username);
        user.setPassword(encodedPassword);
        user.setEnabled(true);
        this.userDao.save(user);
    }

    @Override
    public void changeUsersEmail(String username, String newEmail) throws IllegalArgumentException {
        User user = null;
        try {
            user = this.loadUserByUsername(username);
        }
        catch (UsernameNotFoundException e) {
            throw new IllegalArgumentException("Username could not be found", e);
        }
        catch (DataAccessException e) {
            throw new IllegalArgumentException("Username could not be found due to a DataAccessException", e);
        }
        user.setEmail(newEmail);
        this.userDao.save(user);
    }

    @Override
    public List<User> getUserByUsernameLike(String username) {
        return this.userDao.getUserByUsernameLike(username);
    }

    @Override
    public List<User> getUserByFirstnameLike(String firstname) {
        return this.userDao.getUserByFirstnameLike(firstname);
    }

    @Override
    public List<User> getUserBySurnameLike(String surname) {
        return this.userDao.getUserBySurnameLike(surname);
    }
}

