/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.security.service.authentication;

import org.ikasan.security.model.AuthenticationMethod;
import org.ikasan.security.service.SecurityService;
import org.ikasan.security.service.UserService;
import org.ikasan.security.service.authentication.AuthenticationProviderFactory;
import org.ikasan.security.service.authentication.LdapAuthenticationProvider;
import org.ikasan.security.service.authentication.LdapLocalAuthenticationProvider;
import org.ikasan.security.service.authentication.LocalAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;

public class AuthenticationProviderFactoryImpl
implements AuthenticationProviderFactory<AuthenticationMethod> {
    private static Logger logger = LoggerFactory.getLogger(AuthenticationProviderFactoryImpl.class);
    private UserService userService;
    private SecurityService securityService;

    public AuthenticationProviderFactoryImpl(UserService userService, SecurityService securityService) {
        this.userService = userService;
        if (this.userService == null) {
            throw new IllegalArgumentException("userService cannot be null!");
        }
        this.securityService = securityService;
        if (this.securityService == null) {
            throw new IllegalArgumentException("securityService cannot be null!");
        }
    }

    @Override
    public AuthenticationProvider getAuthenticationProvider(AuthenticationMethod authMethod) {
        Object authProvider = null;
        if (authMethod == null || authMethod.getMethod().equals("AUTH_METHOD_LOCAL")) {
            authProvider = this.createLocalAuthenticationProvider();
        } else if (authMethod.getMethod().equals("AUTH_METHOD_LDAP")) {
            try {
                authProvider = this.createLdapAuthenticationProvider(authMethod);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (authMethod.getMethod().equals("AUTH_METHOD_LDAP_LOCAL")) {
            try {
                authProvider = this.createLdapLocalAuthenticationProvider(authMethod);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("authMethod not supported: " + authMethod.getMethod());
        }
        return authProvider;
    }

    @Override
    public AuthenticationProvider getLocalAuthenticationProvider() {
        return this.createLocalAuthenticationProvider();
    }

    @Override
    public void testAuthenticationConnection(AuthenticationMethod authMethod) throws Exception {
        if (authMethod == null) {
            return;
        }
        if (authMethod.getMethod().equals("AUTH_METHOD_LOCAL")) {
            return;
        }
        if (authMethod.getMethod().equals("AUTH_METHOD_LDAP")) {
            this.testLdapConnection(authMethod);
        } else if (authMethod.getMethod().equals("AUTH_METHOD_LDAP_LOCAL")) {
            this.testLdapConnection(authMethod);
        } else {
            throw new IllegalArgumentException("authMethod not supported: " + authMethod.getMethod());
        }
    }

    private String testLdapConnection(AuthenticationMethod authMethod) throws Exception {
        DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(authMethod.getLdapServerUrl().trim());
        contextSource.setUserDn(authMethod.getLdapBindUserDn().trim());
        contextSource.setPassword(authMethod.getLdapBindUserPassword().trim());
        contextSource.afterPropertiesSet();
        contextSource.getReadOnlyContext().lookup(authMethod.getLdapBindUserDn());
        return contextSource.getBaseLdapPathAsString();
    }

    private LdapAuthenticationProvider createLdapAuthenticationProvider(AuthenticationMethod authMethod) throws Exception {
        DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(authMethod.getLdapServerUrl().trim());
        contextSource.setUserDn(authMethod.getLdapBindUserDn().trim());
        contextSource.setPassword(authMethod.getLdapBindUserPassword().trim());
        contextSource.afterPropertiesSet();
        FilterBasedLdapUserSearch userSearch = new FilterBasedLdapUserSearch(authMethod.getLdapUserSearchBaseDn().trim(), authMethod.getLdapUserSearchFilter().trim(), (BaseLdapPathContextSource)contextSource);
        BindAuthenticator bindAuthenicator = new BindAuthenticator((BaseLdapPathContextSource)contextSource);
        bindAuthenicator.setUserSearch((LdapUserSearch)userSearch);
        return new LdapAuthenticationProvider(bindAuthenicator, this.securityService, this.userService);
    }

    private LdapLocalAuthenticationProvider createLdapLocalAuthenticationProvider(AuthenticationMethod authMethod) throws Exception {
        DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(authMethod.getLdapServerUrl().trim());
        contextSource.setUserDn(authMethod.getLdapBindUserDn().trim());
        contextSource.setPassword(authMethod.getLdapBindUserPassword().trim());
        contextSource.afterPropertiesSet();
        FilterBasedLdapUserSearch userSearch = new FilterBasedLdapUserSearch(authMethod.getLdapUserSearchBaseDn().trim(), authMethod.getLdapUserSearchFilter().trim(), (BaseLdapPathContextSource)contextSource);
        BindAuthenticator bindAuthenicator = new BindAuthenticator((BaseLdapPathContextSource)contextSource);
        bindAuthenicator.setUserSearch((LdapUserSearch)userSearch);
        return new LdapLocalAuthenticationProvider(bindAuthenicator, this.securityService, this.userService);
    }

    private LocalAuthenticationProvider createLocalAuthenticationProvider() {
        return new LocalAuthenticationProvider(this.securityService, this.userService);
    }
}

