/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.security.util;

import org.ikasan.security.dao.UserDao;
import org.ikasan.security.model.Authority;
import org.ikasan.security.model.User;
import org.ikasan.security.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class InitialisePermission
implements InitializingBean {
    private static Logger logger = LoggerFactory.getLogger(InitialisePermission.class);
    private static String ROLE_USER = "ROLE_USER";
    private static String ROLE_USER_DESC = "Users who may log into the system";
    private static String ROLE_ADMIN = "ROLE_ADMIN";
    private static String ROLE_ADMIN_DESC = "Users who may perform administration functions on the system";
    private static Authority ADMIN_AUTHORITY = new Authority(ROLE_ADMIN, ROLE_ADMIN_DESC);
    private static Authority USER_AUTHORITY = new Authority(ROLE_USER, ROLE_USER_DESC);
    private UserService userService;
    private String moduleName;
    private UserDao userDao;
    private User rootAdminUser;
    private User moduleAdminUser;

    public InitialisePermission(UserService userService, String moduleName, UserDao userDao) {
        this.userService = userService;
        if (userService == null) {
            throw new IllegalArgumentException("userService cannot be 'null'");
        }
        this.userDao = userDao;
        if (userDao == null) {
            throw new IllegalArgumentException("userDao cannot be 'null'");
        }
        this.moduleName = moduleName;
        if (moduleName == null) {
            throw new IllegalArgumentException("moduleName cannot be 'null'");
        }
    }

    public void setRootAdminUser(User rootAdminUser) {
        this.rootAdminUser = rootAdminUser;
    }

    public void setModuleAdminUser(User moduleAdminUser) {
        this.moduleAdminUser = moduleAdminUser;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.rootAdminUser != null) {
            StringBuilder logMsg = new StringBuilder();
            User _user = this.userDao.getUser(this.rootAdminUser.getUsername());
            if (_user == null) {
                _user = this.rootAdminUser;
                logMsg.append("Created ");
            } else {
                logMsg.append("Updated ");
            }
            this.userDao.save(_user);
            logger.info(logMsg.toString() + " root admin user[" + this.rootAdminUser.getUsername() + "] and permissioned.");
        }
    }
}

