/*
 * $Id$
 * $URL$
 * 
 * ====================================================================
 * Ikasan Enterprise Integration Platform
 * 
 * Distributed under the Modified BSD License.
 * Copyright notice: The copyright for this software and a full listing 
 * of individual contributors are as shown in the packaged copyright.txt 
 * file. 
 * 
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer.
 *
 *  - Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution.
 *
 *  - Neither the name of the ORGANIZATION nor the names of its contributors may
 *    be used to endorse or promote products derived from this software without 
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE 
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE 
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 */
package org.ikasan.spec.event;

/**
 * Interface for an EventFactory providing the contract for any event type 
 * creation within Ikasan.
 * 
 * @author Ikasan Development Team
 *
 */
public interface EventFactory<EVENT>
{
    /**
     * Create a new instance of an event with the provided identifier and payload.
     * @param identifier - internal flow event identifier
     * @param payload - data content to be transported
     * @return EVENT
     */
    <IDENTIFIER,PAYLOAD> EVENT newEvent(IDENTIFIER identifier, PAYLOAD payload);

    /**
     * Create a new instance of an event with the provided identifier, related identifier, and payload.
     * @param identifier - internal flow event identifier
     * @param relatedIdentifier - previous identifier this event may have be known by
     * @param payload - data content to be transported
     * @return EVENT
     */
    <IDENTIFIER,PAYLOAD> EVENT newEvent(IDENTIFIER identifier, IDENTIFIER relatedIdentifier, PAYLOAD payload);

    /**
     * Create a new instance of an event with the provided identifier, related identifier, timestamp, and payload.
     * @param identifier
     * @param relatedIdentifier
     * @param timestamp
     * @param payload
     * @param <IDENTIFIER>
     * @param <PAYLOAD>
     * @return
     */
    <IDENTIFIER,PAYLOAD> EVENT newEvent(IDENTIFIER identifier, IDENTIFIER relatedIdentifier, long timestamp, PAYLOAD payload);
}
