/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.systemevent.dao;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.ikasan.model.ArrayListPagedSearchResult;
import org.ikasan.spec.search.PagedSearchResult;
import org.ikasan.spec.systemevent.SystemEvent;
import org.ikasan.spec.systemevent.SystemEventDao;
import org.ikasan.systemevent.model.SystemEventImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class HibernateSystemEventDao
extends HibernateDaoSupport
implements SystemEventDao<SystemEvent> {
    private static final Logger logger = LoggerFactory.getLogger(HibernateSystemEventDao.class);
    public static final String EXPIRY = "expiry";
    public static final String EVENT_IDS = "eventIds";
    public static final String NOW = "now";
    private static final String HOUSEKEEP_QUERY = "delete SystemEventImpl w where w.expiry <= :expiry";
    public static final String SYSTEM_EVENTS_TO_DELETE_QUERY = "select id from SystemEventImpl se  where se.expiry < :now";
    public static final String SYSTEM_EVENTS_DELETE_QUERY = "delete SystemEventImpl se  where se.id in(:eventIds)";
    public static final String UPDATE_HARVESTED_QUERY = "update SystemEventImpl se set se.harvestedDateTime = :now, se.harvested = 1 where se.id in(:eventIds)";
    private Boolean orderHarvestQuery = false;
    private boolean batchHousekeepDelete = false;
    private Integer housekeepingBatchSize = 100;
    private Integer transactionBatchSize = 1000;
    private String housekeepQuery;

    public HibernateSystemEventDao(boolean batchHousekeepDelete, Integer housekeepingBatchSize, Integer transactionBatchSize) {
        this();
        this.batchHousekeepDelete = batchHousekeepDelete;
        this.housekeepingBatchSize = housekeepingBatchSize;
        this.transactionBatchSize = transactionBatchSize;
    }

    public HibernateSystemEventDao() {
    }

    public void save(SystemEvent systemEvent) {
        this.getHibernateTemplate().save((Object)systemEvent);
    }

    public PagedSearchResult<SystemEvent> find(final int pageNo, final int pageSize, String orderBy, boolean orderAscending, final String subject, final String action, final Date timestampFrom, final Date timestampTo, final String actor) {
        return (PagedSearchResult)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException {
                CriteriaBuilder builder = session.getCriteriaBuilder();
                CriteriaQuery criteriaQuery = builder.createQuery(SystemEvent.class);
                Root root = criteriaQuery.from(SystemEventImpl.class);
                List<Predicate> predicates = this.getCriteria(builder, (Root<SystemEventImpl>)root);
                criteriaQuery.select((Selection)root).where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
                Query query = session.createQuery(criteriaQuery);
                query.setMaxResults(pageSize);
                int firstResult = pageNo * pageSize;
                query.setFirstResult(firstResult);
                List results = query.getResultList();
                Long rowCount = this.rowCount(session);
                return new ArrayListPagedSearchResult(results, firstResult, rowCount.longValue());
            }

            private Long rowCount(Session session) {
                CriteriaBuilder builder = session.getCriteriaBuilder();
                CriteriaQuery metaDataCriteriaQuery = builder.createQuery(Long.class);
                Root root = metaDataCriteriaQuery.from(SystemEventImpl.class);
                List<Predicate> predicates = this.getCriteria(builder, (Root<SystemEventImpl>)root);
                metaDataCriteriaQuery.select((Selection)builder.count((Expression)root)).where(predicates.toArray(new Predicate[predicates.size()]));
                Query metaDataQuery = session.createQuery(metaDataCriteriaQuery);
                List rowCountList = metaDataQuery.getResultList();
                if (!rowCountList.isEmpty()) {
                    return (Long)rowCountList.get(0);
                }
                return new Long(0L);
            }

            private List<Predicate> getCriteria(CriteriaBuilder builder, Root<SystemEventImpl> root) {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (HibernateSystemEventDao.restrictionExists(subject)) {
                    predicates.add(builder.equal((Expression)root.get("subject"), (Object)subject));
                }
                if (HibernateSystemEventDao.restrictionExists(action)) {
                    predicates.add(builder.equal((Expression)root.get("action"), (Object)action));
                }
                if (HibernateSystemEventDao.restrictionExists(actor)) {
                    predicates.add(builder.equal((Expression)root.get("actor"), (Object)actor));
                }
                if (HibernateSystemEventDao.restrictionExists(timestampFrom)) {
                    predicates.add(builder.greaterThan((Expression)root.get("timestamp"), (Comparable)timestampFrom));
                }
                if (HibernateSystemEventDao.restrictionExists(timestampTo)) {
                    predicates.add(builder.lessThan((Expression)root.get("timestamp"), (Comparable)timestampTo));
                }
                return predicates;
            }
        });
    }

    public List<SystemEvent> list(final List<String> subjects, final String actor, final Date timestampFrom, final Date timestampTo) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException {
                CriteriaBuilder builder = session.getCriteriaBuilder();
                CriteriaQuery criteriaQuery = builder.createQuery(SystemEvent.class);
                Root root = criteriaQuery.from(SystemEventImpl.class);
                List<Predicate> predicates = this.getCriteria(builder, (Root<SystemEventImpl>)root);
                criteriaQuery.select((Selection)root).where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
                Query query = session.createQuery(criteriaQuery);
                List results = query.getResultList();
                return results;
            }

            private List<Predicate> getCriteria(CriteriaBuilder builder, Root<SystemEventImpl> root) {
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                if (HibernateSystemEventDao.restrictionExists(subjects)) {
                    predicates.add(root.get("subject").in((Collection)subjects));
                }
                if (HibernateSystemEventDao.restrictionExists(actor)) {
                    predicates.add(builder.equal((Expression)root.get("actor"), (Object)actor));
                }
                if (HibernateSystemEventDao.restrictionExists(timestampFrom)) {
                    predicates.add(builder.greaterThan((Expression)root.get("timestamp"), (Comparable)timestampFrom));
                }
                if (HibernateSystemEventDao.restrictionExists(timestampTo)) {
                    predicates.add(builder.lessThan((Expression)root.get("timestamp"), (Comparable)timestampTo));
                }
                return predicates;
            }
        });
    }

    static boolean restrictionExists(Object restrictionValue) {
        return restrictionValue != null && !"".equals(restrictionValue);
    }

    public void deleteExpired() {
        if (!this.batchHousekeepDelete) {
            this.getHibernateTemplate().execute(session -> {
                Query query = session.createQuery(HOUSEKEEP_QUERY);
                query.setParameter(EXPIRY, (Object)new Date());
                query.executeUpdate();
                return null;
            });
        } else {
            this.batchHousekeepDelete();
        }
    }

    private void batchHousekeepDelete() {
        logger.debug("SystemEvent called batchHousekeepDelete");
        for (int numberDeleted = 0; this.housekeepablesExist() && numberDeleted < this.transactionBatchSize; numberDeleted += this.housekeepingBatchSize.intValue()) {
            this.getHibernateTemplate().execute(session -> {
                Query query = session.createQuery(SYSTEM_EVENTS_TO_DELETE_QUERY);
                query.setParameter(NOW, (Object)new Date());
                query.setMaxResults(this.housekeepingBatchSize.intValue());
                List wiretapEventIds = query.list();
                if (wiretapEventIds.size() > 0) {
                    query = session.createQuery(SYSTEM_EVENTS_DELETE_QUERY);
                    query.setParameterList(EVENT_IDS, (Collection)wiretapEventIds);
                    query.executeUpdate();
                }
                return null;
            });
        }
    }

    public boolean housekeepablesExist() {
        return (Boolean)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(Long.class);
            Root root = criteriaQuery.from(SystemEventImpl.class);
            criteriaQuery.select((Selection)builder.count((Expression)root)).where((Expression)builder.lessThan((Expression)root.get(EXPIRY), (Comparable)new Date()));
            Query query = session.createQuery(criteriaQuery);
            List rowCountList = query.getResultList();
            Long rowCount = new Long(0L);
            if (!rowCountList.isEmpty()) {
                rowCount = (Long)rowCountList.get(0);
            }
            logger.debug(rowCount + ", SystemEvent housekeepables exist");
            return new Boolean(rowCount > 0L);
        });
    }

    public boolean isBatchHousekeepDelete() {
        return this.batchHousekeepDelete;
    }

    public void setBatchHousekeepDelete(boolean batchHousekeepDelete) {
        this.batchHousekeepDelete = batchHousekeepDelete;
    }

    public Integer getHousekeepingBatchSize() {
        return this.housekeepingBatchSize;
    }

    public void setHousekeepingBatchSize(Integer housekeepingBatchSize) {
        this.housekeepingBatchSize = housekeepingBatchSize;
    }

    public void setTransactionBatchSize(Integer transactionBatchSize) {
        this.transactionBatchSize = transactionBatchSize;
    }

    public void setHousekeepQuery(String housekeepQuery) {
        this.housekeepQuery = housekeepQuery;
    }

    public List<SystemEvent> getHarvestableRecords(int harvestingBatchSize) {
        return (List)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder builder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(SystemEvent.class);
            Root root = criteriaQuery.from(SystemEventImpl.class);
            criteriaQuery.select((Selection)root).where((Expression)builder.equal((Expression)root.get("harvestedDateTime"), (Object)0));
            if (this.orderHarvestQuery.booleanValue()) {
                criteriaQuery.orderBy(new Order[]{builder.asc((Expression)root.get("timestamp"))});
            }
            Query query = session.createQuery(criteriaQuery);
            query.setMaxResults(harvestingBatchSize);
            return query.getResultList();
        });
    }

    public void updateAsHarvested(List<SystemEvent> events) {
        this.getHibernateTemplate().execute(session -> {
            List extractedEventIds = events.stream().map(s -> s.getId()).collect(Collectors.toList());
            List partitionedIds = Lists.partition(extractedEventIds, (int)300);
            for (List eventIds : partitionedIds) {
                Query query = session.createQuery(UPDATE_HARVESTED_QUERY);
                query.setParameter(NOW, (Object)System.currentTimeMillis());
                query.setParameterList(EVENT_IDS, (Collection)eventIds);
                query.executeUpdate();
            }
            return null;
        });
    }

    public Boolean getOrderHarvestQuery() {
        return this.orderHarvestQuery;
    }

    public void setOrderHarvestQuery(Boolean orderHarvestQuery) {
        this.orderHarvestQuery = orderHarvestQuery;
    }
}

