/*
 * Decompiled with CFR 0.152.
 */
package org.ikasan.systemevent.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.ikasan.spec.harvest.HarvestService;
import org.ikasan.spec.housekeeping.HousekeepService;
import org.ikasan.spec.module.Module;
import org.ikasan.spec.module.ModuleContainer;
import org.ikasan.spec.search.PagedSearchResult;
import org.ikasan.spec.systemevent.SystemEvent;
import org.ikasan.spec.systemevent.SystemEventDao;
import org.ikasan.spec.systemevent.SystemEventService;
import org.ikasan.systemevent.model.SystemEventImpl;
import org.ikasan.systemevent.service.SystemEventServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class SystemEventServiceImpl
implements SystemEventService<SystemEvent>,
InitializingBean,
HousekeepService,
HarvestService<SystemEvent> {
    private static Logger logger = LoggerFactory.getLogger(SystemEventServiceImpl.class);
    private SystemEventDao systemEventDao;
    private Long eventExpiryMinutes;
    private ModuleContainer moduleContainer;
    private SystemEventServiceConfiguration systemEventServiceConfiguration;

    public SystemEventServiceImpl(SystemEventDao systemEventDao, Long eventExpiryMinutes) {
        this.systemEventDao = systemEventDao;
        this.eventExpiryMinutes = eventExpiryMinutes;
    }

    public SystemEventServiceImpl(SystemEventDao systemEventDao, Long eventExpiryMinutes, ModuleContainer moduleContainer) {
        this.systemEventDao = systemEventDao;
        this.eventExpiryMinutes = eventExpiryMinutes;
        this.moduleContainer = moduleContainer;
    }

    public void logSystemEvent(String subject, String action, String actor) {
        Date now = new Date();
        Date expiry = null;
        if (this.eventExpiryMinutes != null) {
            expiry = new Date(now.getTime() + 60000L * this.eventExpiryMinutes);
        }
        if (subject.length() > 1024) {
            subject = subject.substring(0, 1024);
        }
        this.systemEventDao.save((Object)new SystemEventImpl(subject, action, now, actor, expiry));
    }

    public void logSystemEvent(String moduleName, String subject, String action, String actor) {
        Date now = new Date();
        Date expiry = null;
        if (this.eventExpiryMinutes != null) {
            expiry = new Date(now.getTime() + 60000L * this.eventExpiryMinutes);
        }
        if (subject.length() > 1024) {
            subject = subject.substring(0, 1024);
        }
        SystemEventImpl systemEvent = new SystemEventImpl(subject, action, now, actor, expiry);
        systemEvent.setModuleName(moduleName);
        this.systemEventDao.save((Object)systemEvent);
    }

    public PagedSearchResult<SystemEvent> listSystemEvents(int pageNo, int pageSize, String orderBy, boolean orderAscending, String subject, String action, Date timestampFrom, Date timestampTo, String actor) {
        return this.systemEventDao.find(pageNo, pageSize, orderBy, orderAscending, subject, action, timestampFrom, timestampTo, actor);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.systemEventDao != null && this.systemEventServiceConfiguration != null) {
            this.systemEventDao.setBatchHousekeepDelete(this.systemEventServiceConfiguration.isBatchHousekeepDelete());
            this.systemEventDao.setHousekeepingBatchSize(Integer.valueOf(this.systemEventServiceConfiguration.getHousekeepingBatchSize()));
            this.systemEventDao.setTransactionBatchSize(Integer.valueOf(this.systemEventServiceConfiguration.getTransactionBatchSize()));
        }
    }

    public SystemEventServiceConfiguration getSystemEventServiceConfiguration() {
        return this.systemEventServiceConfiguration;
    }

    public void setSystemEventServiceConfiguration(SystemEventServiceConfiguration systemEventServiceConfiguration) {
        this.systemEventServiceConfiguration = systemEventServiceConfiguration;
    }

    public List<SystemEvent> listSystemEvents(List<String> subjects, String actor, Date timestampFrom, Date timestampTo) {
        return this.systemEventDao.list(subjects, actor, timestampFrom, timestampTo);
    }

    public boolean housekeepablesExist() {
        return this.systemEventDao.housekeepablesExist();
    }

    public void setHousekeepingBatchSize(Integer housekeepingBatchSize) {
        this.systemEventDao.setHousekeepingBatchSize(housekeepingBatchSize);
    }

    public void setTransactionBatchSize(Integer transactionBatchSize) {
        this.systemEventDao.setTransactionBatchSize(transactionBatchSize);
    }

    public void housekeep() {
        long before = System.currentTimeMillis();
        this.systemEventDao.deleteExpired();
        long after = System.currentTimeMillis();
        logger.debug("housekeep completed in [" + (after - before) + "]ms");
    }

    public List<SystemEvent> harvest(int transactionBatchSize) {
        ArrayList<SystemEvent> systemEvents = new ArrayList<SystemEvent>(this.systemEventDao.getHarvestableRecords(transactionBatchSize));
        if (this.moduleContainer != null && !this.moduleContainer.getModules().isEmpty()) {
            systemEvents.forEach(systemEvent -> systemEvent.setModuleName(((Module)this.moduleContainer.getModules().stream().findFirst().get()).getName()));
        }
        return systemEvents;
    }

    public boolean harvestableRecordsExist() {
        return true;
    }

    public void saveHarvestedRecord(SystemEvent harvestedRecord) {
        this.systemEventDao.save((Object)harvestedRecord);
    }

    public void updateAsHarvested(List<SystemEvent> events) {
        this.systemEventDao.updateAsHarvested(events);
    }
}

